%define idmetaversion %(. ./IDMETA; echo $VERSION|tr -d '\n')
%define is_centos5 %(grep 'release 5' /etc/redhat-release >/dev/null && echo 1 || echo 0)
%define xulrunnerver 31.1.1esr
%define xulrunnertar firefox-%{xulrunnerver}.source.tar.bz2
%define pythonver 2.7.6
%define pythondir Python-%{pythonver}
%define pythontar %{pythondir}.tgz
%define mozilladir mozilla-esr31
Summary: Xulrunner for CF
Name: cf-xulrunner
Version: %{idmetaversion}
Release: 1indexdata
BuildRequires: gcc gcc-c++ pkgconfig
# BuildRequires: xorg-x11-devel 
BuildRequires: zip unzip
%if %is_centos5
BuildRequires: python26
%endif
BuildRequires: mesa-libGL-devel
BuildRequires: wget
BuildRequires: gtk2-devel
BuildRequires: libXt-devel
BuildRequires: alsa-lib-devel
BuildRequires: autoconf213
License: BSD
Group: Applications/Internet
Vendor: Index Data ApS <info@indexdata.dk>
Source: cf-xulrunner-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Packager: Adam Dickmeiss <adam@indexdata.dk>
URL: http://www.indexdata.com/connector-framework

%description
Xulrunner tailored for the Connector Framework.

%package -n cf-xulrunner31
Summary: Xulrunner libraries
Group: Applications/Internet

%description -n cf-xulrunner31
This is Xulrunner libraries tailored for the Connector Framework.

%package -n cf-xulrunner31-devel
Summary: Development package for cf-xulrunner31
Group: Applications/Internet
Requires: cf-xulrunner31 = %{version}
%description -n cf-xulrunner31-devel
Xulrunner development libraries.

%prep
%setup

%build
if ! gunzip -t %{pythontar}; then
	wget -q http://ftp.indexdata.dk/pub/support/%{pythontar}
fi
rm -fr %{pythondir}
tar zxf %{pythontar}
PDIR=`pwd`/python
mkdir $PDIR
cd %{pythondir}
./configure --prefix=$PDIR
make
make install
cd ..
if ! bunzip2 -t %{xulrunnertar}; then
	wget -q http://ftp.indexdata.dk/pub/support/%{xulrunnertar}
fi
rm -fr %{mozilladir}
tar jxf %{xulrunnertar}
cat mozconfig.rpm mozconfig >%{mozilladir}/.mozconfig
cd %{mozilladir}
for p in ../*.patch; do patch -p0 < $p; done
autoconf-2.13
PATH=${PDIR}/bin:$PATH
make -f client.mk build
cd ..

# ------ INSTALL --------
%install
rm -fr ${RPM_BUILD_ROOT}
cd %{mozilladir}
make -f client.mk install DESTDIR=${RPM_BUILD_ROOT}
rm -fr ${RPM_BUILD_ROOT}/usr/cf-xulrunner/bin

%clean
rm -fr ${RPM_BUILD_ROOT}

%files -n cf-xulrunner31
%defattr(-,root,root)
/usr/cf-xulrunner/lib64/xulrunner-31.0
%files -n cf-xulrunner31-devel
%defattr(-,root,root)
/usr/cf-xulrunner/include
/usr/cf-xulrunner/lib64/pkgconfig
/usr/cf-xulrunner/lib64/xulrunner-devel-31.0
/usr/cf-xulrunner/share
