use strict;
use warnings;

use Test::More tests => 17;
BEGIN { use_ok('IndexData::Utils::PersistentCounter') };

my $file = "/tmp/id-u-pc-$$";
my $counter = new IndexData::Utils::PersistentCounter($file);
ok(!defined $counter, "can't open non-existent counter");

$counter = new IndexData::Utils::PersistentCounter("/x/$file", 1);
ok(!defined $counter, "can't create counter in silly place");

$counter = new IndexData::Utils::PersistentCounter($file, 1);
my $detail = defined $counter ? '' : ": $!@";
ok(defined $counter, "created new counter$detail");

foreach my $i (1..5) {
    my $n = $counter->next();
    ok(defined $n, "n is defined");
    ok($n == $i, "n has correct value $i");
}

# Three processes making five accesses each
for (my $i = 0; $i < 3; $i ++) {
    my $pid = fork();
    if ($pid == 0) {
	# child
	foreach my $j (1..5) {
	    my $n = $counter->next();
	    print "# child ", $i+1, ", access ", $j+1, ": value is $n\n";
	}
	exit 0;
    } else {
	print "# process $pid started\n";
    }
}

while ((my $pid = wait()) > 0) {
    print "# process $pid completed\n";
}

my $n = $counter->next();
ok($n == 21, "n == 21 on 21 total access (n=$n)");

my $ok = $counter->delete();
ok($ok, "deleted counter file");
$counter = new IndexData::Utils::PersistentCounter($file);
ok(!defined $counter, "can't open deleted counter");
