<?xml version="1.0"?>
<!--
    $Id: manage_help.xsl,v 1.2 2007-06-01 11:49:57 sondberg Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:task="http://www.indexdata.com/OAI-PMH/1.0"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>


  <xsl:template name="insert-body">
    <h4>Help</h4>

    <h5>Users and IP ranges</h5>
    <p>End users can access the userinterface in 2 different modes. If they're
    coming from a known IP range, they will get authorized, or if they login
    using a known username/password they will get authorized too. User accounts
    and IP range management is performed on
    <b><a href="?page=users">this page</a></b>.</p>

    <h5>Authorization groups</h5>
    <p>For each user or IP range, an access group (or authorization group)
    should be associated. Through such an access group, the user/IP range is 
    associated to resources (backend targets). You can edit authorization groups
    <b><a href="?page=group">here</a></b>.</p>

    <h5>Resources</h5>
    <p>The resources are maintained on it's own
    <b><a href="?page=targets">page</a></b>. For each resource, there is an
    edit button which brings you to the detailed resource editor. Here you can
    specify target name, connection string (host:port/database). Record syntax
    is the record syntax with which records are retrieved from the resource.
    Query Encoding Character Set is a specification of how to normalize records
    from this resource. It's specified like this: type;encoding. Type is either
    iso2709 (marc records) or xml. Encoding can be any encoding understood by
    the iconv library.</p>

    <h5>CCL maps</h5>
    <p>The system must know how to map a user query to a native query understood
    by the local resource. This is specified in the <b><a href="?page=ccl">CCL
    maps</a></b>.</p>

    <h5>Categories</h5>
    <p>Each target can be associated to a number of categories which are meant
    to be used for grouping of targets in the end user interface (target
    selection). You can edit the category tree
    <b><a href="?page=cats">here</a></b>.</p>

    <h5>OAI Harvesting</h5>
    <p>Some of the resources registered in this system can be
    <a href="http://openarchives.org/">OAI harvested</a> resources. This is
    realized by specifying a number of OAI harvesting tasks on
    <b><a href="?page=oai">this page</a></b>. Each of these tasks specify a
    periodical harvesting of an OAI repository.</p>
    <p>On the OAI Harvesting page you have to specify the base URL of the OAI
    repository, and the name of the repository, how often the repository should
    be harvested, and finally to which Z39.50 database the results should be
    ingested (using Z39.50 extended services).</p>


  </xsl:template>


</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
