<!--
    $Id: manage_ranges.xsl,v 1.2 2007-05-23 18:07:43 jakub Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  <xsl:variable name="rangeid" select="string($input/data/@rangeid)"/>
  <xsl:variable name="range_form" select="$input/subtree[@name = 'range']"/>

  <xsl:template name="insert-body">
    <h3>Access management (IP ranges).</h3>

    <form name="rangeForm" method="post">
      <input type="hidden" name="page" value="{$page}"/>
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="rangeid" value="null"/>

      <xsl:choose>

        <xsl:when test="$action = 'editrange'">
          <br/>
          <b>Edit IP range:</b>
          <br/>
          <br/>
          <xsl:choose>

            <xsl:when test="$range_form">
              <xsl:call-template name="insert-range-data">
                <xsl:with-param name="range" select="$range_form/*"/>
              </xsl:call-template>
            </xsl:when>

            <xsl:otherwise>
              <xsl:call-template name="insert-range-data">
                <xsl:with-param name="range"
                   select="php:function('get_range_data', $rangeid)/*"/>
              </xsl:call-template>
            </xsl:otherwise>

          </xsl:choose>
        </xsl:when>

        <xsl:when test="$action = 'addrange'">
          <br/>
          <b>Add a new IP range:</b>
          <br/>
          <br/>
          <xsl:call-template name="insert-range-data">
            <xsl:with-param name="range" select="/*/defaultRange"/>
          </xsl:call-template>
        </xsl:when>

        <xsl:otherwise>
          <xsl:call-template name="insert-range-list"/>
        </xsl:otherwise>

      </xsl:choose>
      
    </form>

  </xsl:template>

  <xsl:template name="insert-range-list">
    
    <input type="button" value="Add range"
      onclick="set_action(document.rangeForm, 'addrange')"/>

    <ul>
      <xsl:for-each select="php:function('get_ranges_list')/*/*">
        <li>
          <xsl:value-of select="@name"/>
          <input type="button" value="Edit" 
            onclick="set_action(document.rangeForm, 'editrange', '{@id}')"/>
          <input type="button" value="Delete"
            onclick="set_action(document.rangeForm, 'deleterange', '{@id}')"/>
        </li>
      </xsl:for-each>
    </ul>
        
    <input type="button" value="Add range"
        onclick="set_action(document.rangeForm, 'addrange')"/>

  </xsl:template>

  <xsl:template name="insert-range-data">
    <xsl:param name="range"/>
      
      <table>
        <tr>  
          <td><b>IP range name:</b></td>
          <td><input type="text" name="range[name]" value="{$range/@name}" /></td>
        </tr>
        <tr>
          <td><b>IP lower:</b></td>
          <td><input type="text" name="range[lower]" value="{$range/@lower}" /></td>
        </tr>
        <tr>
          <td><b>IP upper:</b></td>
          <td><input type="text" name="range[upper]" value="{$range/@upper}" /></td>
        </tr>
        <tr>
          <td><b>Access group:</b></td>
          <td>
            <select name="range[group_id]">
              <option value="">- Select group</option>
              <xsl:for-each select="php:function('get_groups_list')/*/*">
                <option value="{@id}">
                  <xsl:if test="$range/@group_id = @id">
                    <xsl:attribute name="selected">selected</xsl:attribute>
                  </xsl:if>
                  <xsl:value-of select="@name"/>
                </option>
              </xsl:for-each>
            </select>
          </td>
        </tr>

        <tr>
          <td colspan="3">
            <br/>
            <input type="button" value="Save" 
              onclick="set_action(document.rangeForm, 'saverange', '{$rangeid}' )"/>
            
            <xsl:if test="$action!='addrange'">
              <input type="button" value="Delete"
                onclick="set_action(document.rangeForm, 'deleterange', {$rangeid} )"/>
            </xsl:if>

            <input type="button" value="Cancel"
               onclick="set_action(document.rangeForm, 'switchpage')"/>
          </td>
        </tr>
      
     </table>

        <!--not valid any more
        <xsl:call-template name="insert-group-selector">
          <xsl:with-param name="groups"
            select="php:function('get_groups_list_sel_range_id', $rangeid)/*"/>
        </xsl:call-template>
        -->

  </xsl:template>


</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
