var Register = function (divId, serviceUrl) {
  this._surface = document.getElementById(divId);
  this._service = serviceUrl || null;
}

Register.prototype = {
  onRegFormSbm: function (form) {
    var context = this;
    this.register(form.reglogin.value, form.regemail.value, form.regname.value,
      form.reginstit.value, form.regcode.value, function () {
        context.cleanRegForm(form);
        $(context._surface).hide();
      });
  },
  cleanRegForm: function (form) {
    form.reglogin.value = '';
    form.regemail.value = '';
    form.regname.value = '';
    form.reginstit.value = '';
    form.regcode.value = '';
  },
  register: function (login, email, name, instit, code, success, failure) {
    var doc = document.newXmlDoc('register');
    var reg = doc.documentElement;
    reg.setAttribute('login', login);
    reg.setAttribute('email', email);
    reg.setAttribute('name', name);
    reg.setAttribute('institution', instit);
    var request = new pzHttpRequest(this._service);
    request.post({'command': 'register', 'action': 'signup', 'code': code}, doc,
      function(re) {
        var m = re.getElementsByTagName('message').length ?
          re.getElementsByTagName('message')[0].firstChild.nodeValue : "";
        if (re.getElementsByTagName('status').length
         && re.getElementsByTagName('status')[0].firstChild.nodeValue == 'OK') {
          alert(m);
          if (typeof success == "function") success();
        } else {
          alert(m);
          if (typeof failure == "function") failure();
        }
      }
    );
  },
  remind: function (email) {
    var request = new pzHttpRequest(this._service);
     request.get({'command': 'register', 'action': 'remind', 'email': email},
      function(re) {
        var m = re.getElementsByTagName('message').length ?
          re.getElementsByTagName('message')[0].firstChild.nodeValue : "";
        if (re.getElementsByTagName('status').length
         && re.getElementsByTagName('status')[0].firstChild.nodeValue == 'OK') {
          alert(m);
        } else {
          alert(m);
        }
      }
    );
  }
}
