<?php

/* $Id: Pz2Settings.class.php,v 1.15 2009-10-09 09:26:46 jakub Exp $
 * -----------------------------------------------------------------------
 * Pz2 dynamic configuration class
 */


class Pz2Settings
{
    private $options;
    private $settings = '';

    public function  getSettings ()
    {
        $this->encode();
        return $this->settings;
    }
    
    public function setOption ($targetid, $key, $value)
    {
        if ( !isset($this->options[$targetid]) )
            $this->options[$targetid] = array();

        $this->options[$targetid][$key] = $value;
    }

    public function populate ($zTargetCollection)
    {
       foreach ($zTargetCollection as $entry ) {
            $target = $entry->getTarget();
            $zuser = $entry->getZUser();
            $zpass = $entry->getZPass();
            $targetId = urlencode($target->getConnString());
            $url_recipe = $target->getUrlRecipe();
            $z_proxy = $target->getProxyConnString();
            $element_set = $target->getElementSet();
            $sru_method = $target->getSruMethod();
            $sru_version = $target->getSruVersion();
            
            $this->setOption($targetId, 'pz:name', $target->getTargetName());
            $this->setOption($targetId, 'pz:nativesyntax',
                             $target->getRecEnc());
            $this->setOption($targetId, 'pz:queryencoding',
                             $target->getQueryEnc());
            $this->setOption($targetId, 'pz:requestsyntax',
                             $target->getReqSyn());

            if (strlen($z_proxy))
                $this->setOption($targetId, 'pz:zproxy', $z_proxy);

            if (strlen($element_set))
                $this->setOption($targetId, 'pz:elements', $element_set);

            $xslt_trans = $target->getXslt();
            if ( !isset( $xslt_trans ) || $xslt_trans == '' )
                $xslt_trans = "auto";
            
            $this->setOption($targetId, 'pz:xslt', $xslt_trans );
            $this->setOption($targetId, 'source-transform', 
              str_replace('.xsl', "", $xslt_trans));

            if ( $zuser && $zpass ) {
                $this->setOption($targetId, 'pz:authentication', 
                                    $zuser.'/'.$zpass );
            }
            else if ( $zuser ) {
                $this->setOption($targetId, 'pz:authentication',
                                    $zuser );
            }

            //if SRU set, pass - this will in turn make pz2 ignore z settings
            if ($sru_method) $this->setOption($targetId, 'pz:sru', $sru_method);
            if ($sru_version) 
              $this->setOption($targetId, 'pz:sru_version', $sru_version);
              

            if ($url_recipe)
                $this->setOption($targetId, 'url_recipe',
                                    $url_recipe );

            $cclmap_id = $target->getCclMapId();
            $c = new Criteria();
            $c->add(CclSpecPeer::CCL_MAP_ID, $cclmap_id);
            $cclspecs = CclSpecPeer::doSelect($c);

            foreach ($cclspecs as $ccl) {
                $this->setOption($targetId,
                                     'pz:cclmap:'. $ccl->getCclQual(),
                                     $ccl->getPqf());
            }
        }
    } 

    private function encode ()
    {
        if ( !isset($this->options) ) {
            throw new Exception('Settings are empty.');
        }

        $uppersep = '';

        foreach ( $this->options as $target => $settings ) {
            $targetSetting = '';
            $sep = '';
            foreach ($settings as $key => $value) {
                $targetSetting .= $sep . $key 
                    . '[' . $target . ']=' . urlencode($value);
                    $sep = '&';
            }
            $this->settings .= $uppersep . $targetSetting;
            $uppersep = '&';
        }
    }
}
