<?php
class TargetList extends DOMDocument
{
    public function __construct()
    {
        $c = new Criteria();
        $c->addAscendingOrderByColumn(TargetPeer::TARGET_NAME);

        $targets = TargetPeer::doSelect($c);

        parent::__construct('1.0', 'utf-8');
        $root = $this->appendChild( new DOMElement('targets') );

        foreach ($targets as $target){
            $targetNode = $root->appendChild(new DOMElement('target'));
            $targetNode->setAttribute('id',$target->getTargetId());
            $targetNode->setAttribute('name', $target->getTargetName());
            $targetNode->setAttribute('conn_string', $target->getConnString());
        }
    }

    public function selectNodesWithGroupId ($groupId)
    {
        $c = new Criteria();
        $c->add(ZAuthPeer::GROUP_ID, $groupId);
        $t2gs = ZAuthPeer::doSelect($c);

        // does it need some tweaking??
        foreach ($t2gs as $t2g) {
            foreach ($this->getElementsByTagName('target') as $target) {               
                if ($target->getAttribute('id') == $t2g->getTargetId()) {
                    $target->setAttribute('zuser', $t2g->getZUser() );
                    $target->setAttribute('zpass', $t2g->getZPass() );
                    $target->setAttribute('selected','true');
                }
            }
        }
    }
}
