<?php
class UsersList extends DOMDocument
{
    public function __construct()
    {
        $c = new Criteria();
        $c->addAscendingOrderByColumn(UserPeer::USER_NAME);
        $users = UserPeer::doSelect($c);

        parent::__construct('1.0', 'utf-8');
        $root = $this->appendChild( new DOMElement('users') );

        foreach ($users as $user){
            $userNode = $root->appendChild( new DOMElement('user') );
            $userNode->setAttribute( 'id', $user->getUserId() );
            $userNode->setAttribute( 'name', $user->getUserName() );
        }
    }
}
