<?php

/*
 *  $Id: PHP5NestedSetPeerBuilder.php 602 2007-03-07 17:52:53Z hans $
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the LGPL. For more information please see
 * <http://propel.phpdb.org>.
 */

require_once 'propel/engine/builder/om/PeerBuilder.php';

/**
 * Generates a PHP5 tree nested set Peer class for user object model (OM).
 *
 * This class produces the base tree nested set object class (e.g. BaseMyTable) which contains all
 * the custom-built accessor and setter methods.
 *
 * This class replaces the Node.tpl, with the intent of being easier for users
 * to customize (through extending & overriding).
 *
 * @author     heltem <heltem@o2php.com>
 * @package    propel.engine.builder.om.php5
 */
class PHP5NestedSetPeerBuilder extends PeerBuilder {

	/**
	 * Gets the package for the [base] object classes.
	 * @return     string
	 */
	public function getPackage()
	{
		return parent::getPackage() . ".om";
	}

	/**
	 * Returns the name of the current class being built.
	 * @return     string
	 */
	public function getUnprefixedClassname()
	{
		return $this->getBuildProperty('basePrefix') . $this->getStubObjectBuilder()->getClassname() . 'NestedSetPeer';
	}

	/**
	 * Adds the include() statements for files that this class depends on or utilizes.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addIncludes(&$script)
	{
		$script .="
require '".$this->getPeerBuilder()->getClassFilePath()."';
";
	} // addIncludes()

	/**
	 * Adds class phpdoc comment and openning of class.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addClassOpen(&$script)
	{

		$table = $this->getTable();
		$tableName = $table->getName();
		$tableDesc = $table->getDescription();

		$script .= "
/**
 * Base static class for performing query operations on the tree contained by the '$tableName' table.
 *
 * $tableDesc
 *";
		if ($this->getBuildProperty('addTimeStamp')) {
			$now = strftime('%c');
			$script .= "
 * This class was autogenerated by Propel " . $this->getBuildProperty('version') . " on:
 *
 * $now
 *";
		}
		$script .= "
 * @package    ".$this->getPackage()."
 */
abstract class ".$this->getClassname()." extends ".$this->getPeerBuilder()->getClassName()." implements BaseNodePeer {
";
	}

	/**
	 * Specifies the methods that are added as part of the basic OM class.
	 * This can be overridden by subclasses that wish to add more methods.
	 * @see        ObjectBuilder::addClassBody()
	 */
	protected function addClassBody(&$script)
	{
		$table = $this->getTable();

		// FIXME
		// - Probably the build needs to be customized for supporting
		// tables that are "aliases".  -- definitely a fringe usecase, though.

		$this->addConstants($script);

		$this->addCreateRoot($script);

		$this->addRetrieveRoot($script);

		$this->addInsertAsFirstChildOf($script);
		$this->addInsertAsLastChildOf($script);
		$this->addInsertAsPrevSiblingOf($script);
		$this->addInsertAsNextSiblingOf($script);

		$this->addInsertRoot($script);
		$this->addInsertParent($script);

		$this->addDeleteRoot($script);
		$this->addDeleteNode($script);

		$this->addMoveToFirstChildOf($script);
		$this->addMoveToLastChildOf($script);
		$this->addMoveToPrevSiblingOf($script);
		$this->addMoveToNextSiblingOf($script);

		$this->addRetrieveFirstChild($script);
		$this->addRetrieveLastChild($script);
		$this->addRetrievePrevSibling($script);
		$this->addRetrieveNextSibling($script);

		$this->addRetrieveTree($script);
		$this->addRetrieveBranch($script);
		$this->addRetrieveChildren($script);
		$this->addRetrieveDescendants($script);
		$this->addRetrieveSiblings($script);
		$this->addRetrieveParent($script);
		$this->addRetrieveUndefined($script);

		$this->addGetLevel($script);
		$this->addGetNumberOfChildren($script);
		$this->addGetNumberOfDescendants($script);
		$this->addGetPath($script);

		$this->addIsValid($script);
		$this->addIsRoot($script);
		$this->addIsLeaf($script);
		$this->addIsChildOf($script);
		$this->addIsChildOfOrSiblingTo($script);
		$this->addIsEqualTo($script);

		$this->addHasParent($script);
		$this->addHasPrevSibling($script);
		$this->addHasNextSibling($script);
		$this->addHasChildren($script);

		$this->addDeleteDescendants($script);

		$this->addGetNode($script);

		$this->addHydrateDescendants($script);
		$this->addHydrateChildren($script);

		$this->addShiftRParent($script);
		$this->addInsertNode($script);
		$this->addUpdateNode($script);

		$this->addShiftRLValues($script);
		$this->addShiftRLRange($script);
	}

	/**
	 * Closes class.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addClassClose(&$script)
	{
		$script .= "
} // " . $this->getClassname() . "
";
	}

	protected function addConstants(&$script)
	{
		$table = $this->getTable();
		$tableName = $table->getName();

		$left_colname = '';
		$right_colname = '';

		foreach ($table->getColumns() as $col) {
			if ($col->isNestedSetLeftKey()) {
				$left_colname = $tableName . '.' . strtoupper($col->getName());
			}

			if ($col->isNestedSetRightKey()) {
				$right_colname = $tableName . '.' . strtoupper($col->getName());
			}

			if (!empty($right_name) && !empty($left_colname)) {
				break;
			}
		}
		$script .= "
	/**
	 * Left column for the set
	 */
	const LEFT_COL = '$left_colname';

	/**
	 * Right column for the set
	 */
	const RIGHT_COL = '$right_colname';
";
	}

	protected function addCreateRoot(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Creates the supplied node as the root node.
	 *
	 * @param      $objectClassname \$node	Propel object for model
	 * @param      PDO \$con		Connection to use.
	 * @return     $objectClassname		Inserted propel object for model
	 * @throws     PropelException
	 */
	static function createRoot(BaseNodeObject \$node = null, PDO \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection($peerClassname::DATABASE_NAME);
		}

		\$newLeft = 1;
		\$newRight = 2;
		return self::insertNode(\$node, \$newLeft, \$newRight, \$con);
	}
";
	}

	protected function addRetrieveRoot(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Returns the root node for a given root id
	 *
	 * @param      int \$rootId		Root id to determine which root node to return
	 * @param      PDO \$con		Connection to use.
	 * @return     $objectClassname			Propel object for root node
	 */
	static function retrieveRoot(\$rootId = 1, PDO \$con = null)
	{
		\$c = new Criteria($peerClassname::DATABASE_NAME);
		\$c->add(self::LEFT_COL, \$rootId, Criteria::EQUAL);

		return $peerClassname::doSelectOne(\$c, \$con);
	}
";
	}

	protected function addInsertAsFirstChildOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Inserts \$child as first child of destination node \$parent
	 *
	 * @param      $objectClassname \$parent	Propel object for parent node
	 * @param      $objectClassname \$child	Propel object for child node
	 * @param      PDO \$con		Connection to use.
	 * @return     object		Inserted propel object for model
	 */
	static function insertAsFirstChildOf(BaseNodeObject \$parent = null, BaseNodeObject \$child = null, PDO \$con = null)
	{
		\$newLeft = \$parent->getLeftValue() + 1;
		\$newRight = \$parent->getLeftValue() + 2;
		\$child->setParentNode(\$parent);
		self::shiftRLValues(\$newLeft, 2, \$con);
		self::shiftRParent(\$parent, 2, \$con);
		return self::insertNode(\$child, \$newLeft, \$newRight, \$con);
	}
";
	}

	protected function addInsertAsLastChildOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Inserts \$child as last child of destination node \$parent
	 *
	 * @param      $objectClassname \$parent	Propel object for parent node
	 * @param      $objectClassname \$child	Propel object for child node
	 * @param      PDO \$con		Connection to use.
	 * @return     object		Inserted propel object for model
	 */
	static function insertAsLastChildOf(BaseNodeObject \$parent = null, BaseNodeObject \$child = null, PDO \$con = null)
	{
		\$newLeft = \$parent->getRightValue();
		\$newRight = \$parent->getRightValue() + 1;
		\$child->setParentNode(\$parent);
		self::shiftRLValues(\$newLeft, 2, \$con);
		self::shiftRParent(\$parent, 2, \$con);
		return self::insertNode(\$child, \$newLeft, \$newRight, \$con);
	}
";
	}

	protected function addInsertAsPrevSiblingOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Inserts \$sibling as previous sibling to destination node \$node
	 *
	 * @param      $objectClassname \$node	Propel object for destination node
	 * @param      $objectClassname \$sibling	Propel object for source node
	 * @param      PDO \$con		Connection to use.
	 * @return     object		Inserted propel object for model
	 */
	static function insertAsPrevSiblingOf(BaseNodeObject \$node = null, BaseNodeObject \$sibling = null, PDO \$con = null)
	{
		\$newLeft = \$node->getLeftValue();
		\$newRight = \$node->getLeftValue() + 1;
		self::shiftRLValues(\$newLeft, 2, \$con);
		\$node->setLeftValue(\$node->getLeftValue() + 2);
		\$node->setRightValue(\$node->getRightValue() + 2);
		return self::insertNode(\$sibling, \$newLeft, \$newRight, \$con);
	}
";
	}

	protected function addInsertAsNextSiblingOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Inserts \$sibling as next sibling to destination node \$node
	 *
	 * @param      $objectClassname \$node	Propel object for destination node
	 * @param      $objectClassname \$sibling	Propel object for source node
	 * @param      PDO \$con		Connection to use.
	 * @return     object		Inserted propel object for model
	 */
	static function insertAsNextSiblingOf(BaseNodeObject \$node = null, BaseNodeObject \$sibling = null, PDO \$con = null)
	{
		\$newLeft = \$node->getRightValue() + 1;
		\$newRight = \$node->getRightValue() + 2;
		self::shiftRLValues(\$newLeft, 2, \$con);
		return self::insertNode(\$sibling, \$newLeft, \$newRight, \$con);
	}
";
	}

	protected function addInsertRoot(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Inserts \$node as root node
	 *
	 * @param      $objectClassname \$node	Propel object as root node
	 * @param      PDO \$con		Connection to use.
	 * @return     object		Inserted propel object for model
	 */
	static function insertRoot(BaseNodeObject \$node = null, PDO \$con = null)
	{
		return $peerClassname::insertParent($peerClassname::retrieveRoot(\$con), \$node, \$con = null);
	}
";
	}

	protected function addInsertParent(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Inserts \$parent as parent to destination node \$child
	 *
	 * @param      $objectClassname \$child	Propel object to become child node
	 * @param      $objectClassname \$parent	Propel object as parent node
	 * @param      PDO \$con		Connection to use.
	 * @return     object		Inserted propel object for model
	 */
	static function insertParent(BaseNodeObject \$child = null, BaseNodeObject \$parent = null, PDO \$con = null)
	{
		self::shiftRLValues(\$child->getLeftValue(), 1, \$con);
		self::shiftRLValues(\$child->getRightValue() + 2, 1, \$con);

		\$newLeft = \$child->getLeftValue();
		\$newRight = \$child->getRightValue() + 2;
		return self::insertNode(\$parent, \$newLeft, \$newRight, \$con);
	}
";
	}

	protected function addDeleteRoot(&$script)
	{
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Delete root node
	 *
	 * @param      PDO \$con		Connection to use.
	 * @return     boolean		Deletion status
	 */
	static function deleteRoot(PDO \$con = null)
	{
		\$root = $peerClassname::retrieveRoot(\$con);
		if ($peerClassname::getNumberOfChildren(\$root) == 1) {
			return $peerClassname::deleteNode(\$root, \$con);
		} else {
			return false;
		}
	}
";
	}

	protected function addDeleteNode(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Delete \$dest node
	 *
	 * @param      $objectClassname \$dest	Propel object node to delete
	 * @param      PDO \$con		Connection to use.
	 * @return     boolean		Deletion status
	 */
	static function deleteNode(BaseNodeObject \$dest = null, PDO \$con = null)
	{
		if (\$dest->getLeftValue() == 1) {
			// deleting root implies conditions (see deleteRoot() method)
			return $peerClassname::deleteRoot(\$con);
		}

		self::shiftRLRange(\$dest->getLeftValue(), \$dest->getRightValue(), -1, \$con);
		self::shiftRLValues(\$dest->getRightValue() + 1, -2, \$con);
		return \$dest->delete(false, \$con);
	}
";
	}

	protected function addMoveToFirstChildOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Moves \$child to be first child of \$parent
	 *
	 * @param      $objectClassname \$parent		Propel object for parent node
	 * @param      $objectClassname \$child		Propel object for child node
	 * @param      PDO \$con		Connection to use.
	 */
	static function moveToFirstChildOf(BaseNodeObject \$parent = null, BaseNodeObject \$child = null, PDO \$con = null)
	{
		\$destLeft = \$parent->getLeftValue() + 1;
		self::updateNode(\$child, \$destLeft, \$con);
	}
";
	}

	protected function addMoveToLastChildOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Moves \$child to be last child of \$parent
	 *
	 * @param      $objectClassname \$parent		Propel object for parent node
	 * @param      $objectClassname \$child		Propel object for child node
	 * @param      PDO \$con		Connection to use.
	 */
	static function moveToLastChildOf(BaseNodeObject \$parent = null, BaseNodeObject \$child = null, PDO \$con = null)
	{
		\$destLeft = \$parent->getRightValue();
		self::updateNode(\$child, \$destLeft, \$con);
	}
";
	}

	protected function addMoveToPrevSiblingOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Moves \$node to be prev sibling to \$dest
	 *
	 * @param      $objectClassname \$dest		Propel object for destination node
	 * @param      $objectClassname \$node		Propel object for source node
	 * @param      PDO \$con		Connection to use.
	 */
	static function moveToPrevSiblingOf(BaseNodeObject \$dest = null, BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$destLeft = \$dest->getLeftValue();
		self::updateNode(\$node, \$destLeft, \$con);
	}
";
	}

	protected function addMoveToNextSiblingOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Moves \$node to be next sibling to \$dest
	 *
	 * @param      $objectClassname \$dest		Propel object for destination node
	 * @param      $objectClassname \$node		Propel object for source node
	 * @param      PDO \$con		Connection to use.
	 */
	static function moveToNextSiblingOf(BaseNodeObject \$dest = null, BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$destLeft = \$dest->getRightValue();
		\$destLeft = \$destLeft + 1;
		self::updateNode(\$node, \$destLeft, \$con);
	}
";
	}

	protected function addRetrieveFirstChild(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets first child for the given node if it exists
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     mixed 		Propel object if exists else false
	 */
	static function retrieveFirstChild(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$c = new Criteria();
		\$c->add(self::LEFT_COL, \$node->getLeftValue() + 1, Criteria::EQUAL);

		return $peerClassname::doSelectOne(\$c, \$con);
	}
";
	}

	protected function addRetrieveLastChild(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets last child for the given node if it exists
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     mixed 		Propel object if exists else false
	 */
	static function retrieveLastChild(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$c = new Criteria();
		\$c->add(self::RIGHT_COL, \$node->getRightValue() - 1, Criteria::EQUAL);

		return $peerClassname::doSelectOne(\$c, \$con);
	}
";
	}

	protected function addRetrievePrevSibling(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets prev sibling for the given node if it exists
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     mixed 		Propel object if exists else false
	 */
	static function retrievePrevSibling(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$c = new Criteria();
		\$c->add(self::RIGHT_COL, \$node->getLeftValue() - 1, Criteria::EQUAL);
		\$prevSibling = $peerClassname::doSelectOne(\$c, \$con);
		\$node->setPrevSibling(\$prevSibling);
		return \$prevSibling;
	}
";
	}

	protected function addRetrieveNextSibling(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets next sibling for the given node if it exists
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     mixed 		Propel object if exists else false
	 */
	static function retrieveNextSibling(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$c = new Criteria();
		\$c->add(self::LEFT_COL, \$node->getRightValue() + 1, Criteria::EQUAL);
		\$nextSibling = $peerClassname::doSelectOne(\$c, \$con);
		\$node->setNextSibling(\$nextSibling);
		return \$nextSibling;
	}
";
	}

	protected function addRetrieveTree(&$script)
	{
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Retrieves the entire tree from root
	 *
	 * @param      PDO \$con		Connection to use.
	 */
	static function retrieveTree(PDO \$con = null)
	{
		\$c = new Criteria();
		\$c->addAscendingOrderByColumn(self::LEFT_COL);
		\$stmt = $peerClassname::doSelectStmt(\$c, \$con);
		if (false !== (\$row = \$stmt->fetch())) {
			\$omClass = $peerClassname::getOMClass(\$row, 0);
			\$cls = substr('.'.\$omClass, strrpos('.'.\$omClass, '.') + 1);

			" . $this->buildObjectInstanceCreationCode('$root', '$cls') . "
			\$root->hydrate(\$row);
			\$root->setLevel(0);
			$peerClassname::hydrateDescendants(\$root, \$stmt);
			$peerClassname::addInstanceToPool(\$root);

			return \$root;
		}
		return false;
	}
";
	}

	protected function addRetrieveBranch(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Retrieves the entire tree from parent \$node
	 *
	 * @param      $objectClassname \$node	Propel object for parent node
	 * @param      PDO \$con		Connection to use.
	 */
	static function retrieveBranch(BaseNodeObject \$node = null, PDO \$con = null)
	{
		return $peerClassname::retrieveDescendants(\$node, \$con);
	}
";
	}

	protected function addRetrieveChildren(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets direct children for the node
	 *
	 * @param      $objectClassname \$node	Propel object for parent node
	 * @param      PDO \$con		Connection to use.
	 */
	static function retrieveChildren(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$c = new Criteria();
		\$c->addAscendingOrderByColumn(self::LEFT_COL);
		\$c->add(self::LEFT_COL, \$node->getLeftValue(), Criteria::GREATER_THAN);
		\$c->addAnd(self::RIGHT_COL, \$node->getRightValue(), Criteria::LESS_THAN);
		\$stmt = $peerClassname::doSelectStmt(\$c, \$con);

		return $peerClassname::hydrateChildren(\$node, \$stmt);
	}
";
	}

	protected function addRetrieveDescendants(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets all descendants for the node
	 *
	 * @param      $objectClassname \$node	Propel object for parent node
	 * @param      PDO \$con		Connection to use.
	 */
	static function retrieveDescendants(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$c = new Criteria();
		\$c->addAscendingOrderByColumn(self::LEFT_COL);
		\$c->add(self::LEFT_COL, \$node->getLeftValue(), Criteria::GREATER_THAN);
		\$c->addAnd(self::RIGHT_COL, \$node->getRightValue(), Criteria::LESS_THAN);
		\$stmt = $peerClassname::doSelectStmt(\$c, \$con);

		$peerClassname::hydrateDescendants(\$node, \$stmt);
		return \$node->_children;
	}
";
	}

	protected function addRetrieveSiblings(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets all siblings for the node
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 */
	static function retrieveSiblings(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$parent = $peerClassname::retrieveParent(\$node, \$con);
		\$siblings = $peerClassname::retrieveChildren(\$parent, \$con);

		return \$siblings;
	}
";
	}

	protected function addRetrieveParent(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets ancestor for the given node if it exists
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     mixed 		Propel object if exists else false
	 */
	static function retrieveParent(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$c = new Criteria();
		\$c1 = \$c->getNewCriterion(self::LEFT_COL, \$node->getLeftValue(), Criteria::LESS_THAN);
		\$c2 = \$c->getNewCriterion(self::RIGHT_COL, \$node->getRightValue(), Criteria::GREATER_THAN);

		\$c1->addAnd(\$c2);

		\$c->add(\$c1);
		\$c->addAscendingOrderByColumn(self::RIGHT_COL);

		\$results = $peerClassname::doSelect(\$c, \$con);

		return array_shift(\$results);
	}
";
	}

	protected function addRetrieveUndefined(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets ancestor for the given node if it exists
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     mixed 		Propel object if exists else false
	 */
	static function retrieveUndefined(PDO \$con = null)
	{
		\$c = new Criteria();
		\$c1 = \$c->getNewCriterion(self::LEFT_COL, 0);
		\$c2 = \$c->getNewCriterion(self::RIGHT_COL, 0);

		\$c1->addAnd(\$c2);

		\$c->add(\$c1);

		\$results = $peerClassname::doSelect(\$c, \$con);

		return \$results;
	}
";
	}

	protected function addGetLevel(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets level for the given node
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     int			Level for the given node
	 */
	static function getLevel(BaseNodeObject \$node = null, PDO \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection($peerClassname::DATABASE_NAME);
		}

		\$sql = \"SELECT COUNT(*) AS level FROM \" . self::TABLE_NAME . \" WHERE \" . self::LEFT_COL . \" < ? AND \" . self::RIGHT_COL . \" > ?\";
		\$stmt = \$con->prepare(\$sql);
		\$stmt->bindParam(1, \$node->getLeftValue(), PDO::PARAM_INT);
		\$stmt->bindParam(2, \$node->getRightValue(), PDO::PARAM_INT);
		\$stmt->execute();
		\$row = \$stmt->fetch();
		return \$row['level'];
	}
";
	}

	protected function addGetNumberOfChildren(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets number of direct children for given node
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     int			Level for the given node
	 */
	static function getNumberOfChildren(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$children = $peerClassname::retrieveChildren(\$node);
		return count(\$children);
	}
";
	}

	protected function addGetNumberOfDescendants(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Gets number of descendants for given node
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     int			Level for the given node
	 */
	static function getNumberOfDescendants(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$right = \$node->getRightValue();
		\$left = \$node->getLeftValue();
		\$num = (\$right - \$left - 1) / 2;
		return \$num;
	}
";
	}

	protected function addGetPath(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Returns path to a specific node as an array, useful to create breadcrumbs
	 *
	 * @param      $objectClassname \$node		Propel object of node to create path to
	 * @param      PDO \$con		Connection to use.
	 * @return     array			Array in order of heirarchy
	 */
	static function getPath(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$path = array();
		\$path[] = \$node;

		while (\$parent = $peerClassname::retrieveParent(\$node, \$con)) {
			\$path[] = \$parent;
			\$node = \$parent;
		}

		return array_reverse(\$path);
	}
";
	}

	protected function addIsValid(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if node is valid
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function isValid(BaseNodeObject \$node = null, PDO \$con = null)
	{
		if (is_object(\$node) && \$node->getRightValue() > \$node->getLeftValue()) {
			return true;
		} else {
			return false;
		}
	}
";
	}

	protected function addIsRoot(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if node is a root
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function isRoot(BaseNodeObject \$node = null, PDO \$con = null)
	{
		return (\$node->getLeftValue()==1);
	}
";
	}

	protected function addIsLeaf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if node is a leaf
	 *
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function isLeaf(BaseNodeObject \$node = null, PDO \$con = null)
	{
		return ((\$node->getRightValue()-\$node->getLeftValue())==1);
	}
";
	}

	protected function addIsChildOf(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if \$node1 is a child of \$node2
	 *
	 * @param      $objectClassname \$node1		Propel object for node
	 * @param      $objectClassname \$node2		Propel object for node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function isChildOf(BaseNodeObject \$node1 = null, BaseNodeObject \$node2 = null, PDO \$con = null)
	{
		return ((\$node1->getLeftValue()>\$node2->getLeftValue()) and (\$node1->getRightValue()<\$node2->getRightValue()));
	}
";
	}

	protected function addIsChildOfOrSiblingTo(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if \$node1 is a child of or equal to \$node2
	 *
	 * @param      $objectClassname \$node1		Propel object for node
	 * @param      $objectClassname \$node2		Propel object for node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function isChildOfOrSiblingTo(BaseNodeObject \$node1 = null, BaseNodeObject \$node2 = null, PDO \$con = null)
	{
		return ((\$node1->getLeftValue()>=\$node2->getLeftValue()) and (\$node1->getRightValue()<=\$node2->getRightValue()));
	}
";
	}

	protected function addIsEqualTo(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if \$node1 is equal to \$node2
	 *
	 * @param      $objectClassname \$node1		Propel object for node
	 * @param      $objectClassname \$node2		Propel object for node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function isEqualTo(BaseNodeObject \$node1 = null, BaseNodeObject \$node2 = null, PDO \$con = null)
	{
		return ((\$node1->getLeftValue() == \$node2->getLeftValue()) and (\$node1->getRightValue() == \$node2->getRightValue()));
	}
";
	}

	protected function addHasParent(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if \$node has an ancestor
	 *
	 * @param      $objectClassname \$node		Propel object for node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function hasParent(BaseNodeObject \$node = null, PDO \$con = null)
	{
		return $peerClassname::isValid($peerClassname::retrieveParent(\$node, \$con), \$con);
	}
";
	}

	protected function addHasPrevSibling(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if \$node has prev sibling
	 *
	 * @param      $objectClassname \$node		Propel object for node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function hasPrevSibling(BaseNodeObject \$node = null, PDO \$con = null)
	{
		return $peerClassname::isValid($peerClassname::retrievePrevSibling(\$node, \$con), \$con);
	}
";
	}

	protected function addHasNextSibling(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if \$node has next sibling
	 *
	 * @param      $objectClassname \$node		Propel object for node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function hasNextSibling(BaseNodeObject \$node = null, PDO \$con = null)
	{
		return $peerClassname::isValid($peerClassname::retrieveNextSibling(\$node, \$con), \$con);
	}
";
	}

	protected function addHasChildren(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Tests if \$node has children
	 *
	 * @param      $objectClassname \$node		Propel object for node
	 * @param      PDO \$con		Connection to use.
	 * @return     bool
	 */
	static function hasChildren(BaseNodeObject \$node = null, PDO \$con = null)
	{
		return ((\$node->getRightValue()-\$node->getLeftValue())>1);
	}
";
	}

	protected function addDeleteDescendants(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Deletes \$node and all of its descendants
	 *
	 * @param      $objectClassname \$node		Propel object for source node
	 * @param      PDO \$con		Connection to use.
	 */
	static function deleteDescendants(BaseNodeObject \$node = null, PDO \$con = null)
	{
		\$left = \$node->getLeftValue();
		\$right = \$node->getRightValue();

		\$c = new Criteria();
		\$c1 = \$c->getNewCriterion(self::LEFT_COL, \$left, Criteria::GREATER_THAN);
		\$c2 = \$c->getNewCriterion(self::RIGHT_COL, \$right, Criteria::LESS_THAN);

		\$c1->addAnd(\$c2);

		\$c->add(\$c1);
		\$c->addAscendingOrderByColumn(self::RIGHT_COL);

		\$result = $peerClassname::doDelete(\$c, \$con);

		self::shiftRLValues(\$right + 1, \$left - \$right -1, \$con);

		return \$result;
	}
";
	}

	protected function addGetNode(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Returns a node given its primary key or the node itself
	 *
	 * @param      int/$objectClassname \$node	Primary key/instance of required node
	 * @param      PDO \$con		Connection to use.
	 * @return     object		Propel object for model
	 */
	static function getNode(\$node, PDO \$con = null)
	{
		if (is_object(\$node)) {
			return \$node;
		} else {
			\$object = $peerClassname::retrieveByPK(\$node, \$con);
			\$rtn = is_object(\$object) ? \$object : false;
			return \$rtn;
		}
	}
";
	}

	protected function addHydrateDescendants(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Hydrate recursively the descendants of the given node
	 * @param      $objectClassname \$node	Propel object for src node
	 * @param      PDOStatement \$stmt	Executed PDOStatement
	 */
	protected static function hydrateDescendants(BaseNodeObject \$node = null, PDOStatement \$stmt)
	{
		\$descendants = array();
		\$children = array();
		\$prevSibling = null;
		while (\$row = \$stmt->fetch()) {
			\$omClass = $peerClassname::getOMClass(\$row, 0);
			\$cls = substr('.'.\$omClass, strrpos('.'.\$omClass, '.') + 1);

			" . $this->buildObjectInstanceCreationCode('$child', '$cls') . "
			\$child->hydrate(\$row);
			\$child->setLevel(\$node->getLevel() + 1);
			\$child->setParentNode(\$node);
			if (!empty(\$prevSibling)) {
				\$child->setPrevSibling(\$prevSibling);
				\$prevSibling->setNextSibling(\$child);
			}

			if (\$child->hasChildren()) {
				\$descendants = array_merge(\$descendants, $peerClassname::hydrateDescendants(\$child, \$stmt));
			}

			\$children[] = \$child;
			\$descendants[] = \$child;
			\$prevSibling = \$child;

			$peerClassname::addInstanceToPool(\$child);
			if (\$child->getRightValue() + 1 == \$node->getRightValue()) {
				\$child->setNextSibling(null);
				break;
			}
		}
		\$node->setChildren(\$children);
		return \$descendants;
	}
";
	}

	protected function addHydrateChildren(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Hydrate the children of the given node
	 * @param      $objectClassname \$node Propel object for src node
	 * @param      PDOStatement \$stmt Executed PDOStatement
	 */
	protected static function hydrateChildren(BaseNodeObject \$node = null, PDOStatement \$stmt)
	{
		\$children = array();
		while (\$row = \$stmt->fetch()) {
			\$omClass = $peerClassname::getOMClass(\$row, 0);
			\$cls = substr('.'.\$omClass, strrpos('.'.\$omClass, '.') + 1);

			" . $this->buildObjectInstanceCreationCode('$child', '$cls') . "
			\$child->hydrate(\$row);
			\$child->setLevel(\$node->getLevel() + 1);

			\$children[] = \$child;

			if (\$child->getRightValue() + 1 == \$node->getRightValue()) {
				break;
			}
		}
		\$node->setChildren(\$children);
		return \$children;
	}
";
	}


	protected function addShiftRParent(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Adds '\$delta' to all parent R values.
	 * '\$delta' can also be negative.
	 *
	 * @param      $objectClassname \$node	Propel object for parent node
	 * @param      int \$delta	Value to be shifted by, can be negative
	 * @param      PDO \$con		Connection to use.
	 */
	protected static function shiftRParent(BaseNodeObject \$node = null, \$delta, PDO \$con = null)
	{
		if (\$node->hasParent()) {
			\$parent = \$node->retrieveParent();
			self::shiftRParent(\$parent, \$delta, \$con);
		}
		\$node->setRightValue(\$node->getRightValue() + \$delta);
	}
";
	}

	protected function addInsertNode(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$script .= "
	/**
	 * Inserts a node with given Left and Right values and to the appropriate root
	 *
	 * @param      $objectClassname \$node		Propel object for model
	 * @param      int \$left		Left Value
	 * @param      int \$right		Right Value
	 * @param      PDO \$con			Connection to use.
	 * @return     object			Inserted propel object for model
	 */
	protected static function insertNode(BaseNodeObject \$node = null, \$left, \$right, PDO \$con = null)
	{
		\$node->setLeftValue(\$left);
		\$node->setRightValue(\$right);
		\$node->save(\$con);
		return \$node;
	}
";
	}

	protected function addUpdateNode(&$script)
	{
		$objectClassname = $this->getStubObjectBuilder()->getClassname();
		$script .= "
	/**
	 * Move \$node and its children to location \$dest and updates rest of tree
	 *
	 * @param      $objectClassname \$node Propel object for node to update
	 * @param      PDO \$con		Connection to use.
	 * @param      int	 Destination left value
	 */
	protected static function updateNode(BaseNodeObject \$node = null, \$destLeft, PDO \$con = null)
	{
		\$left = \$node->getLeftValue();
		\$right = \$node->getRightValue();

		\$treeSize = \$right - \$left +1;

		self::shiftRLValues(\$destLeft, \$treeSize, \$con);

		if (\$left >= \$destLeft) { // src was shifted too?
			\$left += \$treeSize;
			\$right += \$treeSize;
		}

		// now there's enough room next to target to move the subtree
		\$newPos = self::shiftRLRange(\$left, \$right, \$destLeft - \$left, \$con);
		// correct values after source

		self::shiftRLValues(\$right + 1, -\$treeSize, \$con);

		// don't get what this if for?
		if (\$left <= \$destLeft) { // dst was shifted too?
			\$newPos['left'] -= \$treeSize;
			\$newPos['right'] -= \$treeSize;
		}
	}
";
	}

	protected function addShiftRLValues(&$script)
	{
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Adds '\$delta' to all L and R values that are >= '\$first'. '\$delta' can also be negative.
	 *
	 * @param      int \$first		First node to be shifted
	 * @param      int \$delta		Value to be shifted by, can be negative
	 * @param      PDO \$con		Connection to use.
	 */
	protected static function shiftRLValues(\$first, \$delta, PDO \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection($peerClassname::DATABASE_NAME);
		}

		// do that prepared thing so they must both execute to work
		// Shift left column values
		\$sql =	\"UPDATE \" . self::TABLE_NAME . \" SET \" . self::LEFT_COL . \"=\" . self::LEFT_COL . \" + ? WHERE \" . self::LEFT_COL . \" >= ?\";
		\$stmt = \$con->prepare(\$sql);
		\$stmt->bindParam(1, \$delta, PDO::PARAM_INT);
		\$stmt->bindParam(2, \$first, PDO::PARAM_INT);
		\$result = \$stmt->execute();

		// Shift right column values
		\$sql =	\"UPDATE \" . self::TABLE_NAME . \" SET \" . self::RIGHT_COL . \"=\" . self::RIGHT_COL . \" + ? WHERE \" . self::RIGHT_COL . \" >= ?\";
		\$stmt = \$con->prepare(\$sql);
		\$stmt->bindParam(1, \$delta, PDO::PARAM_INT);
		\$stmt->bindParam(2, \$first, PDO::PARAM_INT);
		\$result = \$stmt->execute();

	}
";
	}

	protected function addShiftRLRange(&$script)
	{
		$peerClassname = $this->getStubPeerBuilder()->getClassname();
		$script .= "
	/**
	 * Adds '\$delta' to all L and R values that are >= '\$first' and <= '\$last'.
	 * '\$delta' can also be negative.
	 *
	 * @param      int \$first	First node to be shifted (L value)
	 * @param      int \$last	Last node to be shifted (L value)
	 * @param      int \$delta	Value to be shifted by, can be negative
	 * @param      PDO \$con		Connection to use.
	 * @return     array 		Shifted L and R values
	 */
	protected static function shiftRLRange(\$first, \$last, \$delta, PDO \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection($peerClassname::DATABASE_NAME);
		}

		// do that prepared thing so they must both execute to work
		// Shift left column values
		\$sql =	\"UPDATE \" . self::TABLE_NAME . \" SET \" . self::LEFT_COL . \"=\" . self::LEFT_COL . \" + ? WHERE \" . self::LEFT_COL . \" >= ? AND \" . self::LEFT_COL . \" <= ?\";
		\$stmt = \$con->prepare(\$sql);
		\$stmt->bindParam(1, \$delta, PDO::PARAM_INT);
		\$stmt->bindParam(2, \$first, PDO::PARAM_INT);
		\$stmt->bindParam(3, \$last, PDO::PARAM_INT);
		\$stmt->setFetchMode(PDO::FETCH_ASSOC);
		\$result = \$stmt->execute();

		// Shift right column values
		\$sql =	\"UPDATE \" . self::TABLE_NAME . \" SET \" . self::RIGHT_COL . \"=\" . self::RIGHT_COL . \" + ? WHERE \" . self::RIGHT_COL . \" >= ? AND \" . self::RIGHT_COL . \" <= ?\";
		\$stmt = \$con->prepare(\$sql);
		\$stmt->bindParam(1, \$delta, PDO::PARAM_INT);
		\$stmt->bindParam(2, \$first, PDO::PARAM_INT);
		\$stmt->bindParam(3, \$last, PDO::PARAM_INT);
		\$stmt->setFetchMode(PDO::FETCH_ASSOC);
		\$result = \$stmt->execute();

		return array('left' => \$first + \$delta, 'right' => \$last + \$delta);
	}
";
	}

} // PHP5NestedSetPeerBuilder
