<?xml version="1.0"?>
<!--
    $Id: manage_target.xsl,v 1.10 2009-10-09 09:26:48 jakub Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  <xsl:variable name="targetid" select="string($input/data/@targetid)"/>
  <xsl:variable name="target_form" select="$input/subtree[@name = 'target']"/>
  <xsl:variable name="holding_types" select="/*/holdingTypes"/>

  <xsl:template name="insert-body">
    <h3>Resource management.</h3>

    <form name="targetForm" method="post">
      <input type="hidden" name="page" value="{$page}"/>
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="targetid" value="0"/>

      <xsl:choose>
        <xsl:when test="$action = 'edittarget'">
          <b>Edit resource:</b>
          <br/>
          <br/> 
          <xsl:choose>

            <xsl:when test="$target_form">
              <xsl:call-template name="insert-target-form">
                <xsl:with-param name="t" select="$target_form/*"/>
              </xsl:call-template>
            </xsl:when>

            <xsl:otherwise>
              <xsl:call-template name="insert-target-form">
                <xsl:with-param name="t"
                    select="php:function('get_target_data', $targetid)/*"/>
              </xsl:call-template>
            </xsl:otherwise>

          </xsl:choose>

        </xsl:when>

        <xsl:when test="$action = 'addtarget'">
          <b>Add new resource:</b>
          <br/>
          <br/>
          <xsl:call-template name="insert-target-form">
            <xsl:with-param name="t" select="/*/defaultTarget"/>
          </xsl:call-template>
        </xsl:when>

      </xsl:choose>

    </form>
  </xsl:template>


  <xsl:template name="insert-target-form">
    <xsl:param name="t"/>

    <table>
      <tr>
        <td><b>Resource name:</b></td>
        <td><input type="text" name="target[name]" value="{$t/@name}" /></td>
      </tr>
      <tr>
        <td><b>Translated resource name:</b></td>
        <td>
          <input type="text" name="target[name_alt]" value="{$t/@name_alt}" />
        </td>
      </tr>
      <tr>
        <td><b>Resource description:</b></td>
        <td>
          <textarea name="target[desc]" rows="3" cols="50">
             <xsl:value-of select="$t/@desc"/>
          </textarea>
        </td>
      </tr>
      <tr>
        <td><b>Translated resource description:</b></td>
        <td>
          <textarea name="target[desc_alt]" rows="3" cols="50">
             <xsl:value-of select="$t/@desc_alt"/>
          </textarea>
        </td>
      </tr>
     <tr>
        <td><b>Connection string:</b></td>
        <td>
          <input type="text" name="target[connstring]"
                                        value="{$t/@connstring}"/>
        </td>
      </tr>
      <tr>
        <td><b>Element set name:</b></td>
        <td>
          <input type="text" name="target[element_set]"
                                        value="{$t/@element_set}"/>
        </td>
      </tr>
      <tr>
        <td><b>Record Syntax:</b></td>
        <td>
          <input type="text" name="target[req_syn]" value="{$t/@req_syn}" />
        </td>
      </tr>
      
      <tr>
        <td><b>Non-auto normalization stylesheet:</b></td>
        <td>
          <input type="text" name="target[xslt]" value="{$t/@xslt}" />
        </td>
      </tr>

      <tr>
        <td><b>Record Encoding Character Set:</b></td>
        <td>
          <input type="text" name="target[rec_enc]" value="{$t/@rec_enc}" />
        </td>
      </tr>
      <tr>
        <td><b>Query Encoding Character Set:</b></td>
        <td>
          <input type="text" name="target[query_enc]" value="{$t/@query_enc}" />
        </td>
      </tr>
      <tr>
        <td><b>SRU method (for SRU targets only)</b></td>
        <td>
          <select name="target[sru_method]">
            <xsl:for-each select="php:function('get_sru_methods')/*/*">
              <option value="{@value}">
                <xsl:if test="$t/@sru_method = @value">
                  <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
                <xsl:value-of select="@name"/>
              </option>
            </xsl:for-each>
          </select>
        </td>
      </tr>
     <tr>
        <td><b>SRU version (for SRU targets only)</b></td>
        <td>
          <select name="target[sru_version]">
            <xsl:for-each select="php:function('get_sru_versions')/*/*">
              <option value="{@value}">
                <xsl:if test="$t/@sru_version = @value">
                  <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
                <xsl:value-of select="@name"/>
              </option>
            </xsl:for-each>
          </select>
        </td>
      </tr>
      <tr>
        <td><b>CCL-map:</b></td>
        <td>
          <select name="target[cclmap_id]">
            <option value="">- Select CCL-map</option>
            <xsl:for-each select="php:function('get_ccl_maps')/*/*">
              <option value="{@id}">
                <xsl:if test="$t/@cclmap_id = @id">
                  <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
                <xsl:value-of select="@name"/>
              </option>
            </xsl:for-each>
          </select>
        </td>
      </tr>
      <tr>
        <td><b>Holdings type:</b></td>
        <td>
          <select name="target[holding_type]">
            <xsl:for-each select="$holding_types/type">
              <option value="{@id}">
                <xsl:if test="$t/@holding_type = @id">
                  <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
                <xsl:value-of select="."/>
              </option>
            </xsl:for-each>
          </select>
        </td>
      </tr>
     
      <tr>
        <td><b>Holdings normalization:</b></td>
        <td>
          <input type="text" name="target[holding_xsl]"
                                        value="{$t/@holding_xsl}"/>
        </td>
      </tr>
      
      <tr>
        <td><b>Local system URL recipe:</b></td>
        <td>
          <input type="text" name="target[url_recipe]"
                                        value="{$t/@url_recipe}"/>
        </td>
      </tr>

      <tr>
        <td><b>Z39.50 Proxy Connecting String:</b></td>
        <td>
          <input type="text" name="target[proxy_conn_string]"
                                        value="{$t/@proxy_conn_string}"/>
        </td>
      </tr>

      <tr>
        <td><b>ILL/Email:</b></td>
        <td>
          <input type="text" name="target[ill_email]" value="{$t/@ill_email}"/>
        </td>
      </tr>

      <tr>
        <td colspan="3">&#xa0;</td>
      </tr>
      
      <tr>
        <td colspan="3">
          <b>Target will appear in the following categories:</b>
          <xsl:call-template name="insert-cat-tree">
            <xsl:with-param name="cats"
              select="php:function('get_cat_tree_sel_target', $targetid)/*"/>
          </xsl:call-template>
        </td>
      </tr>

      <tr>
        <td colspan="3">
          <input type="button" value="Save"
                   onclick="set_action(document.targetForm, 'savetarget',
                                       '{$targetid}')" />

          <xsl:if test="$action = 'edittarget'">
            <input type="button" value="Delete"
                   onclick="set_action(document.targetForm, 'deletetarget',
                                       '{$targetid}')" />
          </xsl:if>

          <input type="button" value="Cancel"
                 onclick="set_action(document.targetForm, 'switchpage')" />
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="insert-cat-tree">    
    <xsl:param name="cats"/>
    <ul>
      <xsl:for-each select="$cats/*">
        <li>
          <input type="checkbox" name="category[catid][]" value="{@id}">
            <xsl:if test="@selected">
              <xsl:attribute name="checked">checked</xsl:attribute>
            </xsl:if>
          </input>

          <xsl:value-of select="@name"/>
        </li>
        
        <xsl:if test="category">
            <xsl:call-template name="insert-cat-tree">
              <xsl:with-param name="cats"
                select="."/>
            </xsl:call-template>
        </xsl:if>
      
      </xsl:for-each>
    </ul>
  </xsl:template>

</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
