<?php

class Pz2Proxy
{
    private $response;
    private $request;
    private $server;
    private $pz2;

    public function __construct (&$r, &$srv , $pz2)
    {
        $this->request = &$r;
        $this->server = &$srv; 
        $this->pz2 = $pz2;
    }

    public function getResponse()
    {
        return $this->response;
    }

    /**
     * Returns 'true' on succcess and 'false' on error
     */
    public function execute()
    {
      if (isset ($this->request['command'])) {
        if ($this->request['command'] == 'init' ) {
          $this->response = '<error code="0">Init not allowed</error>';
          return false;
        } else {
          $postParams = file_get_contents('php://input');
          $this->response = $this->proxyPz2Command($this->request['command'],
            $this->server['QUERY_STRING'], $postParams);
          return true;
        }
      } else {
        $this->response = '<error code="0">Missing parameter command</error>';
        return false;
      }
    }

    private function proxyPz2Command ( $command, $queryString, $postParams)
    {
        //save query for a new search
        if ( $command == 'search' ) {
            mk_session_write('last_query_string', $queryString);
            mk_session_write('last_post_params', $postParams);
        }
        
        // is pz2session in phpsesion?
        if ( $pz2sessid = mk_session_read('pz2sessionid') ) {
             // reuse the pz2session
             $this->pz2->setSessId( $pz2sessid );
        } else {
            // no pz2session stored in phpsession
            // apply for new one
            try {
                mk_session_write('pz2sessionid', 
                    $this->pz2->restart());
            } catch (Exception $e) {
                $response = '<error code="'.$e->getCode()
                    .'" msg="'.$e->getMessage().'" >'
                    .'When trying to init pz2'.'</error>';
                return $response;          
            }
        }
        
        // send a command and check if successful
        try {
            $response = $this->pz2->relay( $queryString, $postParams );
            $error = $this->pz2->getError();

            if ($error) {
                if ( $error->code == 1 ) {
                    // try to restart one more
                    try {
                        mk_session_write('pz2sessionid',
                            $this->pz2->restart() );
                    } catch (Exception $e) {
                        $response = '<error code="'.$e->getCode()
                            .'" msg="'.$e->getMessage().'" >'
                        .'When trying to init pz2'.'</error>';
                        return $response;
                    }
                    
                    // when not searching and there was an error
                    // try to init and reuse old query
                    if ( $command != 'search') { 
                        $last_qstring = mk_session_read('last_query_string');
                        $lastPostParams = mk_session_read('last_post_params');
                        if ($last_qstring!==false && $lastPostParams!==false)
                            $response = 
                              $this->pz2->relay($last_qstring, $lastPostParams);
                    }
                    $response = $this->pz2->relay($queryString, $postParams);
                }
            }
        //http errors between proxy and pz2
        } catch (Exception $e) {
            $response = '<error code="'.$e->getCode()
                .'" msg="'.$e->getMessage().'" >'
            .'When trying to call pz2'.'</error>';
        }        
        return $response;        
    }
}
