<?php
/* $Id: WsResponseXML.class.php,v 1.2 2007-09-17 07:37:23 jakub Exp $ */
require_once 'IWsResponse.class.php';
/*
** Web Service response in a form of hash table
**/
class WsResponseXML implements IWsResponse
{
    private $response;

    public function __construct ($doc = null)
    {
        $this->response = new DOMDocument();
    }

    public function setRoot ( $root )
    {
        $this->response->appendChild( new DOMElement($root) ); 
    }

    public function header ()
    {
        header("Content-Type: application/xml");        
    }

    public function printResponse ()
    {
        echo $this->response->saveXML();
    }

    // TODO copy or reference?
    public function appendEntry ($entry, $name = null)
    {
        $this->response->documentElement->appendChild(
            new DOMElement($entry, $name));
    }

    public function addEntry ($name, $value = null, $attr = null)
    {
        $element = new DOMElement($name);

         $this->response->documentElement
                        ->appendChild($element);

        if ($value !== null) {
            $eleText = new DOMText($value);
            $element->appendChild( $eleText );
        }
            
        if ($attr !== null)
            $element->setAttribute( $attr['name'], $attr['value'] ); 
       
    }

    public function addError ($error)
    {
        $this->addEntry('error', $error);
    }
}
