<?php
function mk_run ($conf, &$req, &$serv)
{
  if (isset($req['command'])) {
    switch($req['command']) {
  case 'register':
    require_once 'php/includes/propel_init.php';
    require_once 'php/classes/auth/RegisterWS.class.php';
    $lang_code = resolve_locale($conf, $req);   
    $locale_path = check_locale_path($conf);
    $xml_lang = load_lang_file($lang_code, $locale_path, 'register');
    session_start();
    $ws = new RegisterWS($req, $_SESSION, $conf, $xml_lang);
    $ws->sendResponse();
    break;
	case 'login':
	case 'check':
	case 'tree':
	case 'handshake':
	    require_once 'php/includes/propel_init.php';
	    require_once 'php/classes/auth/AuthWS.class.php';
	    session_start();
	    
	    if ( isset($serv['HTTP_X_FORWARDED_FOR']) ) {
		$req['ipaddr'] = $serv['HTTP_X_FORWARDED_FOR'];
	    } else if ( isset($serv['REMOTE_ADDR']) ) {
		$req['ipaddr'] = $serv['REMOTE_ADDR'];
	    }
	    
	    $ws = new AuthWS($req, $_SESSION);
	    $ws->start();
	    $ws->sendResponse();	
	    break;
	case 'save':
	    require_once 'php/includes/propel_init.php';
	    require_once 'php/classes/auth/UserDataWS.class.php';
	    $ud = new UserDataWS($req);
	    $ud->save();
	    $ud->send_response();
	    break;
	case 'fetch':
	    require_once 'php/includes/propel_init.php';
	    require_once 'php/classes/auth/UserDataWS.class.php';
	    $ud = new UserDataWS($req);
	    $ud->fetch();
	    $ud->send_response();
	    break;
	default: // proxy stuff
	    require_once 'php/classes/Pz2Proxy.class.php';
	    require_once 'php/classes/Pz2WrapperFactory.class.php';
      $pz2 = Pz2WrapperFactory::makeWrapper($conf);
	    $proxy = new Pz2Proxy($req, $serv, $pz2);
      $ret = $proxy->execute();
      $resp = $proxy->getResponse();
      $header = 'Content-Type: application/xml';
      if ($ret && isset($req['transformto']) && !empty($req['transformto'])) {
        $xslpath = $conf->read('gui_path').'/xsl/'.$req['transformto'].'.xsl';
        $xsl = new DOMDocument;
        $xsl->load($xslpath);
        $header = get_out_content_type($xsl);
        $proc = new XSLTProcessor;
        $proc->importStyleSheet($xsl);
        $doc = new DOMDocument();
        $doc->loadXML($resp);
        $resp = $proc->transformToXML($doc);
      }
      header($header);
      echo $resp;
	}
	exit;
    }
    mk_set_default_paths($conf);

    $lang = mk_prepare_lang_doc($conf, $req);
    $proc = mk_prepare_proc($conf, $req);

    echo $proc->transformToXML($lang);
}

//tries to guess content tyep of an xsl stylehseet
function get_out_content_type ($xsl) {
  $outNodes = $xsl->getElementsByTagName('output');
  $method = $outNodes->length ? $outNodes->item(0)->getAttribute('method') 
    : 'xml';
  switch ($method) {
    case 'xml' : return 'Content-Type: application/xml; charset=utf-8';
    case 'html' : return 'Content-Type: application/xhtml+xml; charset=utf-8';
    case 'text' : return 'Content-Type: text/plain; charset=utf-8';
  }
}

function resolve_include_path ($filename)
{
    $paths = explode( PATH_SEPARATOR, get_include_path() );
    foreach( $paths as $path ) {
        if ( file_exists( $path.'/'.$filename) )
            return $path;
    }
}

function mk_prepare_proc ($conf, $r) 
{
    $core_path = resolve_include_path('xsl/mk_front.xsl');
    $conf->write('core_path', $core_path);
    
    if ( $conf->read('gui_front_xsl') )
        $front_xsl_path = $conf->read('gui_path').'/'.$conf->read('gui_front_xsl');
    else
	$front_xsl_path = $core_path.'/xsl/mk_front.xsl';
    
    $xsl = new DOMDocument;
    $xsl->load($front_xsl_path);

    $xsl->saveXML();

    //since there is no way to setup default xsl include paths from PHP, 
    //we do it by hand
    foreach ($xsl->getElementsByTagName("import") as $import) {
      $href = $import->getAttribute('href');
      if (strpos($href, '$MASTERKEY_PATH') === 0) {
        $href = str_replace('$MASTERKEY_PATH', $core_path, $href);
        $import->setAttribute('href', $href);
      }
    }

    $proc = new XSLTProcessor;
    $proc->importStyleSheet($xsl);
    
    return $proc;
}

function mk_prepare_lang_doc ($conf, $r)
{
    $lang_code = resolve_locale($conf, $r);   
    $locale_path = check_locale_path($conf);
    $xml_lang = load_lang_file($lang_code, $locale_path, 'front');
    append_content_from_file($xml_lang, 'about', $lang_code, $locale_path);
    append_content_from_file($xml_lang, 'help', $lang_code, $locale_path);   
    $avail_lang = 
      get_languages($lang_code, $conf->read('default_lang'), $locale_path);
    append_content_from_doc($xml_lang, $avail_lang);
    append_content_from_doc($xml_lang, $conf);
    return $xml_lang;
}

function mk_set_default_paths ($conf)
{
    
    if( ! $conf->read('jquery_uri') )
        $conf->write('jquery_uri', '/jquery');

    if( ! $conf->read('pz2js_uri') )
        $conf->write('pz2js_uri', '/pazpar2/js/pz2.js');

    if( ! $conf->read('masterkey_core_uri') )
        $conf->write('masterkey_core_uri', '/masterkey-core');

    if( ! $conf->read('masterkey_auth_uri') )
        $conf->write('masterkey_auth_uri', '/masterkey-auth');

}


function get_languages ($current_lang, $def_lang, $dir) {
    $xml = '';

    if ( $dh = opendir($dir)) {
        while (($entry = readdir($dh)) !== false) {
          if ( preg_match('/front-(..)\.xml/', $entry, $match) ) {
                $selected = '';
                $default = '';
                if ($match[1] == $current_lang) {
                    $selected = ' selected="true"';
                }
                if ($match[1] == $def_lang) {
                    $default = ' default="true"';
                }              
                $langfile = ' file="'.$entry.'"';
                $xml .= "<lang$default$selected$langfile>".$match[1]."</lang>";
            }
        }
        
        closedir($dh);
    }
    
    $xml = "<languages>" . $xml . "</languages>";
    $doc = new DOMDocument;
    $doc->loadXml($xml);
    return $doc;
}

function resolve_locale($conf, $r) {
  return isset($r['lang']) ? $r['lang'] : $conf->read('default_lang');
}

function check_locale_path ($conf) {
    $locale_path = $conf->read('gui_path') . '/locale';
    if (!is_dir($locale_path))
      die("Locale path '" . $locale_path . "' does not exists");
    return $locale_path;
}

function load_lang_file ($langcode, $path, $basename) 
{
    if (preg_match('/^[a-z]{2}$/', $langcode)) {
        $full_path = $path.'/'.$basename.'-'.$langcode.'.xml';
        if (file_exists($full_path)) {
            $xml = new DOMDocument();
            $xml->load($full_path);
            return $xml;
        } else {
            die("Language: '" . $langcode . "' currently not enabled"
                . " because file '" . $full_path . "' could not be loaded");
        }
    } else {
        die('Only 2 letter language codes');
    }
}

function append_content_from_file ( &$xml, $file, $lang, $path) 
{
    $filepath = $path.'/'.$file.'-'.$lang.'.xml';
    
    if ( !file_exists($filepath) )
        die($filepath. ' is missing.');
    
    $content_doc = new DOMDocument();
    $content_doc->load($filepath);
    
    append_content_from_doc ($xml, $content_doc);
}

function append_content_from_doc (&$toXML, &$fromXML)
{
    $nodeCopy = $toXML->importNode(
                $fromXML->documentElement,
                true);

    $toXML->documentElement->appendChild($nodeCopy);
}

function mk_session_read ( $key )
{
    @session_start();
    if ( !isset( $_SESSION['auth'][$key]) )
        return false;
    $value = $_SESSION['auth'][$key];
    session_write_close();
    return $value;
}

function mk_session_write ( $key, $value )
{
    @session_start();
    $_SESSION['auth'][$key] = $value;
    session_write_close();
}
