<?xml version="1.0"?>
<!--
    $Id: mk_render_bcm.xsl,v 1.6 2007-08-28 08:02:10 sondberg Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/*">
    <xsl:variable name="title"
            select="'MasterKey - Browser Compatibility Matrix'"/>
    <xsl:variable name="url" select="'http://masterkey-test.indexdata.com'"/>

    <html>
      <head>
        <title><xsl:value-of select="$title"/></title>
        <style type="text/css">
          td {
            text-align: center;
            background: lightgrey;
          }
        </style>
      </head>
      <body>
        <h2><xsl:value-of select="$title"/></h2>
        <p>URL: <a href="{$url}"><xsl:value-of select="$url"/></a></p>

        <table width="100%">
          <xsl:call-template name="insert-labels"/>
          <xsl:apply-templates/>
        </table>

        <p style="font-style: italic;">Last updated: <xsl:value-of
                                                       select="updated"/></p>
      </body>
    </html>
  </xsl:template>


  <xsl:template name="insert-labels">
    <tr>
      <td style="background: white;">&#xa0;</td>

      <xsl:for-each select="browser">
        <td style="font-weight: bold; background: white;">
          <xsl:value-of select="."/>
        </td>
      </xsl:for-each>
    </tr>
  </xsl:template>


  <xsl:template match="feature">
    <xsl:variable name="f" select="."/>

    <tr>
      <td style="text-align: left;"><xsl:value-of select="description"/></td>

      <xsl:for-each select="/*/browser">
        <xsl:variable name="id" select="@id"/>
        <td>
          <xsl:choose>
            <xsl:when test="$f/status[@id=$id and @type = 'ok']">OK</xsl:when>
            <xsl:when test="$f/status[@id=$id]">
              <xsl:attribute name="style">color: red;</xsl:attribute>
              <xsl:value-of select="$f/status[@id=$id]"/>
            </xsl:when>
            <xsl:otherwise>n/a</xsl:otherwise>
          </xsl:choose>
        </td>
      </xsl:for-each>
    </tr>
  </xsl:template>


  <xsl:template match="*"/>

</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
