<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:output method="xml" indent="yes" />

    <xsl:template match="masterkey">
      <database name="{dbname}" defaultIdMethod="native">

       <table name="access_group" description="Group of users" >
        <column name="group_id" type="integer" primaryKey="true" autoIncrement="true" required="true" description="Group Id"/>
        <column name="group_name" type="varchar" size="255" required="true" description="Group name"/>
        <column name="logo" type="varchar" size="4096" description="group logo"/>
       </table>

       <table name="user" description="Users" >
        <column name="user_id" type="integer" primaryKey="true" autoIncrement="true" required="true" description="User Id"/>
        <column name="user_name" type="varchar" size="255" description="User full name"/>
        <column name="institution" type="varchar" size="255" description="Encrypted user password"/>
        <column name="email" type="varchar" size="255" description="Encrypted user password"/>
        <column name="login" type="varchar" size="255" required="true" description="Login name"/>
        <column name="enc_pass" type="varchar" size="255" required="true" description="Encrypted user password"/>
        <column name="sel_enabled" type="boolean" defaultValue="false" description="Remember last selection"/>
        <column name="records_page" type="integer" defaultValue="0" description=""/>
        <column name="thumbs" type="integer" defaultValue="0" description=""/>
        <column name="type" type="integer" defaultValue="0" description=""/>
        <column name="state" type="integer" defaultValue="0" description=""/>
        <column name="selection" type="varchar" size="4096" description=""/>
        <column name="ourl_resolver" type="varchar" size="4096" description="OpenURL resolver address"/>
        <column name="group_id" type="integer" required="true"/>
        <foreign-key foreignTable="access_group">
          <reference
            local="group_id"
            foreign="group_id"/>
        </foreign-key>
       </table>

       <table name="ip_mask" description="Ip masks" >
        <column name="mask_id" type="integer" primaryKey="true" autoIncrement="true" required="true" description="Group Id"/>
        <column name="mask_name" type="varchar" size="255" required="true" description="IP range name"/>
        <column name="mask_lower" type="bigint" required="true" description="Lower range value"/>
        <column name="mask_upper" type="bigint" required="true" description="Upper value"/>
        <column name="group_id" type="integer" required="true"/>
        <foreign-key foreignTable="access_group">
          <reference
            local="group_id"
            foreign="group_id"/>
        </foreign-key>
       </table>
       
       <table name="target" description="Target table" >
         <column name="target_id" type="integer" primaryKey="true" autoIncrement="true" required="true" description="Z39.50 target Id"/>
        <column name="target_name" type="varchar" size="255" required="true" description="Target name"/>
        <column name="target_name_alt" type="varchar" size="255" required="false" description="Alternative target name"/>
        <column name="target_desc" type="varchar" size="4096" required="false" description="Target description"/>
        <column name="target_desc_alt" type="varchar" size="4096" required="false" description="Alternative target description"/>
        <column name="conn_string" type="varchar" size="255" required="true" description="Z39.50 connection string"/>
        <column name="rec_enc" type="varchar" size="4096" required="true" description="Record encoding"/>
        <column name="query_enc" type="varchar" size="255" required="true" description="Query encoding"/>
        <column name="req_syn" type="varchar" size="255" required="true" description="Request syntax"/>  
        <column name="element_set" type="varchar" size="255" required="false" description="Element set name"/>  
        <column name="sru_method" type="varchar" size="255" required="false" description="SRU method name"/>  
        <column name="sru_version" type="varchar" size="255" required="false" description="SRU protocol version"/>  
        <column name="xslt" type="varchar" size="255" description="XSL Transform for record normalization"/>
        <column name="ccl_map_id" type="integer" required="true" description="CCL map id"/>
        <column name="holding_type" type="integer" description="Holding type"/>
        <column name="holding_xsl" type="varchar" size="255" description="Holding extraction stylesheet"/>
        <column name="url_recipe" type="varchar" size="4096" description="Local system URL recipe"/>
        <column name="proxy_conn_string" type="varchar" size="4096" description="Optional Z39.50 proxy"/>
        <column name="ill_email" type="varchar" size="4096" description="Optional email used for ILL"/>
        <foreign-key foreignTable="ccl_map">
          <reference
            local="ccl_map_id"
            foreign="ccl_map_id"/>
        </foreign-key>
       </table>

       <table name="z_auth" description="many 2 many rel. between targets and groups" >
        <column name="target_id" type="integer" required="true" primaryKey="true"/>
        <column name="group_id" type="integer" required="true" primaryKey="true"/>
        <column name="z_user" type="varchar" size="255" description="Auth login"/>
        <column name="z_pass" type="varchar" size="255" description="Auth password"/>
        <column name="z_group" type="varchar" size="255" description="Auth group"/>
        <foreign-key foreignTable="target">
          <reference
            local="target_id"
            foreign="target_id"/>
        </foreign-key>
        <foreign-key foreignTable="access_group">
          <reference
            local="group_id"
            foreign="group_id"/>
        </foreign-key>
       </table>

       <table name="ccl_map" description="CCL Mapping" >
         <column name="ccl_map_id" type="integer" primaryKey="true" autoIncrement="true" required="true" description="CCL map id"/>
         <column name="ccl_map_name" type="varchar" size="255" required="true" description="CCL profile name"/>
       </table>

       <table name="ccl_spec" description="CCL to PQF mapping specificiations" >
         <column name="ccl_spec_id" type="integer" primaryKey="true" autoIncrement="true" required="true" description="Specificiation ID"/>
         <column name="ccl_map_id" type="integer" required="true" description="Relation to cclmap table"/>
         <column name="ccl_qual" type="varchar" size="255" required="true" description="CCL qualifier"/>
         <column name="pqf" type="varchar" size="255" required="true" description="PQF string"/>
         <foreign-key foreignTable="ccl_map">
           <reference
             local="ccl_map_id"
             foreign="ccl_map_id"/>
         </foreign-key>
       </table>

       <table name="category" description="Category table" >
        <column name="cat_id" type="integer" required="true" primaryKey="true" autoIncrement="true" description="Category Id"/>
        <column name="cat_name" type="varchar" size="255" required="true" description="Category name"/>
        <column name="parent_id" type="integer" required="true" defaultValue="0" description="Parent category Id"/>
        <foreign-key foreignTable="category">
          <reference
            local="parent_id"
            foreign="cat_id"/>
        </foreign-key>
       </table>

       <table name="seed" description="Seed table" >
        <column name="seed_id" type="integer" primaryKey="true" autoIncrement="true" required="true"/>
        <column name="seed_value" type="varchar" size="255" required="true"/>
       </table>

       <table name="target_ref_cat" >
        <column name="target_id" type="integer" required="true" primaryKey="true"/>
        <column name="cat_id" type="integer" required="true" primaryKey="true"/>
        <foreign-key foreignTable="target">
          <reference
            local="target_id"
            foreign="target_id"/>
        </foreign-key>
        <foreign-key foreignTable="category">
          <reference
            local="cat_id"
            foreign="cat_id"/>
        </foreign-key>
       </table>

      </database>
    </xsl:template>

</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
