<?php
/* $Id: CategoryTreeHash.class.php,v 1.3 2009-09-30 13:56:04 jakub Exp $ */
//require_once 'ICategoryTree.if.php';
/*
** Category tree structure kept in hash table.
**/
class CategoryTreeHash
{
    // array of Category objects.
    private $categories; 
    // hash tree structure
    private $catTree;

    public function __construct()
    {
        // load all cats from db and build a tree
        $c = new Criteria();
        $this->categories = CategoryPeer::doSelect($c);
        $this->catTree = $this->findChildCats(0);
    }

    public function getTree()
    {
        // return the tree structure
        return $this->catTree;
    }

    public function insertTargets ( $zTargetCollection )
    {
        foreach ( $zTargetCollection as $entry )
        {
            $target = $entry->getTarget();

            foreach ($this->loadCatsFromDbByTarget ($target) as $category)
            {
                $this->putTargetIntoCatTree( $this->catTree, $category, $target );
            }
        }
    }
    
    private function findChildCats ($catId)
    {
        $cats = array();

        foreach ( $this->categories as $category )
        {
            if ( $category->getParentId() == $catId )
            {
                $cat = array();
                $cat["catid"] = $category->getCatId();
                $cat["catname"] = $category->getCatName();
                $cat["targets"] = array();
                $cat["subcats"] = $this->findChildCats($category->getCatId());
                $cats[] = $cat;
            }
        }
        
        if($cats)
            return $cats;
        else
            return null;
    }

    private function putTargetIntoCatTree(&$catTree, $catToFind, $targetToInsert )
    {
        foreach ( $catTree as &$catBranch )
        {
            if ( $catBranch["catid"] ==  $catToFind->getCatId() )
            {
                $target = array();
                $target["id"] = $targetToInsert->getConnString();
                $target["name"] = $targetToInsert->getTargetName();
                $target["name_alt"] = $targetToInsert->getTargetNameAlt();
                $target["desc"] = $targetToInsert->getTargetDesc();
                $target["desc_alt"] = $targetToInsert->getTargetDescAlt();
                $catBranch["targets"][] = $target;
                return;
            }
            else if( $catBranch["subcats"] != null )
            {
                $this->putTargetIntoCatTree($catBranch["subcats"], $catToFind, $targetToInsert);
            }
        }
    }

    private function loadCatsFromDbByTarget ( $target )
    {
        $cats = array();
        foreach ( $target->getTargetRefCatsJoinCategory(null) as $ref ) {
            $cats[] = $ref->getCategory();
        }
        return $cats;
    }
}

