<?php

//require_once 'captcha.php';

class RegisterWS
{
  private $r;
  private $s;
  private $response;
  private $POSTinput = 'php://input';
  private $useGETforData = false;
  private $defaultAccessGroup = "all";
  private $mailFrom = "masterkey@indexdata.com";
  private $adminEmail = "masterkey@indexdata.com";
  private $adminConsoleBase = "";
  private $msg = array();
    
  function __construct (&$req, &$sess, $conf, $lang) {	
	  if ($this->getLoggedInUserId())
      $this->err('Logged in users cannot register.');
    $this->r = &$req;
    $this->s = &$sess;
    $this->mailFrom = $conf->read("from_email");
    $this->adminEmail = $conf->read("admin_email");
    $this->defaultAccessGroup = $conf->read("default_access_group");
    $this->adminConsoleBase = $conf->read("admin_console_base");
    //parse i18 message
    try {
      $msgNodes = $lang->documentElement->childNodes;
      foreach ($msgNodes as $node) {
        if ($node->nodeType != XML_ELEMENT_NODE) continue;
        $this->msg[$node->nodeName] = $node->textContent;
      }
    } catch (Exception $e) { return $this->err($e->getMessage()); }
  }
    
  function getLoggedInUserId() {
	  $user_id =  isset($_SESSION['auth']['policy']['userid']['value'])
	    ? $_SESSION['auth']['policy']['userid']['value']
	    : false;
	  return $user_id;
  }

  function sendResponse() {
    if (!isset($this->r['action'])) { 
      $this->err("Missing parameter action");
      return;
    }
    switch ($this->r['action']) {
      case 'captcha': $this->doCaptcha(); break;
      case 'signup': $this->doSignUp(); break;
      case 'remind': $this->doRemind(); break;
      default: $this->err("Unknown value of the parameter action.");
    }
  }

  private function doCaptcha() {
    //random string using md5
    $md5_hash = md5(rand(0,999)); 
    //trim it down to 5 
    $code = substr($md5_hash, 15, 5);
    $this->s["captchacode"] = $code;
    session_write_close();
    $img = $this->generateCaptchaImage($code);
    //output in jpeg
    header("Content-Type: image/jpeg"); 
    ImageJpeg($img);
    ImageDestroy($img);
  }

  private function doSignup() {
    if (!isset($this->r['code'])) 
      return $this->err('Missing parameter :code:');
    if (!isset($this->s['captchacode']))
      return $this->err('Missing server-side security code, '.
        'have you called action :captcha: ?');
    $sentCode = $this->r['code'];
    $genCode = $this->s['captchacode'];
    if ($sentCode != $genCode) 
      return $this->err($this->msg['nomatch']);
    //read POSTed new user data
    $login = ""; $email = ""; $name = ""; $institution = "";
    if (!$this->useGETforData) {
      try {
        $doc = new DOMDocument();
        $doc->load($this->POSTinput);
        $reg = $doc->documentElement;
        $login = $reg->getAttribute('login');
        $email = $reg->getAttribute('email');
        $name = $reg->getAttribute('name');
        $institution = $reg->getAttribute('institution');
      } catch (Exception $e) { return $this->err($e->getMessage()); }
    } else {
      if (!(isset($this->r['login']) && isset($this->r['email']) 
        && isset($this->r['name']) && isset($this->r['institution']))) 
        return $this->err('Missing parameters (:login:|:email:|:name:)');
      $login = $this->r['login'];
      $email = $this->r['email'];
      $name = $this->r['name'];
      $institution = $this->r['institution'];
    }
    if (empty($login) || empty($email) || empty($name) || empty($institution)) 
      return 
        $this->err($this->msg['requiredempty']);
    //check if already in db
    $c = new Criteria();
    $c->add(UserPeer::LOGIN, $login);
    $users = UserPeer::doSelect($c);    
    if(count($users)) 
      return $this->err($this->msg['loginexists']);
    $c = new Criteria();
    $c->add(UserPeer::EMAIL, $email);
    $users = UserPeer::doSelect($c);
    if (count($users))
      return $this->err($this->msg['emailexists']);
    //none in DB so create
    // we need the ID of the default access group
    $c = new Criteria();
    $c->add(AccessGroupPeer::GROUP_NAME, $this->defaultAccessGroup);
    $groups = AccessGroupPeer::doSelect($c);
    if (count($groups) == 0) return $this->err("Default access group '".
      $this->defaultAccessGroup."' does not exist. Contact admin.");
    $groupId = $groups[0]->getGroupId();
    $newpass = substr(md5(rand(0,999)), 15, 5);
    //create and populate user but don't save yet - 
    //wait if email was acceppted for delivery
    $user = new User();
    $user->setLogin($login);
    $user->setEncPass($newpass);
    $user->setUserName($name);
    $user->setEmail($email);
    $user->setGroupId($groupId);
    $user->setInstitution($institution);
    
    //send email with pass
    $subject = $this->msg['usrsubject'];
    $tokens = array('$name', '$login', '$pass', '$institution');
    $values = array($name, $login, $newpass, $institution);    
    $body = str_replace($tokens, $values, $this->msg['usrbody']);
    $headers = "From: $this->mailFrom\r\n";
 
    $con = Propel::getConnection();
    try {
      $con->beginTransaction(); 
      $user->save($con);
      if (!mail($email, $subject, $body, $headers))
        throw new Exception($this->msg['emailfailed']);
      $con->commit();
    } catch (Exception $e) {
      $con->rollback();
      return $this->err($e->getMessage());
    }
    #send admin email
    $userEditUrl = $this->adminConsoleBase."/?page=user&action=edituser&userid="
      .$user->getUserId();
    $subject = $this->msg['admsubject'];
    $tokensadm = array_merge($tokens, array('$group','$editurl'));
    $valuesadm = array_merge($values, array($this->defaultAccessGroup, 
      $userEditUrl));    
    $body = str_replace($tokensadm, $valuesadm, $this->msg['admbody']);

    mail($this->adminEmail, $subject, $body);
    $this->sendXMLResponse($this->msg['regok']);
    unset($this->s['captchacode']);
  }

  private function doRemind() {
    if(!isset($this->r['email'])) 
      return $this->err('Missing parameter :email:');
    if (empty($this->r['email']))
      return $this->err($this->msg['emailempty']);
    $email = $this->r['email'];
    $c = new Criteria();
    $c->add(UserPeer::EMAIL, $email);
    $users = UserPeer::doSelect($c);
    if (!count($users)) return $this->err($this->msg['nouser']);
    $name = $users[0]->getUserName();
    $login = $users[0]->getLogin();
    $pass = $users[0]->getEncPass();
    //send email with pass
    $subject = $this->msg['remindsubject'];
    $tokens = array('$name', '$login', '$pass');
    $values = array($name, $login, $pass);    
    $body = str_replace($tokens, $values, $this->msg['remindbody']);
    $headers = "From: $this->mailFrom\r\n";
    $ret = mail($email, $subject, $body, $headers);
    if (!$ret) return $this->err($this->msg['remindfailed']);
    $this->sendXMLResponse($this->msg['remindok']);
  }

  private function sendXMLResponse($msg) {
	  $this->response = new DOMDocument();
	  $this->response->appendChild(new DOMElement('register'));
	  $this->response->documentElement->appendChild(
      new DOMElement('status', 'OK'));
    $this->response->documentElement->appendChild(
	    new DOMElement('message', $msg));
	  header('Content-type: text/xml');
	  echo $this->response->saveXML();
  }

 
  private function err($errMsg) {
  	$this->response = new DOMDocument();
	  $this->response->appendChild(new DOMElement("register"));
	  $this->response->documentElement->appendChild(
	    new DOMElement('status', 'failed'));
	  $this->response->documentElement->appendChild(
	    new DOMElement('message', $errMsg));
	    
    if (false) {
	    $this->response->documentElement->appendChild(
    		new DOMElement('queryString', join(' ', $this->request)));
	    $this->response->documentElement->appendChild(
		    new DOMElement('messageBody', file_get_contents($this->input_path)));
	  }
	    
	  header('Content-type: text/xml');
	  echo $this->response->saveXML();
  }

  //returns GD image type
  private function generateCaptchaImage($code, $width=100, $height=20) {
    $image = ImageCreate($width, $height);  
    //We are making three colors, white, black and gray
    $white = ImageColorAllocate($image, 255, 255, 255);
    $black = ImageColorAllocate($image, 0, 0, 0);
    $grey = ImageColorAllocate($image, 204, 204, 204);
    //Make the background black 
    ImageFill($image, 0, 0, $black); 
    //Add randomly generated string in white to the image
    ImageString($image, 3, 30, 3, $code, $white); 
    //Throw in some lines to make it a little bit harder for any bots to break 
    ImageRectangle($image,0,0,$width-1,$height-1,$grey); 
    imageline($image, 0, $height/2, $width, $height/2, $grey); 
    imageline($image, $width/2, 0, $width/2, $height, $grey);
    return $image;
  }
}
