<?php

require_once 'php/classes/manage/UserData.class.php';

class UserDataWS
{
    private $response;
    private $attrs;
    private $input_path = 'php://input';
    private $userId;
    private $request;
    
    function __construct (&$req) {
	define ("__DEBUG__", false );
	header('Content-type: text/xml');
	
	$this->response = new DOMDocument();
	$this->response->appendChild( new DOMElement('userdataws') );
	$this->attrs = null;
	$this->request = $req;
	
	if ( !( $this->userId = $this->check_user_id() ) )
	    $this->print_error('You are not logged in.');
	
	if ( isset( $req['attrs'] ) )
	    $this->attrs = explode( ',', $req['attrs'] );
    }
    
    function check_user_id () {
	session_start();
	$user_id =  isset( $_SESSION['auth']['policy']['userid']['value'] )
	    ? $_SESSION['auth']['policy']['userid']['value']
	    : false;
	session_write_close();
	return $user_id;
    }

    function save () {
	try {
	    $udDoc = new DOMDocument();
	    $udDoc->load($this->input_path);

	    $ud = new UserData($this->userId);
	    $ud->loadXML($udDoc);
	} catch (Exception $e) {
	    $this->print_error($e->getMessage() );
	}
    }

    function send_response() {
	$this->response->documentElement->appendChild(
	    new DOMElement('status', 'OK') );
	echo $this->response->saveXML();
    }

    function fetch () {
	try {
	    $ud = new UserData($this->userId, $this->attrs );
	} catch (Exception $e) {
	    $this->print_error($e->getMessage() );
	}
	$this->response->documentElement->appendChild (
	    $this->response->importNode( $ud->documentElement, true ) );
    }

    function print_error ($errMsg) {
	$this->response->documentElement->appendChild (
	    new DOMElement('status', 'failed') );
	$this->response->documentElement->appendChild (
	    new DOMElement('message', $errMsg) );
	    
	if (__DEBUG__) {
	    $this->response->documentElement->appendChild (
		new DOMElement('get_params', join(' ', $this->request ) ) );
	    $this->response->documentElement->appendChild (
		new DOMElement('post_input',
			       file_get_contents($this->input_path) ) );
	}
	    
	echo $this->response->saveXML();
	exit;
    }
}