<?php
class CategoryTree extends DOMDocument
{
    private $categories;

    public function __construct()
    {
        parent::__construct('1.0', 'utf-8');
        $rootNode = $this->appendChild( new DOMElement('categories') );
        
        $c = new Criteria();
        $c->addAscendingOrderByColumn(CategoryPeer::CAT_NAME);
        $this->categories = CategoryPeer::doSelect($c);
        $this->findChildren($rootNode, 0);
    }

    public function selectNodesWithTargetId ($targetId)
    {
        $c = new Criteria();
        $c->add(TargetRefCatPeer::TARGET_ID, $targetId);
        $t2cs = TargetRefCatPeer::doSelect($c);

        foreach ($t2cs as $t2c) {
            foreach ($this->getElementsByTagName('category') as $cat) {
                if ( $cat->getAttribute('id') == $t2c->getCatId() )
                    $cat->setAttribute('selected','true');
            }
        }
    }

    private function findChildren ($root, $catId)
    {
        foreach ( $this->categories as $category )
        {
            if ( $category->getParentId() == $catId )
            {
                $catNode = $root->appendChild(new DOMElement('category'));
                $catNode->setAttribute('id', $category->getCatId());
                $catNode->setAttribute('name', $category->getCatName());
                $this->findChildren($catNode, $category->getCatId());
            }
        }
    }
}
