<?php

/* $Id: OaiTask.class.php,v 1.4 2007-05-30 09:59:32 sondberg Exp $
 * --------------------------------------------------------------------------
 * This class implements methods for interrogating task files
 */

class OaiTask extends DOMDocument
{
    private $taskFile;
    protected $taskNs = 'http://www.indexdata.com/OAI-PMH/1.0';

    public function __construct ($info = array())
    {
        parent::__construct('1.0', 'utf-8');

        if ( isset($info['task_file']) ) {
            $this->taskFile = $info['task_file'];
            $this->load($this->taskFile);
        } elseif ( isset($info['task_dir']) &&
                   isset($info['data']) ) {
            $this->taskFile = $info['task_dir'] . '/' .
                              'oai-repository-' . time() . getmypid() . '.xml';

            $bootstrap = '<oai-repository xmlns="' . $this->taskNs . '"/>';
            $this->loadXML($bootstrap);

            if ( !$this->update($info['data']) )
                die('Fixme: Throw an exception!');
        } else {
            die('Must be called with either task_file or task_dir and data');
        }
    }

/*
    public function update ($name, $value)
    {
        $root = $this->documentElement;
        $nodes = $root->getElementsByTagName($name);

        if ($nodes->length == 1) {
            $node = $nodes->item(0);
            $this->resetNode($node);
            $txt_node = $this->createTextNode($value);
            $node->appendChild($txt_node);
        }
    }
*/


    public function delete ()
    {
        if ( $this->lock() ) {
            unlink($this->taskFile);
            $this->unlock();
            return true;
        } else
            return false;
    }


    public function update ($info)
    {
        if ( $this->lock() ) {
            foreach ($info as $key => $value) {
                $nodes = $this->getElementsByTagName($key);

                if ($nodes->length) {
                    $node = $nodes->item(0);
                    $this->resetNode($node);
                } else {
                    $node = $this->createElement($key);
                    $this->documentElement->appendChild($node);
                }

                $text_node = $this->createTextNode($value);
                $node->appendChild($text_node);
            }

            $this->save($this->taskFile);
            $this->unlock();

            return true;
        } else {
            return false;
        }
    }


    private function getLockFile ()
    {
        return $this->taskFile . '.excl';
    }


    public function lock ()
    {
        $lockfile = $this->getLockFile();

        if ( file_exists($lockfile) ) {
            return false;
        }

        $fh = fopen($lockfile, 'w');
        fputs($fh, getmypid());
        fclose($fh);

        return true;
    }

    public function unlock ()
    {
        $lockfile = $this->getLockFile();

        if ( !file_exists($lockfile) ) {
            return false;
        }

        $fh = fopen($lockfile, 'r');
        $contents = fread($fh, 10);
        $pid = trim($contents);

        if ($pid != getmypid())
            return false;

        unlink($lockfile);

        return true;
    }


    protected function resetNode ($node)
    {
        while ($node->hasChildNodes())
            $node->removeChild($node->firstChild);
    }


    public function save ()
    {
        parent::save($this->taskFile);
    }


}
