<?php
class UserData extends DOMDocument
{
    private $user;

    public function __construct($userId, $attrNames = null)
    {
        $this->user = UserPeer::retrieveByPK($userId);

        if ( !$this->user )
            throw new Exception("User with ID: $userId does not exist.");

        parent::__construct('1.0', 'utf-8');
        $root = $this->appendChild( new DOMElement('user') );

        if ( isset($attrNames) && is_array($attrNames) ) {
            foreach( $attrNames as $attrName ) {
                $root->setAttribute( $attrName, $this->getSetByAttribute( $attrName ) );
            }
        } else {
            $root->setAttribute( 'name', $this->user->getUserName() );
            $root->setAttribute( 'institution', $this->user->getInstitution() );    
            $root->setAttribute( 'pass', $this->user->getEncPass() );
            $root->setAttribute( 'login', $this->user->getLogin() );
            $root->setAttribute( 'email', $this->user->getEmail() );
            $root->setAttribute( 'ourl_resolver', $this->user->getOurlResolver() );
            $root->setAttribute( 'group_id', $this->user->getGroupId() );
            $root->setAttribute( 'sel_enabled', $this->user->getSelEnabled() );
        }
    } 

    public function loadXML (DOMDocument $xmlDoc)
    {
        $con = Propel::getConnection();
        $con->beginTransaction();

        $udDoc = $xmlDoc->getElementsByTagName('user')->item(0);

        foreach ( $udDoc->attributes as $attr ) {
            $this->getSetByAttribute($attr->nodeName, $attr->nodeValue);
        }

        $this->user->save();
        $con->commit();
    }

    private function getSetByAttribute ( $name, $value = null )
    {
            if ( isset($value) ) {
                $method_name = 'set';
                $param_value = $value;
            } else {
                $method_name = 'get';
                $param_value = null;
            }

            foreach ( $parts = explode( '_', $name ) as $part ) {
                $method_name = $method_name . ucfirst($part);
            }

            if ( method_exists( $this->user, $method_name ) )
                $ret = call_user_func( array(&$this->user, $method_name), $param_value );
            else
                throw new Exception('User table does not contain "'.
                    $name.'" field');

            return $ret;
    }
}
