<?php

/*
 *  $Id: PHP5BasicPeerBuilder.php 602 2007-03-07 17:52:53Z hans $
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the LGPL. For more information please see
 * <http://propel.phpdb.org>.
 */

require_once 'propel/engine/builder/om/PeerBuilder.php';

/**
 * Generates a PHP5 base Peer class for user object model (OM).
 *
 * This class produces the base peer class (e.g. BaseMyPeer) which contains all
 * the custom-built query and manipulator methods.
 *
 * This class replaces the Peer.tpl, with the intent of being easier for users
 * to customize (through extending & overriding).
 *
 * @author     Hans Lellelid <hans@xmpl.org>
 * @package    propel.engine.builder.om.php5
 */
class PHP5BasicPeerBuilder extends PeerBuilder {

	/**
	 * Returns the name of the current class being built.
	 * @return     string
	 */
	public function getUnprefixedClassname()
	{
		return $this->getBuildProperty('basePrefix') . $this->getStubPeerBuilder()->getUnprefixedClassname();
	}

	/**
	 * Gets the package for the [base] peer classes.
	 * @return     string
	 */
	public function getPackage()
	{
		return parent::getPackage() . ".om";
	}

	/**
	 * Adds the include() statements for files that this class depends on or utilizes.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addIncludes(&$script)
	{
	} // addIncludes()

	/**
	 * Adds class phpdoc comment and openning of class.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addClassOpen(&$script) {

		$tableName = $this->getTable()->getName();
		$tableDesc = $this->getTable()->getDescription();

		$script .= "
/**
 * Base static class for performing query and update operations on the '$tableName' table.
 *
 * $tableDesc
 *";
		if ($this->getBuildProperty('addTimeStamp')) {
			$now = strftime('%c');
			$script .= "
 * This class was autogenerated by Propel " . $this->getBuildProperty('version') . " on:
 *
 * $now
 *";
		}
		$script .= "
 * @package    ".$this->getPackage()."
 */
abstract class ".$this->getClassname()." {
";
	}

	/**
	 * Closes class.
	 * Adds closing brace at end of class and the static map builder registration code.
	 * @param      string &$script The script will be modified in this method.
	 * @see        addStaticMapBuilderRegistration()
	 */
	protected function addClassClose(&$script)
	{
		$script .= "
} // " . $this->getClassname() . "
";
		$this->addStaticMapBuilderRegistration($script);
	}

	/**
	 * Adds the static map builder registration code.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addStaticMapBuilderRegistration(&$script)
	{
		$table = $this->getTable();
		$mapBuilderFile = $this->getMapBuilderBuilder()->getClassFilePath();

		$script .= "
// This is the static code needed to register the MapBuilder for this table with the main Propel class.
//
// NOTE: This static code cannot call methods on the ".$this->getPeerClassname()." class, because it is not defined yet.
// If you need to use overridden methods, you can add this code to the bottom of the ".$this->getPeerClassname()." class:
//
// Propel::getDatabaseMap(".$this->getPeerClassname()."::DATABASE_NAME)->addTableBuilder(".$this->getPeerClassname()."::TABLE_NAME, ".$this->getPeerClassname()."::getMapBuilder());
//
// Doing so will effectively overwrite the registration below.

Propel::getDatabaseMap(".$this->getClassname()."::DATABASE_NAME)->addTableBuilder(".$this->getClassname()."::TABLE_NAME, ".$this->getClassname()."::getMapBuilder());

";
	}

	/**
	 * Adds constant and variable declarations that go at the top of the class.
	 * @param      string &$script The script will be modified in this method.
	 * @see        addColumnNameConstants()
	 */
	protected function addConstantsAndAttributes(&$script)
	{
		$tableName = DataModelBuilder::prefixTableName($this->getTable()->getName());
		$dbName = $this->getDatabase()->getName();
		$script .= "
	/** the default database name for this class */
	const DATABASE_NAME = '$dbName';

	/** the table name for this class */
	const TABLE_NAME = '$tableName';

	/** A class that can be returned by this peer. */
	const CLASS_DEFAULT = '".$this->getStubObjectBuilder()->getClasspath()."';

	/** The total number of columns. */
	const NUM_COLUMNS = ".$this->getTable()->getNumColumns().";

	/** The number of lazy-loaded columns. */
	const NUM_LAZY_LOAD_COLUMNS = ".$this->getTable()->getNumLazyLoadColumns().";

";
		$this->addColumnNameConstants($script);
		$this->addInheritanceColumnConstants($script);

		$script .= "
	/**
	 * An identiy map to hold any loaded instances of ".$this->getObjectClassname()." objects.
	 * This must be public so that other peer classes can access this when hydrating from JOIN
	 * queries.
	 * @var        array ".$this->getObjectClassname()."[]
	 */
	public static \$instances = array();

	/**
	 * The MapBuilder instance for this peer.
	 * @var        MapBuilder
	 */
	private static \$mapBuilder = null;
";

		$this->addFieldNamesAttribute($script);
		$this->addFieldKeysAttribute($script);

	}

	/**
	 * Adds the COLUMN_NAME contants to the class definition.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addColumnNameConstants(&$script)
	{
		foreach ($this->getTable()->getColumns() as $col) {

			$script .= "
	/** the column name for the ".strtoupper($col->getName()) ." field */
	const ".$this->getColumnName($col) ." = '".DataModelBuilder::prefixTablename($this->getTable()->getName()).".".strtoupper($col->getName())."';
";
		} // foreach
	}

	protected function addFieldNamesAttribute(&$script)
	{
		$table = $this->getTable();

		$tableColumns = $table->getColumns();

		$script .= "
	/**
	 * holds an array of fieldnames
	 *
	 * first dimension keys are the type constants
	 * e.g. self::\$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
	 */
	private static \$fieldNames = array (
		BasePeer::TYPE_PHPNAME => array (";
		foreach ($tableColumns as $col) {
			$script .= "'".$col->getPhpName()."', ";
		}
		$script .= "),
		BasePeer::TYPE_STUDLYPHPNAME => array (";
		foreach ($tableColumns as $col) {
			$script .= "'".$col->getStudlyPhpName()."', ";
		}
		$script .= "),
		BasePeer::TYPE_COLNAME => array (";
		foreach ($tableColumns as $col) {
			$script .= $this->getColumnConstant($col, 'self').", ";
		}
		$script .= "),
		BasePeer::TYPE_FIELDNAME => array (";
		foreach ($tableColumns as $col) {
			$script .= "'".$col->getName()."', ";
		}
		$script .= "),
		BasePeer::TYPE_NUM => array (";
		foreach ($tableColumns as $num => $col) {
			$script .= "$num, ";
		}
		$script .= ")
	);
";
	}

	protected function addFieldKeysAttribute(&$script)
	{
		$table = $this->getTable();

		$tableColumns = $table->getColumns();

		$script .= "
	/**
	 * holds an array of keys for quick access to the fieldnames array
	 *
	 * first dimension keys are the type constants
	 * e.g. self::\$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
	 */
	private static \$fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array (";
		foreach ($tableColumns as $num => $col) {
			$script .= "'".$col->getPhpName()."' => $num, ";
		}
		$script .= "),
		BasePeer::TYPE_STUDLYPHPNAME => array (";
		foreach ($tableColumns as $num => $col) {
			$script .= "'".$col->getStudlyPhpName()."' => $num, ";
		}
		$script .= "),
		BasePeer::TYPE_COLNAME => array (";
		foreach ($tableColumns as $num => $col) {
			$script .= $this->getColumnConstant($col, 'self')." => $num, ";
		}
		$script .= "),
		BasePeer::TYPE_FIELDNAME => array (";
		foreach ($tableColumns as $num => $col) {
			$script .= "'".$col->getName()."' => $num, ";
		}
		$script .= "),
		BasePeer::TYPE_NUM => array (";
		foreach ($tableColumns as $num => $col) {
			$script .= "$num, ";
		}
		$script .= ")
	);
";
	} // addFielKeysAttribute


	protected function addGetFieldNames(&$script)
	{
		$script .= "
	/**
	 * Returns an array of of field names.
	 *
	 * @param      string \$type The type of fieldnames to return:
	 *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     array A list of field names
	 */

	static public function getFieldNames(\$type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists(\$type, self::\$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter \$type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . \$type . ' was given.');
		}
		return self::\$fieldNames[\$type];
	}
";

	} // addGetFieldNames()

	protected function addTranslateFieldName(&$script)
	{
		$script .= "
	/**
	 * Translates a fieldname to another type
	 *
	 * @param      string \$name field name
	 * @param      string \$fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @param      string \$toType   One of the class type constants
	 * @return     string translated name of the field.
	 * @throws     PropelException - if the specified name could not be found in the fieldname mappings.
	 */
	static public function translateFieldName(\$name, \$fromType, \$toType)
	{
		\$toNames = self::getFieldNames(\$toType);
		\$key = isset(self::\$fieldKeys[\$fromType][\$name]) ? self::\$fieldKeys[\$fromType][\$name] : null;
		if (\$key === null) {
			throw new PropelException(\"'\$name' could not be found in the field names of type '\$fromType'. These are: \" . print_r(self::\$fieldKeys[\$fromType], true));
		}
		return \$toNames[\$key];
	}
";
	} // addTranslateFieldName()

	/**
	 * Adds the getMapBuilder() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addGetMapBuilder(&$script)
	{
		$script .= "
	/**
	 * Get a (singleton) instance of the MapBuilder for this peer class.
	 * @return     MapBuilder The map builder for this peer
	 */
	public static function getMapBuilder()
	{
		if (self::\$mapBuilder === null) {
			require '" . $this->getMapBuilderBuilder()->getClassFilePath()."';
			self::\$mapBuilder = new ".$this->getMapBuilderBuilder()->getClassname()."();
		}
		return self::\$mapBuilder;
	}";
	}

	/**
	 * Adds the CLASSKEY_* and CLASSNAME_* constants used for inheritance.
	 * @param      string &$script The script will be modified in this method.
	 */
	public function addInheritanceColumnConstants(&$script)
	{
		if ($this->getTable()->getChildrenColumn()) {

			$col = $this->getTable()->getChildrenColumn();
			$cfc = $col->getPhpName();

			if ($col->isEnumeratedClasses()) {

				if ($col->isPhpPrimitiveNumericType()) $quote = "";
				else $quote = '"';

				foreach ($col->getChildren() as $child) {
					$childBuilder = $this->getMultiExtendObjectBuilder();
					$childBuilder->setChild($child);

					$script .= "
	/** A key representing a particular subclass */
	const CLASSKEY_".strtoupper($child->getKey())." = '" . $child->getKey() . "';
";
					
	if (strtoupper($child->getClassname()) != strtoupper($child->getKey())) {
		$script .= "
	/** A key representing a particular subclass */
	const CLASSKEY_".strtoupper($child->getClassname())." = '" . $child->getKey() . "';
";
	}
	
	$script .= "
	/** A class that can be returned by this peer. */
	const CLASSNAME_".strtoupper($child->getKey())." = '". $childBuilder->getClasspath() . "';
";
				} /* foreach children */
			} /* if col->isenumerated...() */
		} /* if table->getchildrencolumn() */

	} //

	/**
	 * Adds the alias() utility method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addAlias(&$script)
	{
		$script .= "
	/**
	 * Convenience method which changes table.column to alias.column.
	 *
	 * Using this method you can maintain SQL abstraction while using column aliases.
	 * <code>
	 *		\$c->addAlias(\"alias1\", TablePeer::TABLE_NAME);
	 *		\$c->addJoin(TablePeer::alias(\"alias1\", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
	 * </code>
	 * @param      string \$alias The alias for the current table.
	 * @param      string \$column The column name for current table. (i.e. ".$this->getPeerClassname()."::COLUMN_NAME).
	 * @return     string
	 */
	public static function alias(\$alias, \$column)
	{
		return str_replace(".$this->getPeerClassname()."::TABLE_NAME.'.', \$alias.'.', \$column);
	}
";
	} // addAliasMethod

	/**
	 * Adds the addSelectColumns() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addAddSelectColumns(&$script)
	{
		$script .= "
	/**
	 * Add all the columns needed to create a new object.
	 *
	 * Note: any columns that were marked with lazyLoad=\"true\" in the
	 * XML schema will not be added to the select list and only loaded
	 * on demand.
	 *
	 * @param      criteria object containing the columns to add.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function addSelectColumns(Criteria \$criteria)
	{
";
		foreach ($this->getTable()->getColumns() as $col) {
			if (!$col->isLazyLoad()) {
				$script .= "
		\$criteria->addSelectColumn(".$this->getPeerClassname()."::".$this->getColumnName($col).");
";
			} // if !col->isLazyLoad
		} // foreach
		$script .="
	}
";
	} // addAddSelectColumns()



	/**
	 * Adds the COUNT constants.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addCountConstants(&$script)
	{
		$table = $this->getTable();
		$count_col = "*";
		/*
		* FIXME
		* (HL) wanted to remove this because AFAIK count(*) is generally
		* optimized in databases, and furthermore the code below isn't correct
		* (multi-pkey needs to be accounted for)....
		*/
		if ($table->hasPrimaryKey()) {
			$pk = $table->getPrimaryKey();
			$count_col = DataModelBuilder::prefixTablename($table->getName())
			. "." . strtoupper($pk[0]->getName());
		}

		$script .= "
	const COUNT = 'COUNT($count_col)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT $count_col)';
";
	}

	/**
	 * Adds the doCount() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoCount(&$script)
	{
		$script .= "
	/**
	 * Returns the number of rows matching criteria.
	 *
	 * @param      Criteria \$criteria
	 * @param      boolean \$distinct Whether to select only distinct columns (You can also set DISTINCT modifier in Criteria).
	 * @param      PDO \$con
	 * @return     int Number of matching rows.
	 */
	public static function doCount(Criteria \$criteria, \$distinct = false, PDO \$con = null)
	{
		// we're going to modify criteria, so copy it first
		\$criteria = clone \$criteria;

		// clear out anything that might confuse the ORDER BY clause
		\$criteria->clearSelectColumns()->clearOrderByColumns();
		if (\$distinct || in_array(Criteria::DISTINCT, \$criteria->getSelectModifiers())) {
			\$criteria->addSelectColumn(".$this->getPeerClassname()."::COUNT_DISTINCT);
		} else {
			\$criteria->addSelectColumn(".$this->getPeerClassname()."::COUNT);
		}

		// just in case we're grouping: add those columns to the select statement
		foreach (\$criteria->getGroupByColumns() as \$column)
		{
			\$criteria->addSelectColumn(\$column);
		}

		\$stmt = ".$this->getPeerClassname()."::doSelectStmt(\$criteria, \$con);
		if (\$row = \$stmt->fetch(PDO::FETCH_NUM)) {
			return (int) \$row[0];
		} else {
			// no rows returned; we infer that means 0 matches.
			return 0;
		}
	}";
	}

	/**
	 * Adds the doSelectOne() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoSelectOne(&$script)
	{
		$script .= "
	/**
	 * Method to select one object from the DB.
	 *
	 * @param      Criteria \$criteria object used to create the SELECT statement.
	 * @param      PDO \$con
	 * @return     ".$this->getObjectClassname()."
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelectOne(Criteria \$criteria, PDO \$con = null)
	{
		\$critcopy = clone \$criteria;
		\$critcopy->setLimit(1);
		\$objects = ".$this->getPeerClassname()."::doSelect(\$critcopy, \$con);
		if (\$objects) {
			return \$objects[0];
		}
		return null;
	}";
	}

	/**
	 * Adds the doSelect() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoSelect(&$script)
	{
		$script .= "
	/**
	 * Method to do selects.
	 *
	 * @param      Criteria \$criteria The Criteria object used to build the SELECT statement.
	 * @param      PDO \$con
	 * @return     array Array of selected Objects
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doSelect(Criteria \$criteria, PDO \$con = null)
	{
		return ".$this->getPeerClassname()."::populateObjects(".$this->getPeerClassname()."::doSelectStmt(\$criteria, \$con));
	}";
	}

	/**
	 * Adds the doSelectStmt() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoSelectStmt(&$script)
	{

		$script .= "
	/**
	 * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
	 *
	 * Use this method directly if you want to work with an executed statement durirectly (for example
	 * to perform your own object hydration).
	 *
	 * @param      Criteria \$criteria The Criteria object used to build the SELECT statement.
	 * @param      PDO \$con The connection to use
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 * @return     PDOStatement The executed PDOStatement object.
	 * @see        ".$this->basePeerClassname."::doSelect()
	 */
	public static function doSelectStmt(Criteria \$criteria, PDO \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!\$criteria->getSelectColumns()) {
			\$criteria = clone \$criteria;
			".$this->getPeerClassname()."::addSelectColumns(\$criteria);
		}

		// Set the correct dbName
		\$criteria->setDbName(self::DATABASE_NAME);

		// BasePeer returns a PDOStatement
		return ".$this->basePeerClassname."::doSelect(\$criteria, \$con);
	}";
	}

	/**
	 * Creates a convenience method to add objects to an instance pool.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addAddInstanceToPool(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Adds an object to the instance pool.
	 *
	 * Propel keeps cached copies of objects in an instance pool when they are retrieved
	 * from the database.  In some cases -- especially when you override doSelect*()
	 * methods in your stub classes -- you may need to explicitly add objects
	 * to the cache in order to ensure that the same objects are always returned by doSelect*()
	 * and retrieveByPK*() calls.
	 *
	 * @param      ".$this->getObjectClassname()." \$value A ".$this->getObjectClassname()." object.
	 */
	public static function addInstanceToPool(".$this->getObjectClassname()." \$obj)
	{
		// print \"+Adding (by addInstanceToPool()) \" . get_class(\$obj) . \" \" . var_export(\$obj->getPrimaryKey(),true) . \" to instance pool.\\n\";
	";
		$pk = $this->getTable()->getPrimaryKey();
		if (count($pk) > 1) {
			$script .= "
		\$key = serialize(\$obj->getPrimaryKey());";
		} else {
			$script .= "
		\$key = (string) \$obj->getPrimaryKey();";
		}
		$script .= "
		self::\$instances[\$key] = \$obj;
	}
";
	}

	/**
	 *  Creates a convenience method to remove objects form an instance pool.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addRemoveInstanceFromPool(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Removes an object from the instance pool.
	 *
	 * Propel keeps cached copies of objects in an instance pool when they are retrieved
	 * from the database.  In some cases -- especially when you override doDelete
	 * methods in your stub classes -- you may need to explicitly remove objects
	 * from the cache in order to prevent returning objects that no longer exist.
	 *
	 * @param      mixed \$value A ".$this->getObjectClassname()." object or a primary key value.
	 */
	public static function removeInstanceFromPool(\$value)
	{";
		$pk = $table->getPrimaryKey();

		$script .= "
		if (is_object(\$value) && \$value instanceof ".$this->getObjectClassname().") {
			// print \"-Removing \" . get_class(\$value) . \" \" . var_export(\$value->getPrimaryKey(),true) . \" from instance pool.\\n\";
		";
		if (count($pk) > 1) {
			$script .= "
			\$key = serialize(\$value->getPrimaryKey());";
		} else {
			$script .= "
			\$key = (string) \$value->getPrimaryKey();";
		}

		$script .= "
		} elseif (".(count($pk) > 1 ? "is_array(\$value)" : "is_scalar(\$value)").") {
			// print \"-Removing pk: \" . var_export(\$value,true) . \" class: ".$this->getObjectClassname()." from instance pool.\\n\";
			// assume we've been passed a primary key";

		if ($pk > 1) {
			$script .= "
			\$key = serialize(\$value);";
		} else {
			$script .= "
			\$key = (string) \$value;";
		}
		$script .= "
		} else {

			\$e = new PropelException(\"Invalid value passed to removeInstanceFromPool().  Expected primary key or ".$this->getObjectClassname()." object: \" . var_export(\$value,true));
			print \$e;
			throw \$e;
		}

		unset(self::\$instances[\$key]);

	} // removeInstanceFromPool()
";
	} // addRemoveFromInstancePool()

	/**
	 * Adds method to clear the instance pool.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addClearInstancePool(&$script)
	{
		$script .= "
	/**
	 * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
	 *
	 * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
	 * a multi-column primary key, a serialize()d version of the primary key will be returned.
	 *
	 * @param      array \$row PDO resultset row.
	 * @param      int \$startcol The 0-based offset for reading from the resultset row.
	 * @return     string
	 */
	public static function clearInstancePool()
	{
		//print \"\\tClearing ".$this->getPeerClassname()." instance pool.\\n\";
		self::\$instances = array();
	}
	";
	}

	/**
	 * Adds method to get an the instance from the pool, given a key.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addGetInstanceFromPool(&$script)
	{
		$script .= "
	/**
	 * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
	 *
	 * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
	 * a multi-column primary key, a serialize()d version of the primary key will be returned.
	 *
	 * @param      string \$key The key (@see getPrimaryKeyHash()) for this instance.
	 * @return     object or NULL if no instance exists for specified key.
	 * @see        getPrimaryKeyHash()
	 */
	public static function getInstanceFromPool(\$key)
	{
		if (isset(self::\$instances[\$key])) {
			//print \"  <-Found ".$this->getObjectClassname()." \" . self::\$instances[\$key] . \" in instance pool.\\n\";
			return self::\$instances[\$key];
		} else {
			return null; // just to be explicit
		}
	}
	";
	}

	/**
	 * Adds method to get a version of the primary key that can be used as a unique key for identifier map.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addGetPrimaryKeyHash(&$script)
	{
		$script .= "
	/**
	 * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
	 *
	 * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
	 * a multi-column primary key, a serialize()d version of the primary key will be returned.
	 *
	 * @param      array \$row PDO resultset row.
	 * @param      int \$startcol The 0-based offset for reading from the resultset row.
	 * @return     string
	 */
	public static function getPrimaryKeyHashFromRow(\$row, \$startcol = 0)
	{";

		// We have to iterate through all the columns so that we know the offset of the primary
		// key columns.
		$n = 0;
		foreach ($this->getTable()->getColumns() as $col) {
			if (!$col->isLazyLoad()) {
				if ($col->isPrimaryKey()) {
					$pk[] = "\$row[\$startcol + $n]";
				}
				$n++;
			}
		}

		// the general case is a single column
		if (count($pk) == 1) {
			$script .= "
		return (string) ".$pk[0].";";
		} else {
			$script .= "
		return serialize(array(".implode(',', $pk)."));";
		}

		$script .= "
	}
";
	} // addGetPrimaryKeyHash

	/**
	 * Adds the populateObjects() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addPopulateObjects(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * The returned array will contain objects of the default type or
	 * objects that inherit from the default.
	 *
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function populateObjects(PDOStatement \$stmt)
	{
		\$results = array();
	";
		if (!$table->getChildrenColumn()) {
			$script .= "
		// set the class once to avoid overhead in the loop
		\$cls = ".$this->getPeerClassname()."::getOMClass();
		\$cls = substr('.'.\$cls, strrpos('.'.\$cls, '.') + 1);";
		}

		$script .= "
		// populate the object(s)
		while (\$row = \$stmt->fetch(PDO::FETCH_NUM)) {
			\$key = ".$this->getPeerClassname()."::getPrimaryKeyHashFromRow(\$row, 0);
			if (isset(self::\$instances[\$key])) {
				// print \"  <-Found \" . get_class(self::\$instances[\$key]) . \" \" . self::\$instances[\$key] . \" in instance pool.\\n\";
				\$results[] = self::\$instances[\$key];
			} else {
		";
		if ($table->getChildrenColumn()) {
			$script .= "
				// class must be set each time from the record row
				\$cls = ".$this->getPeerClassname()."::getOMClass(\$row, 0);
				\$cls = substr('.'.\$cls, strrpos('.'.\$cls, '.') + 1);
				" . $this->buildObjectInstanceCreationCode('$obj', '$cls') . "
				\$obj->hydrate(\$row);
				\$results[] = \$obj;
				// print \"->Adding \" . get_class(\$obj) . \" \" . \$obj . \" into instance pool.\\n\";
				self::\$instances[\$key] = \$obj;";
		} else {
			$script .= "
				" . $this->buildObjectInstanceCreationCode('$obj', '$cls') . "
				\$obj->hydrate(\$row);
				\$results[] = \$obj;
				// print \"->Adding \" . get_class(\$obj) . \" \" . \$obj . \" into instance pool.\\n\";
				self::\$instances[\$key] = \$obj;";
		}
		$script .= "
			} // if key exists
		}
		return \$results;
	}";
	}

	/**
	 * Adds a getOMClass() for non-abstract tables that have inheritance.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addGetOMClass_Inheritance(&$script)
	{
		$col = $this->getTable()->getChildrenColumn();
		$script .= "
	/**
	 * The returned Class will contain objects of the default type or
	 * objects that inherit from the default.
	 *
	 * @param      array \$row PDO result row.
	 * @param      int \$colnum Column to examine for OM class information (first is 0).
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function getOMClass(\$row, \$colnum)
	{
		try {
";
		if ($col->isEnumeratedClasses()) {
			$script .= "
			\$omClass = null;
			\$classKey = \$row[\$colnum + " . ($col->getPosition() - 1) . "];

			switch(\$classKey) {
";
			foreach ($col->getChildren() as $child) {
				$script .= "
				case self::CLASSKEY_".$child->getKey().":
					\$omClass = self::CLASSNAME_".strtoupper($child->getKey()).";
					break;
";
			} /* foreach */
			$script .= "
				default:
					\$omClass = self::CLASS_DEFAULT;
";
			$script .= "
			} // switch
";
		} else { /* if not enumerated */
			$script .= "
			\$omClass = \$row[\$colnum + ".($col->getPosition()-1)."];
			\$omClass = substr('.'.\$omClass, strrpos('.'.\$omClass, '.') + 1);
";
		}
		$script .= "
		} catch (Exception \$e) {
			throw new PropelException('Unable to get OM class.', \$e);
		}
		return \$omClass;
	}
";
	}

	/**
	 * Adds a getOMClass() signature for abstract tables that have inheritance.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addGetOMClass_Inheritance_Abstract(&$script)
	{
		$script .= "
	/**
	 * The returned Class will contain objects of the default type or
	 * objects that inherit from the default.
	 *
	 * This method must be overridden by the stub subclass, because
	 * ".$this->getObjectClassname()." is declared abstract in the schema.
	 *
	 * @param      ResultSet \$rs ResultSet with pointer to record containing om class.
	 * @param      int \$colnum Column to examine for OM class information (first is 1).
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	abstract public static function getOMClass();
";
	}

	/**
	 * Adds a getOMClass() for non-abstract tables that do note use inheritance.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addGetOMClass_NoInheritance(&$script)
	{
		$script .= "
	/**
	 * The class that the Peer will make instances of.
	 *
	 * This uses a dot-path notation which is tranalted into a path
	 * relative to a location on the PHP include_path.
	 * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
	 *
	 * @return     string path.to.ClassName
	 */
	public static function getOMClass()
	{
		return ".$this->getPeerClassname()."::CLASS_DEFAULT;
	}
";
	}

	/**
	 * Adds a getOMClass() signature for abstract tables that do not have inheritance.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addGetOMClass_NoInheritance_Abstract(&$script)
	{
		$script .= "
	/**
	 * The class that the Peer will make instances of.
	 *
	 * This method must be overridden by the stub subclass, because
	 * ".$this->getObjectClassname()." is declared abstract in the schema.
	 */
	abstract public static function getOMClass();
";
	}

	/**
	 * Adds the doInsert() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoInsert(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Method perform an INSERT on the database, given a ".$this->getObjectClassname()." or Criteria object.
	 *
	 * @param      mixed \$values Criteria or ".$this->getObjectClassname()." object containing data that is used to create the INSERT statement.
	 * @param      PDO \$con the PDO connection to use
	 * @return     mixed The new primary key.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doInsert(\$values, \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (\$values instanceof Criteria) {
			\$criteria = clone \$values; // rename for clarity
		} else {
			\$criteria = \$values->buildCriteria(); // build Criteria from ".$this->getObjectClassname()." object
		}
";

		foreach ($table->getColumns() as $col) {
			$cfc = $col->getPhpName();
			if ($col->isPrimaryKey() && $col->isAutoIncrement() && $table->getIdMethod() != "none") {
				$script .= "
		\$criteria->remove(".$this->getColumnConstant($col)."); // remove pkey col since this table uses auto-increment
";
			}
		}
		$script .= "

		// Set the correct dbName
		\$criteria->setDbName(self::DATABASE_NAME);

		try {
			// use transaction because \$criteria could contain info
			// for more than one table (I guess, conceivably)
			\$con->beginTransaction();
			\$pk = ".$this->basePeerClassname."::doInsert(\$criteria, \$con);
			\$con->commit();
		} catch(PropelException \$e) {
			\$con->rollback();
			throw \$e;
		}

		return \$pk;
	}
";
	}

	/**
	 * Adds the doUpdate() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoUpdate(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Method perform an UPDATE on the database, given a ".$this->getObjectClassname()." or Criteria object.
	 *
	 * @param      mixed \$values Criteria or ".$this->getObjectClassname()." object containing data that is used to create the UPDATE statement.
	 * @param      PDO \$con The connection to use (specify PDO connection object to exert more control over transactions).
	 * @return     int The number of affected rows (if supported by underlying database driver).
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function doUpdate(\$values, PDO \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection(self::DATABASE_NAME);
		}

		\$selectCriteria = new Criteria(self::DATABASE_NAME);

		if (\$values instanceof Criteria) {
			\$criteria = clone \$values; // rename for clarity
";
		foreach ($table->getColumns() as $col) {
			if ($col->isPrimaryKey()) {
				$script .= "
			\$comparison = \$criteria->getComparison(".$this->getColumnConstant($col).");
			\$selectCriteria->add(".$this->getColumnConstant($col).", \$criteria->remove(".$this->getColumnConstant($col)."), \$comparison);
";
			}  /* if col is prim key */
	 	} /* foreach */

		$script .= "
		} else { // \$values is ".$this->getObjectClassname()." object
			\$criteria = \$values->buildCriteria(); // gets full criteria
			\$selectCriteria = \$values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
		}

		// set the correct dbName
		\$criteria->setDbName(self::DATABASE_NAME);

		return {$this->basePeerClassname}::doUpdate(\$selectCriteria, \$criteria, \$con);
	}
";
	}

	/**
	 * Adds the doDeleteAll() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoDeleteAll(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Method to DELETE all rows from the ".$table->getName()." table.
	 *
	 * @return     int The number of affected rows (if supported by underlying database driver).
	 */
	public static function doDeleteAll(\$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection(self::DATABASE_NAME);
		}
		\$affectedRows = 0; // initialize var to track total num of affected rows
		try {
			// use transaction because \$criteria could contain info
			// for more than one table or we could emulating ON DELETE CASCADE, etc.
			\$con->beginTransaction();
			";
			if ($this->isDeleteCascadeEmulationNeeded()) {
				$script .="\$affectedRows += ".$this->getPeerClassname()."::doOnDeleteCascade(new Criteria(), \$con);
			";
			}
			if ($this->isDeleteSetNullEmulationNeeded()) {
				$script .= $this->getPeerClassname() . "::doOnDeleteSetNull(new Criteria(), \$con);
			";
			}
			$script .= "\$affectedRows += BasePeer::doDeleteAll(".$this->getPeerClassname()."::TABLE_NAME, \$con);
			\$con->commit();
			return \$affectedRows;
		} catch (PropelException \$e) {
			\$con->rollback();
			throw \$e;
		}
	}
";
	}

	/**
	 * Adds the doDelete() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoDelete(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Method perform a DELETE on the database, given a ".$this->getObjectClassname()." or Criteria object OR a primary key value.
	 *
	 * @param      mixed \$values Criteria or ".$this->getObjectClassname()." object or primary key or array of primary keys
	 *              which is used to create the DELETE statement
	 * @param      PDO \$con the connection to use
	 * @return     int 	The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
	 *				if supported by native driver or if emulated using Propel.
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	 public static function doDelete(\$values, PDO \$con = null)
	 {
		if (\$con === null) {
			\$con = Propel::getConnection(".$this->getPeerClassname()."::DATABASE_NAME);
		}

		if (\$values instanceof Criteria) {
			// invalidate the cache for all objects of this type, since we have no
			// way of knowing (without running a query) what objects should be invalidated
			// from the cache based on this Criteria.
			".$this->getPeerClassname()."::clearInstancePool();

			// rename for clarity
			\$criteria = clone \$values;
		} elseif (\$values instanceof ".$this->getObjectClassname().") {
			// invalidate the cache for this single object
			".$this->getPeerClassname()."::removeInstanceFromPool(\$values);";

		if (count($table->getPrimaryKey()) > 0) {
			$script .= "
			// create criteria based on pk values
			\$criteria = \$values->buildPkeyCriteria();";
		} else {
			$script .= "
			// create criteria based on pk value
			\$criteria = \$values->buildCriteria();";
		}

		$script .= "
		} else {
			// it must be the primary key

			// we can invalidate the cache for this single object
			".$this->getPeerClassname()."::removeInstanceFromPool(\$values);

			\$criteria = new Criteria(self::DATABASE_NAME);";

		if (count($table->getPrimaryKey()) === 1) {
			$pkey = $table->getPrimaryKey();
			$col = array_shift($pkey);
			$script .= "
			\$criteria->add(".$this->getColumnConstant($col).", (array) \$values, Criteria::IN);";
		} else {
			$script .= "
			// primary key is composite; we therefore, expect
			// the primary key passed to be an array of pkey
			// values
			if (count(\$values) == count(\$values, COUNT_RECURSIVE))
			{
				// array is not multi-dimensional
				\$values = array(\$values);
			}
			\$vals = array();
			foreach (\$values as \$value)
			{
";
			$i=0;
			foreach ($table->getPrimaryKey() as $col) {
				$script .= "
				\$vals[$i][] = \$value[$i];";
				$i++;
			}
			$script .= "
			}
";
			$i=0;
			foreach ($table->getPrimaryKey() as $col) {
				$script .= "
			\$criteria->add(".$this->getColumnConstant($col).", \$vals[$i], Criteria::IN);";
				$i++;
			}
		} /* if count(table->getPrimaryKeys()) */

		$script .= "
		}

		// Set the correct dbName
		\$criteria->setDbName(self::DATABASE_NAME);

		\$affectedRows = 0; // initialize var to track total num of affected rows

		try {
			// use transaction because \$criteria could contain info
			// for more than one table or we could emulating ON DELETE CASCADE, etc.
			\$con->beginTransaction();
			";

		if ($this->isDeleteCascadeEmulationNeeded()) {
			$script .= "\$affectedRows += ".$this->getPeerClassname()."::doOnDeleteCascade(\$criteria, \$con);";
		}
		if ($this->isDeleteSetNullEmulationNeeded()) {
			$script .= $this->getPeerClassname() . "::doOnDeleteSetNull(\$criteria, \$con);";
		}

		$script .= "
			\$affectedRows += {$this->basePeerClassname}::doDelete(\$criteria, \$con);
";
		// Handle ON DELETE CASCADE for updating instance pool

		foreach ($table->getReferrers() as $fk) {

			// $fk is the foreign key in the other table, so localTableName will
			// actually be the table name of other table
			$tblFK = $fk->getTable();

			$joinedTablePeerBuilder = OMBuilder::getNewPeerBuilder($tblFK);
			$tblFKPackage = $joinedTablePeerBuilder->getStubPeerBuilder()->getPackage();

			if (!$tblFK->isForReferenceOnly()) {
				// we can't perform operations on tables that are
				// not within the schema (i.e. that we have no map for, etc.)

				$fkClassName = $joinedTablePeerBuilder->getObjectClassname();

				// i'm not sure whether we can allow delete cascade for foreign keys
				// within the same table?  perhaps we can?
				if ( ($fk->getOnDelete() == ForeignKey::CASCADE || $fk->getOnDelete() == ForeignKey::SETNULL )
							&& $tblFK->getName() != $table->getName()) {
					$script .= "
			// invalidate objects in ".$joinedTablePeerBuilder->getPeerClassname()." instance pool, since one or more of them may be deleted by ON DELETE CASCADE rule.
			".$joinedTablePeerBuilder->getPeerClassname()."::clearInstancePool();
";
  				} // if fk is on delete cascade

  			} // if (! for ref only)

  		} // foreach



		$script .= "
			\$con->commit();
			return \$affectedRows;
		} catch (PropelException \$e) {
			\$con->rollback();
			throw \$e;
		}
	}
";
	}

	/**
	 * Adds the doOnDeleteCascade() method, which provides ON DELETE CASCADE emulation.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoOnDeleteCascade(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
	 * feature (like MySQL or SQLite).
	 *
	 * This method is not very speedy because it must perform a query first to get
	 * the implicated records and then perform the deletes by calling those Peer classes.
	 *
	 * This method should be used within a transaction if possible.
	 *
	 * @param      Criteria \$criteria
	 * @param      PDO \$con
	 * @return     int The number of affected rows (if supported by underlying database driver).
	 */
	protected static function doOnDeleteCascade(Criteria \$criteria, PDO \$con)
	{
		// initialize var to track total num of affected rows
		\$affectedRows = 0;

		// first find the objects that are implicated by the \$criteria
		\$objects = ".$this->getPeerClassname()."::doSelect(\$criteria, \$con);
		foreach (\$objects as \$obj) {
";

		foreach ($table->getReferrers() as $fk) {

			// $fk is the foreign key in the other table, so localTableName will
			// actually be the table name of other table
			$tblFK = $fk->getTable();

			$joinedTablePeerBuilder = OMBuilder::getNewPeerBuilder($tblFK);
			$tblFKPackage = $joinedTablePeerBuilder->getStubPeerBuilder()->getPackage();

			if (!$tblFK->isForReferenceOnly()) {
				// we can't perform operations on tables that are
				// not within the schema (i.e. that we have no map for, etc.)

				$fkClassName = $joinedTablePeerBuilder->getObjectClassname();

				// i'm not sure whether we can allow delete cascade for foreign keys
				// within the same table?  perhaps we can?
				if ( $fk->getOnDelete() == ForeignKey::CASCADE && $tblFK->getName() != $table->getName()) {

					// backwards on purpose
					$columnNamesF = $fk->getLocalColumns();
					$columnNamesL = $fk->getForeignColumns();

					$script .= "

			// delete related $fkClassName objects
			\$c = new Criteria();
			";
					for ($x=0,$xlen=count($columnNamesF); $x < $xlen; $x++) {
						$columnFK = $tblFK->getColumn($columnNamesF[$x]);
						$columnL = $table->getColumn($columnNamesL[$x]);

						$script .= "
			\$c->add(".$joinedTablePeerBuilder->getColumnConstant($columnFK) .", \$obj->get".$columnL->getPhpName()."());";
					}

					$script .= "
			\$affectedRows += ".$joinedTablePeerBuilder->getPeerClassname()."::doDelete(\$c, \$con);";

				} // if cascade && fkey table name != curr table name

			} // if not for ref only
		} // foreach foreign keys
			$script .= "
		}
		return \$affectedRows;
	}
";
	} // end addDoOnDeleteCascade

	/**
	 * Adds the doOnDeleteSetNull() method, which provides ON DELETE SET NULL emulation.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoOnDeleteSetNull(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * This is a method for emulating ON DELETE SET NULL DBs that don't support this
	 * feature (like MySQL or SQLite).
	 *
	 * This method is not very speedy because it must perform a query first to get
	 * the implicated records and then perform the deletes by calling those Peer classes.
	 *
	 * This method should be used within a transaction if possible.
	 *
	 * @param      Criteria \$criteria
	 * @param      PDO \$con
	 * @return     void
	 */
	protected static function doOnDeleteSetNull(Criteria \$criteria, PDO \$con)
	{

		// first find the objects that are implicated by the \$criteria
		\$objects = ".$this->getPeerClassname()."::doSelect(\$criteria, \$con);
		foreach (\$objects as \$obj) {
";

		// This logic is almost exactly the same as that in doOnDeleteCascade()
		// it may make sense to refactor this, provided that thigns don't
		// get too complicated.

		foreach ($table->getReferrers() as $fk) {

			// $fk is the foreign key in the other table, so localTableName will
			// actually be the table name of other table
			$tblFK = $fk->getTable();
			$refTablePeerBuilder = OMBuilder::getNewPeerBuilder($tblFK);

			if (!$tblFK->isForReferenceOnly()) {
				// we can't perform operations on tables that are
				// not within the schema (i.e. that we have no map for, etc.)

				$fkClassName = $refTablePeerBuilder->getObjectClassname();

				// i'm not sure whether we can allow delete setnull for foreign keys
				// within the same table?  perhaps we can?
				if ( $fk->getOnDelete() == ForeignKey::SETNULL &&
						$fk->getTable()->getName() != $table->getName()) {

							// backwards on purpose
							$columnNamesF = $fk->getLocalColumns();
							$columnNamesL = $fk->getForeignColumns(); // should be same num as foreign
					$script .= "
			// set fkey col in related $fkClassName rows to NULL
			\$selectCriteria = new Criteria(".$this->getPeerClassname()."::DATABASE_NAME);
			\$updateValues = new Criteria(".$this->getPeerClassname()."::DATABASE_NAME);";

					for ($x=0,$xlen=count($columnNamesF); $x < $xlen; $x++) {
						$columnFK = $tblFK->getColumn($columnNamesF[$x]);
						$columnL = $table->getColumn($columnNamesL[$x]);
						$script .= "
			\$selectCriteria->add(".$refTablePeerBuilder->getColumnConstant($columnFK).", \$obj->get".$columnL->getPhpName()."());
			\$updateValues->add(".$refTablePeerBuilder->getColumnConstant($columnFK).", null);
";
					}

					$script .= "
			{$this->basePeerClassname}::doUpdate(\$selectCriteria, \$updateValues, \$con); // use BasePeer because generated Peer doUpdate() methods only update using pkey
";
				} // if setnull && fkey table name != curr table name
			} // if not for ref only
		} // foreach foreign keys

		$script .= "
		}
	}
";
	}

	/**
	 * Adds the doValidate() method.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addDoValidate(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Validates all modified columns of given ".$this->getObjectClassname()." object.
	 * If parameter \$columns is either a single column name or an array of column names
	 * than only those columns are validated.
	 *
	 * NOTICE: This does not apply to primary or foreign keys for now.
	 *
	 * @param      ".$this->getObjectClassname()." \$obj The object to validate.
	 * @param      mixed \$cols Column name or array of column names.
	 *
	 * @return     mixed TRUE if all columns are valid or the error message of the first invalid column.
	 */
	public static function doValidate(".$this->getObjectClassname()." \$obj, \$cols = null)
	{
		\$columns = array();

		if (\$cols) {
			\$dbMap = Propel::getDatabaseMap(".$this->getPeerClassname()."::DATABASE_NAME);
			\$tableMap = \$dbMap->getTable(".$this->getPeerClassname()."::TABLE_NAME);

			if (! is_array(\$cols)) {
				\$cols = array(\$cols);
			}

			foreach (\$cols as \$colName) {
				if (\$tableMap->containsColumn(\$colName)) {
					\$get = 'get' . \$tableMap->getColumn(\$colName)->getPhpName();
					\$columns[\$colName] = \$obj->\$get();
				}
			}
		} else {
";
		foreach ($table->getValidators() as $val) {
			$col = $val->getColumn();
			if (!$col->isAutoIncrement()) {
				$script .= "
		if (\$obj->isNew() || \$obj->isColumnModified(".$this->getColumnConstant($col)."))
			\$columns[".$this->getColumnConstant($col)."] = \$obj->get".$col->getPhpName()."();
";
			} // if
  		} // foreach

  		$script .= "
		}

		return {$this->basePeerClassname}::doValidate(".$this->getPeerClassname()."::DATABASE_NAME, ".$this->getPeerClassname()."::TABLE_NAME, \$columns);
	}
";
	} // end addDoValidate()

	/**
	 * Adds the retrieveByPK method for tables with single-column primary key.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addRetrieveByPK_SinglePK(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Retrieve a single object by pkey.
	 *
	 * @param      mixed \$pk the primary key.
	 * @param      PDO \$con the connection to use
	 * @return     " .$this->getObjectClassname(). "
	 */
	public static function ".$this->getRetrieveMethodName()."(\$pk, PDO \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection(self::DATABASE_NAME);
		}

		\$criteria = new Criteria(".$this->getPeerClassname()."::DATABASE_NAME);
";
		if (count($table->getPrimaryKey()) === 1) {
			$pkey = $table->getPrimaryKey();
			$col = array_shift($pkey);
			$script .= "
		\$criteria->add(".$this->getColumnConstant($col).", \$pk);
";
		} else {
			// primary key is composite; we therefore, expect
			// the primary key passed to be an array of pkey
			// values
			$i=0;
			foreach ($table->getPrimaryKey() as $col) {
	   			$script .= "
		\$criteria->add(".$this->getColumnConstant($col).", \$pk[$i]);";
				$i++;
			}
		} /* if count(table.PrimaryKeys) */
		$script .= "

		\$v = ".$this->getPeerClassname()."::doSelect(\$criteria, \$con);

		return !empty(\$v) > 0 ? \$v[0] : null;
	}
";
	}

	/**
	 * Adds the retrieveByPKs method for tables with single-column primary key.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addRetrieveByPKs_SinglePK(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Retrieve multiple objects by pkey.
	 *
	 * @param      array \$pks List of primary keys
	 * @param      PDO \$con the connection to use
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function ".$this->getRetrieveMethodName()."s(\$pks, PDO \$con = null)
	{
		if (\$con === null) {
			\$con = Propel::getConnection(self::DATABASE_NAME);
		}

		\$objs = null;
		if (empty(\$pks)) {
			\$objs = array();
		} else {
			\$criteria = new Criteria();";
		if (count($table->getPrimaryKey()) == 1) {
			$k1 = $table->getPrimaryKey();
			$script .= "
			\$criteria->add(".$this->getColumnConstant($k1[0]).", \$pks, Criteria::IN);";
		} else {
			$script .= "
			foreach (\$pks as \$pk) {";
			$i = 0;
			foreach ($table->getPrimaryKey() as $col) {
				$script .= "
				\$c{$i} = \$criteria->getNewCriterion(".$this->getPeerClassname($col).", \$pk[$i], Criteria::EQUAL);";
				$j = $i - 1;
				if ($i > 0) {
					$script .= "
				\$c{$j}->addAnd(\$c{$i});";
				} /* if $i > 0 */
				$i++;
			} /* foreach */

			$script .= "

				\$criteria->addOr(\$c0);
			}";
		} /* if count prim keys == 1 */
		$script .= "
			\$objs = ".$this->getPeerClassname()."::doSelect(\$criteria, \$con);
		}
		return \$objs;
	}
";
	}

	/**
	 * Adds the retrieveByPK method for tables with multi-column primary key.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addRetrieveByPK_MultiPK(&$script)
	{
		$table = $this->getTable();
		$script .= "
	/**
	 * Retrieve object using using composite pkey values.
	 * ";
		foreach ($table->getPrimaryKey() as $col) {
			$clo = strtolower($col->getName());
			$cptype = $col->getPhpType();
			$script .= "@param $cptype $".$clo."
	   ";
	   }
	   $script .= "
	 * @param      PDO \$con
	 * @return     ".$this->getObjectClassname()."
	 */
	public static function ".$this->getRetrieveMethodName()."(";
		$co = 0;
		foreach ($table->getPrimaryKey() as $col) {
			$clo = strtolower($col->getName());
			$script .= ($co++ ? "," : "") . " $".$clo;
		} /* foreach */
		$script .= ", PDO \$con = null) {
		if (\$con === null) {
			\$con = Propel::getConnection(self::DATABASE_NAME);
		}
		\$criteria = new Criteria();";
		foreach ($table->getPrimaryKey() as $col) {
			$clo = strtolower($col->getName());
			$script .= "
		\$criteria->add(".$this->getColumnConstant($col).", $".$clo.");";
		}
		$script .= "
		\$v = ".$this->getPeerClassname()."::doSelect(\$criteria, \$con);

		return !empty(\$v) ? \$v[0] : null;
	}";
	}

	/**
	 * Adds the getTableMap() method which is a convenience method for apps to get DB metadata.
	 * @param      string &$script The script will be modified in this method.
	 */
	protected function addGetTableMap(&$script)
	{
		$script .= "
	/**
	 * Returns the TableMap related to this peer.
	 * This method is not needed for general use but a specific application could have a need.
	 * @return     TableMap
	 * @throws     PropelException Any exceptions caught during processing will be
	 *		 rethrown wrapped into a PropelException.
	 */
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}
";

	}
} // PHP5BasicPeerBuilder
