<?xml version="1.0"?>
<!--
    $Id: frame.xsl,v 1.2 2007-05-24 11:41:54 sondberg Exp $
-->
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:form="http://indexdata.dk/pazpar2/manage/input"
    xmlns:php="http://php.net/xsl"
    
    exclude-result-prefixes="form php">

  <xsl:output method="html"
      doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
      encoding="utf-8"
      indent="yes"/>

  <xsl:variable name="input" select="/*/form:input"/>
  <xsl:variable name="page" select="$input/data/@page"/>
  <xsl:variable name="action" select="$input/data/@action"/>
  <xsl:variable name="errno" select="$input/data/@errno"/>
  <xsl:variable name="errmsg" select="$input/data/@errmsg"/>

  <xsl:template match="/*">
    <html>
      <head>
        <title><xsl:value-of select="title"/></title>
        <link rel="author" href="http://www.indexdata.dk" />
        <link rel="stylesheet" href="css/auth.css" type="text/css"/>
        <link href="css/styles.css" rel="stylesheet"
              type="text/css" media="screen, all" />
        <script src="js/tools.js" type="text/javascript" />
      </head>
      <body>
        <xsl:call-template name="insert-header"/>
        <xsl:call-template name="insert-menu"/>
        <xsl:call-template name="display-error"/>
        <xsl:call-template name="insert-body"/>
        <xsl:call-template name="insert-footer"/>

        
        <!--<DATA><xsl:copy-of select="$input"/></DATA>-->
        
        <!--
        <CONFIG><xsl:copy-of select="/*"/></CONFIG>
        -->
      </body>
    </html>
  </xsl:template>


  <xsl:template name="insert-header">
    <h1><xsl:value-of select="title"/></h1>
    <hr/>
  </xsl:template>

  
  <xsl:template name="display-error">
    <xsl:if test="$errno">
      <div class="error">
        Error [<xsl:value-of select="$errno"/>] <xsl:value-of select="$errmsg"/>
      </div>
    </xsl:if>
  </xsl:template>


  <xsl:template name="insert-footer">
    <hr/>
  </xsl:template>


  <xsl:template name="insert-body">
    FIXME: This template should be implemented in base stylesheet!!!
  </xsl:template>


</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
