<?xml version="1.0"?>
<!--
    $Id: manage_oai.xsl,v 1.10 2008-01-18 12:02:37 sondberg Exp $
-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:task="http://www.indexdata.com/OAI-PMH/1.0"
  xmlns:php="http://php.net/xsl">

  <xsl:import href="include.xsl"/>

  <xsl:variable name="oaiid" select="string($input/data/@oaiid)"/>
  <xsl:variable name="date_format" select="'Y/m/d-H:i:s'"/>
  <xsl:variable name="oai_task_dir" select="string(/*/oaiTaskDir/text())"/>

  <xsl:template name="insert-body">
    <h4>OAI Harvesting</h4>

    <form name="oaiForm" method="post">
      <input type="hidden" name="action" value="nop"/>
      <input type="hidden" name="oaiid" value="null"/>
      <input type="hidden" name="page" value="{$page}"/>

      <xsl:choose>
        <xsl:when test="$action = 'editoai'">
          <xsl:call-template name="insert-oai-editor">
            <xsl:with-param name="task"
              select="php:function('get_oai_tasks', $oai_task_dir)/*/task[@id = $oaiid]"/>
          </xsl:call-template>
        </xsl:when>

        <xsl:when test="$action = 'addoai'">
          <xsl:call-template name="insert-oai-editor">
            <xsl:with-param name="task" select="/*/defaultOai"/>
          </xsl:call-template>
        </xsl:when>

        <xsl:otherwise>
          <xsl:call-template name="insert-oai-overview"/>
        </xsl:otherwise>
      </xsl:choose>
    </form>
  </xsl:template>


  <xsl:template name="insert-oai-editor">
    <xsl:param name="task"/>

    <table>
      <tr>
        <td><b>Repository Name:</b></td>
        <td>
          <input class="long" type="text" name="task[title]"
                 value="{$task/@title}"/>
        </td>
      </tr>
      <tr>
        <td><b>Base URL:</b></td>
        <td>
          <input class="long" type="text" name="task[url]"
                 value="{$task/@url}"/>
        </td>
      </tr>
      <tr>
        <td><b>Harvest Interval:</b></td>
        <td><input type="text" name="task[interval]" value="{$task/@interval}"/>
        </td>
      </tr>
      <tr>
        <td><b>Local Storage Base:</b></td>
        <td><input type="text" name="task[base]" value="{$task/@base}"/>
        </td>
      </tr>
      <tr>
        <td><b>Last Pinged:</b></td>
        <td>
          <xsl:call-template name="insert-time">
            <xsl:with-param name="t" select="$task/@lastPinged"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td><b>Last Harvested:</b></td>
        <td>
          <xsl:call-template name="insert-time">
            <xsl:with-param name="t" select="$task/@lastHarvested"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td><b>Status:</b></td>
        <td>
          <xsl:call-template name="insert-oai-status">
            <xsl:with-param name="task" select="$task"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>

    <p>
      <input type="button" value="Save"
             onclick="set_action(document.oaiForm, 'saveoai', '{$oaiid}')"/>
    </p>
  </xsl:template>


  <xsl:template name="insert-oai-status">
    <xsl:param name="task"/>
    <xsl:param name="type" select="'detailed'"/>

    <xsl:choose>
      <xsl:when test="$task/@errorMsg">
        <xsl:choose>
          <xsl:when test="$type = 'detailed'">
            <span style="color: red;">Error: </span>
            <xsl:value-of select="$task/@errorMsg"/>
          </xsl:when>
          <xsl:otherwise><span style="color: red;">!</span></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>OK</xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="insert-time">
    <xsl:param name="t"/>
    <xsl:param name="na" select="'n/a'"/>

    <xsl:choose>
      <xsl:when test="string-length($t) &gt; 0">
        <xsl:value-of
            select="php:function('epoch_to_time', string($t), $date_format)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$na"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="insert-oai-overview">
    <table width="75%" cellspacing="0">
      <tr>
        <td width="5%">#</td>
        <td>Name</td>
        <td>Last pinged</td>
        <td width="10%" align="center">Status</td>
        <td>&#xa0;</td>
        <td>&#xa0;</td>
      </tr>

      <xsl:for-each select="php:function('get_oai_tasks', $oai_task_dir)/*/task">
        <tr>
          <xsl:if test="position() mod 2 = 1">
            <xsl:attribute name="style">background-color: lightgray;
            </xsl:attribute>
          </xsl:if>
          <td><xsl:value-of select="position()"/></td>
          <td><xsl:value-of select="@title"/></td>
          <td>
            <xsl:call-template name="insert-time">
              <xsl:with-param name="t" select="@lastPinged"/>
            </xsl:call-template>
          </td>
          <td align="center">
            <xsl:call-template name="insert-oai-status">
              <xsl:with-param name="task" select="."/>
              <xsl:with-param name="type" select="'brief'"/>
            </xsl:call-template>
          </td>
          <td><input type="button" value="Edit"
                 onclick="set_action(document.oaiForm, 'editoai', '{@id}')"/>
          </td>
          <td><input type="button" value="Delete"
                 onclick="set_action(document.oaiForm, 'deleteoai', '{@id}')"/>
          </td>
        </tr>
      </xsl:for-each>
    </table>

    <p>
      <input type="button" value="Add task"
        onclick="set_action(document.oaiForm, 'addoai')"/>
    </p>
  </xsl:template>

</xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
