var Bool = function () 
{
    this.isEmpty = true;
}

var ResourceSelect = function ( params )
{
    if (typeof params != 'object' )
        throw new Error ('Requires a hash with parameters!');
    this._placeHolder = document.getElementById( params['divId'] );
    this._favsPh = document.getElementById(params['favsId']);
    this._selSaveForm = document.getElementById(params['selSaveId']);
    this._server = params['userDataWS'] || '.';
    this._currentSelection = 'default';
    this._selections = {};
    this._sel_enabled = false;
    this.data = null;
}

ResourceSelect.prototype = 
{
  saveCurrSelection: function (name) {
    if (!name) { 
      alert(msg['favnoname']);
      return;
    }
    if (typeof this._selections[name] != "undefined") {
      var ans = confirm(msg['favoverwrite']);
      if (!ans) return;
    }
    var copy = clone(this._selections[this._currentSelection])
    this._selections[name] = copy;
    this._sentSelection();
    this.renderSelections();
  },
  
  loadNamedSelection: function (name) {
    if (typeof this._selections[name] == "undefined") return;
    var copy = clone(this._selections[name])
    this._selections[this._currentSelection] = copy;
    this.loadSelection(this._selections[this._currentSelection]);
    document.getElementById('selName').value = name;
  },

  deleteNamedSelection: function (name) {
    var ans = confirm(msg['favdel'].replace('$', name));
    if (!ans) return;
    delete this._selections[name];
    this._sentSelection();
    this.renderSelections();
  },

  renderSelections: function () {
    $(this._favsPh).empty();
    var context = this;
    var span = $('<span><b>'+lang['favsels']+'</b></span>');
    var sep = ' ';
    var i = 0;
    for (var name in this._selections) {
      if (name === this._currentSelection) continue;
      i++;
      span.append(sep);
      var a = $('<a>'+name+'</a>');
      a.click(function () {
          context.loadNamedSelection(this.firstChild.nodeValue);
      });
      a.appendTo(span);
      span.append('(');
      var del = $('<a title="Delete selection" toDel="'+name+'">-</a>');
      del.click(function () {
          context.deleteNamedSelection(this.getAttribute('toDel'));
      });
      span.append(del);
      span.append(')');
      sep = ', ';
    }
    if (i > 0) {
      $(this._favsPh).append(span);
    }
  },

    fetchSelection: function (data)
    {
      document.getElementById('selName').value = '';
      $(this._selSaveForm).hide();
      this._selections = {};
      this._selections['default'] = {};
      this._currentSelection = 'default';
      this._sel_enabled = false;
      var context = this;
      var sel_req = new pzHttpRequest(this._server);
      sel_req.get({"command" : "fetch", "attrs" : "selection,sel_enabled" },
        function (response) {
          // try to fetch previous selection
          // this will fail for ipauth
          context.loaded = true;
          if (response.getElementsByTagName('status')[0]
              .firstChild.nodeValue == 'OK' ) {              
            var sel_enabled = response.getElementsByTagName('user')[0]
              .getAttribute('sel_enabled');
            if (sel_enabled) { 
              context._sel_enabled = true; 
            } else {                  
              context._sel_enabled = false;
              return;            
            }

            if (context._sel_enabled)
              $(context._selSaveForm).show();
            else
              $(context._selSaveForm).hide();
              
              
            try {
              var selections = $.parseJSON(response
                .getElementsByTagName('user')[0].getAttribute('selection'));
              if (typeof selections != 'object') {
                selections = {};
              }
              if (typeof selections['default'] == 'undefined') {
                //backward compat
                var defSelection = selections;
                selections = {};
                selections['default'] = defSelection;
              }
              context._selections = selections;
            } catch (e) {
              context._selections = {};
              context._selections['default'] = {};
            }
          } else {
            context._sel_enabled = false;
          }          
          context.renderSelections();
          
          //when the fetching of previous selection is done, 
          //build the tree
          if (data != undefined) {
              context.build(data);
          }
        }
      );
    },

    build: function (data)
    {
        var ph = $(this._placeHolder);
        ph.empty();    
        var catTree = this._buildTree(data, new Bool());
        catTree.addClass('dir')
            .appendTo(ph)
            .Treeview();
        if (this._sel_enabled)
          this.loadSelection(this._selections[this._currentSelection]);
    },

    _buildTree: function ( data, currentBool  )
    {
        var catsUl = $('<ul></ul>');
    
        if (data) {
            for(var i = 0; i < data.length; i++) {                
              var catId = 'catid_' + data[i]["catid"]; 
              var catLi = $('<li id="'+catId+'" class="closed" cbtype="cat"/>');
                
                var cInp = $('<input type="checkbox"/>');

                var context = this;
                cInp.click ( function () { context.checkCategory(this); } );

                catLi.append(cInp);
                catLi.append('<b>' + data[i]["catname"] + '</b>');

                var childBool = new Bool();
                var subUl = this._buildTree( data[i]["subcats"], childBool );           
                 
                for( var j=0; j < data[i]["targets"].length; j++) {             
                    var tId = data[i]["targets"][j]["id"];
                    var tName = data[i]["targets"][j]["name"];
                    var tDesc = data[i]["targets"][j]["desc"];
                    var tNameAlt = data[i]["targets"][j]["name_alt"];
                    var tDescAlt = data[i]["targets"][j]["desc_alt"];
                    
                    //billingual hac
                    if (confLangCode != defLangCode) {
                      if (tNameAlt != null) tName = tNameAlt;
                      if (tDescAlt != null) tDesc = tDescAlt;
                    }
                    
                    childBool.isEmpty = false;

                    var tLi = $('<li id="'+tId+'" class="tooltip"/>');
                    
                    var tInp = $('<input type="checkbox" class="targetCb" value="'
                                + tId +'"/>');

                    tInp.click( function() { context.checkTarClick(this); } );
                    if (tDesc != null && tDesc != '')
                      tLi.append('<span>'+tDesc+'</span>');
                    tLi.append(tInp);
                    tLi.append(tName)
                    subUl.append(tLi);                    
                }
                
                if ( !childBool.isEmpty ) {
                    currentBool.isEmpty = false;
                    catLi.append(subUl);
                    catsUl.append(catLi);
                }
            }
        }

        if( !currentBool.isEmpty ) {
            return catsUl;
        } else {
            return $('<ul></ul>');
        }

    },

    loadSelection: function (selection) {
      this._loadSelRec($(this._placeHolder).children('ul'), selection, null);
    },
    
    _loadSelRec: function (list, selection, catId) {
      var items = list.children('li');
      for (var i=0; i<items.size(); i++) {
        var item = $(items[i]);
        var cbType = item.attr('cbtype');
        var id = item.attr('id');
        if (cbType === "cat") {
          this._loadSelRec(item.children('ul'), selection, id);
          continue;
        }
        if (!catId) continue;
        var tName = item.text();
        var tCb = item.children('input');
        if (selection[catId] && id in selection[catId]) {
          tCb.attr('checked','checked');
          tCb[0].setAttribute('filterpos', 
              resFilters.addFilter(tName, tCb[0].value)); 
        } else {         
          tCb.attr('checked', false);
          resFilters.removeFilter(tCb[0].getAttribute('filterpos'));
          tCb[0].removeAttribute('filterpos');
        }
      }  
    },

    checkCategory: function (catCheckbox)
    {
        var catId = catCheckbox.parentNode.getAttribute('id');
        var context = this;
        if( catCheckbox.checked == true ) {
            $(catCheckbox)
                .parent()
                .children('ul')
                .children('li')
                .children('input')
                .each( function(){
                        if ( this.checked == false ) {
                            this.checked = true;
                        if(this.className == 'targetCb')
                            context.checkTarget(this, 
                                this.nextSibling.nodeValue, catId);
                        else
                            context.checkCategory(this);
                        }
                    } );
        } else {
            $(catCheckbox)
                .parent()
                .children('ul')
                .children('li')
                .children('input')
                .each( function(){
                        if ( this.checked == true ) {
                            this.checked = false;
                        if(this.className == 'targetCb')
                            context.checkTarget(this, 
                                this.nextSibling.nodeValue, catId);
                        else
                            context.checkCategory(this);
                        }
                    } );
        }
        if (this._sel_enabled) this._sentSelection();
    },

    checkTarClick: function (tCb)
    {
        var catId = tCb.parentNode.parentNode.parentNode
            .getAttribute('id');
        this.checkTarget( tCb, tCb.nextSibling.nodeValue, catId );
        if (this._sel_enabled) this._sentSelection();
    },

    checkTarget: function (tCb, targetName, catId )
    {
      if (tCb.checked == true) {
        tCb.setAttribute('filterpos', 
            resFilters.addFilter(targetName, tCb.value)); 
        if (typeof this._selections[this._currentSelection][catId] != 'object') 
          this._selections[this._currentSelection][catId] = {};
        this._selections[this._currentSelection][catId][tCb.value] = true;
      } else {
        resFilters.removeFilter(tCb.getAttribute('filterpos'));
        tCb.removeAttribute('filterpos');
        if (this._selections[this._currentSelection][catId] &&
            tCb.value in this._selections[this._currentSelection][catId])
          delete this._selections[this._currentSelection][catId][tCb.value];
      }
    },

    _sentSelection: function ()
    {
      //sent the selection array to the server
      var sel_data = document.newXmlDoc('user');
      sel_data.documentElement
          .setAttribute('selection', $.toJSON(this._selections));        
      var req = new pzHttpRequest(this._server);
      req.post({"command" : "save"},
        sel_data,
        function (response) { 
          if (response.getElementsByTagName('status')[0]
            .firstChild.nodeValue != 'OK') {
            //alert("There were problems saving data.");
          }
        }
      );
    }
}
