<?php
/* $Id: WsResponseHash.class.php,v 1.1 2007-08-29 13:54:50 jakub Exp $ */
require_once 'IWsResponse.class.php';
/*
** Web Service response in a form of hash table
**/
class WsResponseHash implements IWsResponse
{
    private $response;
    private $root;

    public function __construct ()
    {
        $this->response = array();
    }

    public function header ()
    {
        header("Content-Type: application/json");        
    }

    public function printResponse ()
    {
        return json_encode($this->response);
    }

    public function setRoot ($root)
    {
        $this->root = $root;
        $this->response[$root] = array();
    }

    // TODO copy or reference?
    public function addEntry ($name, $value = null, $attr = null)
    {
        if ( isset($attr) ) {
            $this->response[$this->root][$name][$name]
                = $attr;
            if ( isset($value) )
                $this->response[$this->root][$name]['value']
                 = $value;
        } else {
            $this->response[$this->root][$name] = $value;
        }
    }

    public function appendEntry ($entry, $name = null)
    {
        if ( isset($name) )
            $this->response[$this->root][$name] = $entry;
        else
            $this->response[$this->root][] = $entry;
    }

    public function addError ($error)
    {
        $this->response[$this->root]['error'] = $error;
    }
}
