<?xml version="1.0"?>
<!--
    $Id: mk_globals.xsl,v 1.13 2009-09-28 13:40:37 jakub Exp $
-->
<xsl:stylesheet
    version="1.0"
    xmlns:mk="http://www.indexdata.dk/masterkey/config/1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="mk" >

  <xsl:variable name="def_lang"
            select="string(page/languages/lang[@default='true'])"/>
    
  <xsl:variable name="lang"
            select="string(page/languages/lang[@selected='true'])"/>

  <xsl:variable name="config" select="/*/mk:config/mk:setting"/>

  <xsl:variable name="core_path" select="$config[@name='core_path']/@value"/>

  <xsl:variable name="pazpar2_proxy" select="$config[@name='pazpar2_proxy']/@value"/>
  <xsl:variable name="pz2js_uri" select="$config[@name='pz2js_uri']/@value"/>
  <xsl:variable name="jquery_uri" select="$config[@name='jquery_uri']/@value"/>
  <xsl:variable name="pazpar2_uri"
                select="$config[@name='pazpar2_uri']/@value"/>
  <xsl:variable name="masterkey_core_uri"
                select="$config[@name='masterkey_core_uri']/@value"/>
  <xsl:variable name="masterkey_auth_uri"
                select="$config[@name='masterkey_auth_uri']/@value"/>

  <xsl:variable name="multi_lang" select="$config[@name='multi_lang']/@value"/>
  <xsl:variable name="auth">
    <xsl:choose>
      <xsl:when test="$config[@name='auth_config']">
        <xsl:text>yes</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>no</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="resource_select"
              select="$config[@name='resource_select']/@value"/>
  <xsl:variable name="profile_edit"
              select="$config[@name='profile_edit']/@value"/>
  <xsl:variable name="registration"
              select="$config[@name='registration']/@value"/>

  <xsl:variable name="about" select="/page/aboutcontent"/>
  <xsl:variable name="help" select="/page/helpcontent"/>

  
  
  <xsl:template name="check-browser-compat">
    <noscript>
      <h2>
        <p>Your browser does not support or allow execution of scripts required by this site to work properly.</p>
        <p>If you run Internet Explorer 6+ or FireFox 2.0+ and see this message ensure the JavaScript is enabled in your browser.</p>
        <p>If you run Internet Explorer 7 add the site to the Trusted Sites group.</p>
        <p>Finally, check your personal firewall settings.</p>
      </h2>
    </noscript>
  </xsl:template>

  <xsl:template name="insert-config-section">
    
    <!-- some pazpar2 and mk config here-->
    <script type="text/javascript">
      
      <xsl:text>defLangCode = "</xsl:text>
      <xsl:value-of select="$def_lang"/>
      <xsl:text>";</xsl:text>
      
      <xsl:text>confLangCode = "</xsl:text>
      <xsl:value-of select="$lang"/>
      <xsl:text>";</xsl:text>

      <xsl:text>confTermlists = [</xsl:text>
        <xsl:for-each select="facetitems/*">
          <xsl:text>"</xsl:text>
          <xsl:value-of select="@value"/>
          <xsl:text>", </xsl:text>
        </xsl:for-each>
      <xsl:text>];</xsl:text>
      
      <xsl:text>confSort = "</xsl:text>
      <xsl:value-of select="sortbyitems/item[@default='yes'][1]/@value" />
      <xsl:text>";</xsl:text>

      <xsl:text>confShowPerPage = Number("</xsl:text>
      <xsl:value-of select="perpageitems/item[@default='yes'][1]/@value" />
      <xsl:text>");</xsl:text>

      <!-- TODO remove this here and call a specific file name in the JS
           directly --> 
      <xsl:text>confDetailsXsl = "mk_details";</xsl:text>

      <xsl:text>ourlResolver = '</xsl:text>
      <xsl:value-of select="$config[@name = 'default_ourl_resolver']/@value" />
      <xsl:text>';</xsl:text>

      <xsl:text>pazpar2_proxy = '</xsl:text>
      <xsl:value-of select="$pazpar2_proxy"/>
      <xsl:text>';</xsl:text>
      
    </script>
    
  </xsl:template>
  <xsl:template name="insert-js-includes">
    
    <script src="{$jquery_uri}/jquery.pack.js" type="text/javascript"/>
    <script src="{$jquery_uri}/jquery.history.js" type="text/javascript"/>
    <script src="{$jquery_uri}/jquery.json.js" type="text/javascript"/>
    <script src="{$jquery_uri}/jquery.corner.js" type="text/javascript"/>
    <script src="{$jquery_uri}/jquery.treeview.js" type="text/javascript"/>
    <link href="{$jquery_uri}/css/treeview.css" rel="stylesheet"
          type="text/css"/>

    <script src="{$pz2js_uri}" type="text/javascript"/>
    <script src="{$masterkey_core_uri}/js/mkEvents.class.js" 
      type="text/javascript"/>
    <script src="{$masterkey_core_uri}/js/mkFilter.class.js" 
      type="text/javascript"/>
    <script src="{$masterkey_core_uri}/js/mkState.class.js" 
      type="text/javascript"/>
    <script src="{$masterkey_core_uri}/js/client.js" type="text/javascript"/>
    
    <xsl:if test="$auth = 'yes'">
      <script src="{$masterkey_auth_uri}/js/Auth.class.js"
              type="text/javascript"/>
      <script src="{$masterkey_core_uri}/js/loginEvents.js"
              type="text/javascript"/>
      <xsl:if test="$resource_select = 'yes'">
        <script src="{$masterkey_core_uri}/js/ResourceSelect.class.js"
                type="text/javascript"/>
      </xsl:if>
      <xsl:if test="$profile_edit = 'yes'">
        <script src="{$masterkey_core_uri}/js/ProfileEdit.class.js"
                type="text/javascript"/>
        <script src="{$masterkey_core_uri}/js/profile_tools.js"
                type="text/javascript"/>
      </xsl:if>
      <xsl:if test="$registration = 'yes'">
        <script src="{$masterkey_core_uri}/js/Register.class.js"
                type="text/javascript"/>
        <script src="{$masterkey_core_uri}/js/register_tools.js"
                type="text/javascript"/>
      </xsl:if>      
    </xsl:if>    
    
  </xsl:template>
    
  </xsl:stylesheet>
<!--
/*
 * Local variables:
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=2 tabstop=4 expandtab
 */
-->
