#!/usr/bin/perl
# Copyright (c) 2010-2013 Index Data, http://www.indexdata.com
#
# ppstat2csv - convert simple text stat to CSV
#

use Data::Dumper;
use Getopt::Long;
use Text::CSV;
use IO::File;
use File::stat;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = 1.8;

my $debug = 0;
my $help;

sub usage () {
    <<EOF;
usage: $0 [ options ] < stat.txt > stat.csv

--debug=0..2      	debug option, default: $debug
EOF
}

my @header = ( "Fail.", "Diagnostic / step errors" );

sub csv_header {
    my $csv   = shift;
    my $names = shift;

    # column names
    my $status = $csv->combine(@$names);
    print $csv->string(), "\n";

    # no empty line
    return;

    # empty line
    my @data = map { undef } @$names;
    $status = $csv->combine(@data);
    print $csv->string(), "\n";
}

######################################################################
#
# main
#

GetOptions( "help" => \$help, ) or die usage;

die &usage if $help;

my $csv = Text::CSV->new(
    {
        quote_char          => '"',
        escape_char         => '"',
        sep_char            => ',',
        eol                 => '',
        binary              => 1,
        allow_loose_quotes  => 1,
        allow_loose_escapes => 1,
        allow_whitespace    => 1,
        blank_is_undef      => 1,
    }
);

print &csv_header( $csv, \@header );

while (<>) {
    if (/^\s*(\d+)\s+(.*)/) {
        my $status = $csv->combine( $1, $2 );
        die "CSV error: " . $csv->error_diag . "\n" if !$status;

        print $csv->string(), "\n";
    }
}

1;
