#!/bin/sh
# Copyright (c) 2013 Index Data, http://www.indexdata.com
# Wolfram Schneider
#
# upload-statistic.sh - upload local statistics to cfrepo.indexdata.com

# die on error
set -e

umask 002

config=/etc/pazpar2-statistic.rc
if [ -e $config ]; then
    . $config
fi

: ${CFREPO_DATA_DIR=/var/lib/cf-repo/.statistic}
: ${PP_STAT_FILES=".reliability-pazpar2-today-full.csv"}
: ${CFREPO_UPLOAD_URL="https://cfrepo-test.indexdata.com/upload.pl/1.0"}
: ${PP_STAT_HOSTNAME="armada.indexdata.com"}
: ${CFREPO_AUTH=idtest:foo}
: ${PP_DEBUG=0}

cd $CFREPO_DATA_DIR

if [ -z "$PP_DEBUG" -o "$PP_DEBUG" = 0 ]; then
    exec >/dev/null
fi

for file in $PP_STAT_FILES
do
   if [ -f $file ]; then
	url="$CFREPO_UPLOAD_URL/$PP_STAT_HOSTNAME/$file"
	echo -n "upload $file to $url "
	if ! curl -fs -u $CFREPO_AUTH -H "Expect:" -F "file=@./$file" $url; then
	     echo "Fail: $url" >&2
	fi
   else
	echo "Ignore $file"
   fi
done
