<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: handler.php,v 1.3 2003/09/09 14:31:32 adam Exp $
*/

function scheme_tkl_targets($scheme, $path) {
  global $dir;
  require_once ($dir."/targets/php/targets.php");
  
  make_targets($targets = array());
  
  $arg_str = preg_replace("/^.*?\/\?/", "", $path);
  
  $parms = explode("&", $arg_str);
  $xml = "";
  foreach ($parms as $arg) {
      if (preg_match("/^([^=]*)=(.*)$/", $arg, $match)) {
	  $varname = $match[1];
	  $value = $match[2];
	  $$varname = $value;
      } else {
	  die("Argument format unknown '$arg'");
      }
  }
  if (!strlen($type)) {
      die("Argument type must be set");
  } elseif ($type == "selected") {
      $myhost = $_GET['host'];
      if (is_array($myhost)) {
	  foreach ($myhost as $hh) {
	      $h = $targets[$hh];
	      if (!is_array($h)) {
		  echo "<pre>";
		  print_r($myhost);
		  print_r($h);
		  echo "</pre>";
		  die("is not an array");
	      }
	      $xml .="<target id=\"".$h['nick']."\">\n";
	      $xml .= make_xml($h, 0);
	      $xml .="</target>\n";
	  }
	  $number = count($myhost);
      } else {
	  $xml = "<error>No targets selected</error>";
      }
  } elseif ($type == "all") {
      $number = 0;
      foreach ($targets as $h) {
	  $xml .="<target id=\"".$h['nick']."\">\n";
	  $xml .= make_xml($h, 0);
	  $xml .="</target>\n";
	  $number++;
      }
  } else {
      die("Don't know what todo with '$type'");
  }
  
  $ret = '<?xml version="1.0" encoding="UTF-8"?>';
  $ret .= "\n<targets number=\"".$number."\">\n" . $xml . "</targets>\n";
  
  if (0) {
      echo '<pre>';
      echo htmlentities($ret);
      echo '</pre>';
  }
  
  return $ret; 
}
    
?>
