<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: metadata.xsl,v 1.7 2003/09/09 14:31:32 adam Exp $
-->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:portcom="http://www.indexdata.dk/TKL"
  xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:param name="showimage"/>
    <xsl:output method="html" encoding="UTF-8"/>

<xsl:template match="/metadata">
    <xsl:call-template name="main-page">
        <xsl:with-param name="title" select="title"/>
    </xsl:call-template>
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<xsl:template name="main-body">
    <xsl:call-template name="insert-path"/>
    <xsl:call-template name="oai-body"/>
</xsl:template>

<!-- now processing oai specific instructions -->

<xsl:template name="oai-body">
    <xsl:variable name="namespace" select="oai_dc:dc"/>
    <xsl:variable name="identifier" select="$namespace/dc:identifier"/>

    <b>Title: </b><br/>
    <a href="{$namespace/dc:identifier}">
    <xsl:apply-templates select="$namespace/dc:title">
    </xsl:apply-templates>
    </a>
    <br/>
    <b>Identifier: </b><br/>
    <xsl:apply-templates select="$namespace/dc:identifier"/>
    <br/>
    <b>Description: </b><br/>
    <xsl:apply-templates select="$namespace/dc:description"/>
    <br/>
    <b>Subject: </b><br/>
    <xsl:apply-templates select="$namespace/dc:subject"/>
    <br/>
    <b>Type: </b><br/>
    <xsl:apply-templates select="$namespace/dc:type"/>
    <br/>
    <b>Creator: </b><br/>
    <xsl:apply-templates select="$namespace/dc:creator"/>
    <br/>
    <b>Publisher: </b><br/>
    <xsl:apply-templates select="$namespace/dc:publisher"/>
    <br/>
    <hr/>
    <b>Language: </b><br/>
    <xsl:apply-templates select="$namespace/dc:language"/>
    <br/>
    <b>Rights: </b><br/>
    <xsl:apply-templates select="$namespace/dc:rights"/>
    <br/>
    <b>Format: </b><br/>
    <xsl:apply-templates select="$namespace/dc:format"/>
    <br/>
    <b>Date Created: </b><br/>
    <xsl:apply-templates select="$namespace/dc:date.x-created"/>
    <br/>
</xsl:template>


<xsl:template match="dc:title">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:description">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:identifier">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:type">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:subject">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:creator">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:publisher">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:language">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:rights">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:format">
    <xsl:value-of select="."/><br/>
</xsl:template>

<xsl:template match="dc:date.x-created">
    <xsl:value-of select="."/><br/>
</xsl:template>



</xsl:stylesheet>

