<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: newspage.xsl,v 1.3 2003/09/09 14:31:32 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="start" select="1"/>
    <xsl:param name="number" select="6"/>

<xsl:template match="/newspage">
    <xsl:call-template name="main-page">
        <xsl:with-param name="title" select="title"/>
    </xsl:call-template>
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<xsl:template name="main-body">
    <xsl:call-template name="insert-path"/>

    <!-- Get the news -->

    <xsl:variable name="news">
      <xsl:for-each select="document(
                      'tkl-find://?path=news*.tkl&amp;select=title|date|content')/*/file">
	<xsl:sort select="date" order="descending"/>
        <xsl:copy-of select="."/>
      </xsl:for-each>
    </xsl:variable>

    <!-- How many to show? -->

    <xsl:variable name="top">
      <xsl:choose>
        <xsl:when test="$start + $number &lt;= count($news/file)">
	  <xsl:value-of select="$start + $number - 1"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="count($news/file)"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <span xml:lang="da">Viser </span>
    <span xml:lang="en">Showing </span>
    <xsl:value-of select="$start"/>-<xsl:value-of select="$top"/>
    <span xml:lang="da"> af </span>
    <span xml:lang="en"> of </span>
    <xsl:value-of select="count($news/file)"/>

     <!-- Next/previous -->

     <xsl:text>. </xsl:text>
     <xsl:if test="$start &gt; 1">
       <a href="?start={$start - $number}">
         <span xml:lang="da">Tilbage</span>
         <span xml:lang="en">Back</span>
       </a>
     </xsl:if>
     <xsl:if test="$start + $number - 1 &lt; count($news/file)">
       <xsl:if test="$start &gt; 1">
         <xsl:text> -- </xsl:text>
       </xsl:if>
       <a href="?start={$start + $number}">
         <span xml:lang="da">Flere</span>
         <span xml:lang="en">More</span>
       </a>
     </xsl:if>

    <ul>
    <xsl:for-each select="$news/file[position() &gt;= $start and position() &lt;= $top]">
	<li>
	    <a name="{date}"/>
	    <span class="brown"><b><xsl:value-of select="title"/></b></span>
	    <br/>
	    <xsl:value-of select="date"/>
	    <br/>
	    <xsl:copy-of select="content/node()"/>
	    <br/>&#xa0;
	</li>
    </xsl:for-each>
    </ul>
</xsl:template>

</xsl:stylesheet>

