<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: oai.xsl,v 1.7 2003/09/09 14:31:32 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/> 

    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="lang"/>

<xsl:template match="oai">
    <xsl:call-template name="main-page"/>
    <!-- <xsl:call-template name="oai-list"/>-->
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<xsl:template name="main-body">
    <xsl:call-template name="oai-list"/> 
</xsl:template>


<xsl:template name="oai-list">
    <xsl:call-template name="insert-path"/>
    <p/>
    <em>
    <span xml:lang="en">Note: This is an experimental service only, not part of
       the official demo portal</span>
    <span xml:lang="da">Bemrk: Dette er en eksperimentel service 
       -- det er ikke en officiel del af testportalen</span>
    </em>
    <p/>
 
         <!--select="document('tkl-find://?path=oai*.tkl&amp;select=oai_dc:dc')/tkl-find/file"> -->
    
    <xsl:for-each
         select="document('tkl-find://?path=oai*.tkl')/tkl-find/file">
         <!-- <xsl:copy-of select="."/> -->
         <xsl:call-template name="oai-short">
            <xsl:with-param name="path" select="@path"/>
         </xsl:call-template>
         <br/>

    </xsl:for-each>

 
</xsl:template>


<xsl:template name="oai-short">
    <xsl:param name="path"/>
    <xsl:variable name="oaidoc" select="document(concat('tkl-file:',$path))/metadata/oai_dc:dc"/>
   <xsl:variable name="displaytitle">  
       <xsl:choose>
          <xsl:when test="$oaidoc/dc:title[@xml:lang=$lang]">
             <xsl:value-of select="$oaidoc/dc:title[@xml:lang=$lang]"/>
          </xsl:when>
          <xsl:when test="$oaidoc/dc:title">
             <xsl:for-each select= "$oaidoc/dc:title">
                 <xsl:value-of select="."/> 
                 <xsl:if test="position()!=last()">, </xsl:if>
             </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
             No Title
          </xsl:otherwise>
       </xsl:choose>
    </xsl:variable>

    <xsl:call-template name="oaititle">
        <xsl:with-param name="displaytitle" 
             select="$displaytitle"/> 
        <xsl:with-param name="url" 
             select="normalize-space($oaidoc/dc:identifier)"/> 
        <xsl:with-param name="oaifile" 
             select="normalize-space($path)"/> 
    </xsl:call-template>
    <xsl:apply-templates select="$oaidoc/dc:subject"/>
</xsl:template>

<xsl:template name="oaititle">
    <xsl:param name="displaytitle"/>
    <xsl:param name="url"/>
    <xsl:param name="oaifile"/>
    <b><a href="{$oaifile}"><xsl:value-of select="$displaytitle"/></a></b>
    <a href="{$url}"><xsl:value-of select="$url"/></a><br/>
</xsl:template>

<xsl:template match="dc:subject">
    <xsl:value-of select="."/><br/>
</xsl:template>


</xsl:stylesheet>
