<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: search.xsl,v 1.26 2003/10/07 08:04:54 sondberg Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    xmlns:zebra="http://www.indexdata.dk/zebra/"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:output method="html" encoding="UTF-8"/>


    <xsl:param name="portpath"/>
    <xsl:param name="field_query1"/>
    <xsl:param name="field_query2"/>
    <xsl:param name="type"/>
    <xsl:param name="query"/>
    <xsl:param name="query1"/>
    <xsl:param name="op1"/>
    <xsl:param name="query2"/>
    <xsl:param name="tkl_bin"/>
    <xsl:param name="tkl_authenticated"/>
    <xsl:param name="tkl_docroot"/>
    <xsl:param name="start" select="1"/>
    <xsl:variable name="number" select="6"/>
    <xsl:param name="sort"/>
    <xsl:param name="origin" select="'local'"/>
    <portcom:session-var name="sort" default="title"/>

<xsl:template match="/search">
    <xsl:call-template name="main-page"/>
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<!--
   Note: this template is a little less pretty than it could be
   because we can't get the current Zebra setup to sort records the
   way we want them (this may have changed by now). That means sorting
   of the entire result set takes place in the stylesheet. 
-->

<xsl:template name="main-body">
    <xsl:variable name="types"
      select="document('tkl-file://authorities/def-typer.tkl')"/>

    <span class="brown">
      <b xml:lang="en">Search</b>
      <b xml:lang="da">S&#xf8;gning</b>
    </span>

    <xsl:choose>
        <xsl:when test="$query or $query1 or $query2 or $type">

	    <xsl:variable name="q">
	      <xsl:call-template name="make-query"/>
	    </xsl:variable>

	    <xsl:variable name="search" select="document(concat(
		'tkl-search://unix:', $portpath, '/db/socket?',
		'cclquery=', $q,
		'&amp;start=', '1',
		'&amp;syntax=xml',
		'&amp;number=', '500',
		'&amp;alphasort=title'))"/>

            <!-- old, fixed-sorting stuff. Delete at leisure
	    <xsl:variable name="records">
	      <xsl:for-each select="$search/*/server/record">
	        <xsl:sort select="*/title/@alphasort"/>
		<xsl:copy-of select="."/>
	      </xsl:for-each>
	    </xsl:variable>
            -->

            <!-- good sorting voodoo -->
            <xsl:variable name="all_records">
              <!-- sort titles --> 
              <xsl:if test="$sort = 'title' or $origin = 'web'">
                <xsl:for-each select="$search/*/server/record">
                  <xsl:sort select="*/title/@alphasort"/>
                  <xsl:copy-of select="."/>
                </xsl:for-each>
              </xsl:if>

              <!-- sort types --> 
              <xsl:if test="$sort = 'type' and not($origin = 'web')">
                <!-- First we collapse the types with their sortcode -->
                <xsl:variable name="typesfolded">
                  <xsl:for-each select="$search/*/server/record">
                    <record>
                      <xsl:copy-of select="*"/>
                      <sorttype>
                        <xsl:variable name="mytype" select="*[1]/type[1]"/>
                        <xsl:variable name="trans" select="$types/*/enum[@value=$mytype]"/>
                        <xsl:value-of select="$trans/@sortcode"/>
                        <xsl:value-of select="$mytype"/>
                        <xsl:if test="not($mytype)">
                          <xsl:choose>
                            <xsl:when test="news">NEWS</xsl:when>
                            <xsl:otherwise>UNKNOWN</xsl:otherwise>
                          </xsl:choose>
                        </xsl:if>
                      </sorttype>
                    </record>
                  </xsl:for-each>
                </xsl:variable>
                <!-- then we sort the records -->
                <xsl:for-each select="$typesfolded/*">
                  <xsl:sort select="sorttype"/>
                  <xsl:copy-of select="."/>
                </xsl:for-each>

              </xsl:if>
            </xsl:variable>

	    <!-- Filter out records of chosen origin, i.e. local/web/oai -->
	    <xsl:variable name="records">
	      <xsl:choose>
	        <xsl:when test="$origin and not($origin='local')">
		  <xsl:for-each select="$all_records/record">
		    <xsl:if test="*/@origin=$origin">
		      <xsl:copy-of select="."/>
		    </xsl:if>
		  </xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
		  <xsl:for-each select="$all_records/record">
		    <xsl:if test="not(string-length(*/@origin)) or not(*/@origin) or */@origin='local'">
		      <xsl:copy-of select="."/>
		    </xsl:if>
		  </xsl:for-each>
		</xsl:otherwise>
	      </xsl:choose>
	    </xsl:variable>

	    <xsl:variable name="hits" select="count($records/record)"/>
	    <xsl:variable name="loc_hits"
	         select="count($all_records/record/*[(not(@origin) or @origin='local') and not(name() = 'sorttype')])"/>
	    <xsl:variable name="oai_hits" select="count($all_records/record/*[@origin='oai' and not(name() = 'sorttype')])"/>
	    <xsl:variable name="web_hits" select="count($all_records/record/*[@origin='web' and not(name() = 'sorttype')])"/>
	    
	    <p/>

	    <xsl:variable name="query_uri" select="concat('&amp;',
	    	'field_query1=', $field_query1, '&amp;',
		'field_query2=', $field_query2, '&amp;',
		'query1=', $query1, '&amp;',
		'query2=', $query2, '&amp;',
		'query=', $query, '&amp;',
		'op1=', $op1, '&amp;',
		'type=', $type)"/>
	    
	    <!-- If hits among web harvested ressources link to these -->
	    <xsl:if test="$web_hits &gt; 0 and not($origin='web')">
	      <p>
	        <img height="8" width="10" src="{$root}/gfx/arrow_brown_right.gif"/>
		<a href="?start=1&amp;origin=web{$query_uri}">
		  <span xml:lang="da">Vis fund fra web hstede kilder:
		  </span>
		  <span xml:lang="en">Show hits from web harvested
		  sources: </span>
		  <xsl:value-of select="$web_hits"/>
		    <span xml:lang="da"> fund</span>
		    <span xml:lang="en"> hits</span>
		</a>
	      </p>
	    </xsl:if>
	    
	    <!-- If hits among oai harvested ressources link to these -->
	    <xsl:if test="$oai_hits &gt; 0 and not($origin='oai')">
	      <p>
	        <img height="8" width="10" src="{$root}/gfx/arrow_brown_right.gif"/>
		<a href="?start=1&amp;origin=oai{$query_uri}">
		  <span xml:lang="da">Vis fund fra OAI hstede kilder:
		  </span>
		  <span xml:lang="en">Show hits from OAI harvested
		  sources: </span>
		  <xsl:value-of select="$oai_hits"/>
		    <span xml:lang="da"> fund</span>
		    <span xml:lang="en"> hits</span>
		</a>
	      </p>
	    </xsl:if>
	    
	    <!-- If hits in local storage link to that -->
	    <xsl:if test="$loc_hits &gt; 0 and (not($origin='local'))">
	      <p>
	        <img height="8" width="10" src="{$root}/gfx/arrow_brown_right.gif"/>
		<a href="?start=1&amp;origin=local{$query_uri}">
		  <span xml:lang="da">Vis fund fra lokal samling: </span>
		  <span xml:lang="en">Show hits from local collection:
		  </span>
		  <xsl:value-of select="$loc_hits"/>
		    <span xml:lang="da"> fund</span>
		    <span xml:lang="en"> hits</span>
		</a>
	      </p>
	    </xsl:if> 
	    
	    <xsl:choose>
	        <xsl:when test="$search/bad_query">
		  <p xml:lang="da">Ulovlig sgning. Prv igen</p>
		  <p xml:lang="en">Bad search. Please try again</p>
		</xsl:when>

		<xsl:when test="$search/error">
		    <p/>ERROR!!!!
		    '<xsl:value-of select="$search/error"/>'
		</xsl:when>

		<xsl:when test="$hits = 0">
		    <xsl:copy-of select="zerohits/node()"/>
		</xsl:when>

		<xsl:otherwise>
                   <b>
         	    <xsl:choose>
	              <xsl:when test="$origin and $origin='web'">
 		        <span xml:lang="da"> Web hstede kilder: </span>
		        <span xml:lang="en"> Web harvested ressources: </span>
                      </xsl:when>
	              <xsl:when test="$origin and $origin='oai'">
 		        <span xml:lang="da"> OAI hstede kilder: </span>
		        <span xml:lang="en"> OAI harvested ressources: </span>
                      </xsl:when>
	              <xsl:when test="$origin and $origin='local'">
 		        <span xml:lang="da"> Lokal samling: </span>
		        <span xml:lang="en"> Local ressources: </span>
                      </xsl:when>
		      <xsl:otherwise>
		         <xsl:if test="not(*/@origin) or */@origin='local'">
		           <span xml:lang="da"> Lokal samling: </span>
		           <span xml:lang="en"> Local ressources: </span>
		        </xsl:if>
		      </xsl:otherwise>
	            </xsl:choose>

		    <xsl:value-of select="$hits"/>
 
		    <span xml:lang="da"> fund</span>
		    <span xml:lang="en"> hits</span>
		    </b>

		    <p/>
		    <xsl:call-template name="previous-next">
		        <xsl:with-param name="search" select="$search"/>
		        <xsl:with-param name="hits" select="$hits"/>
		    </xsl:call-template>

		    <p/>

		    <xsl:for-each select="$records/record[position() &gt;= $start and position() &lt; $start + $number]">

		        <xsl:variable name="url">
			    <xsl:choose>
				<xsl:when test="*/identifier">
				    <xsl:value-of select="normalize-space(*/identifier)"/>
				</xsl:when>
				<xsl:otherwise>
				    <xsl:value-of select="
					concat($root, '/',
					normalize-space(*/zebra:idzebra/zebra:filename))"/>
				</xsl:otherwise>
			    </xsl:choose>
			</xsl:variable>

                          <!-- Show type heading when necessary -->

			<xsl:if test="$sort = 'type' and not($origin='web')">
                          <xsl:if test="sorttype != preceding-sibling::record[1]/sorttype or
                               position() = 1">
                            <xsl:variable name="mytype" select="*[1]/type[1]"/>
                            <xsl:variable name="trans" select="$types/*/enum[@value=$mytype]"/>
                            <b>
                              <xsl:choose>
                                <xsl:when test="$trans">
                                  <xsl:value-of select="$trans"/>
                                </xsl:when>
                                <xsl:when test="sorttype = 'NEWS'">
                                  <xsl:text xml:lang="da">Nyheder</xsl:text>
                                  <xsl:text xml:lang="en">News</xsl:text>
                                </xsl:when>
                                <xsl:when test="sorttype = 'LOCAL'">
                                  <xsl:text xml:lang="da">Lokale ressourcer</xsl:text>
                                  <xsl:text xml:lang="en">Local resources</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:if test="$mytype">
                                    <xsl:text xml:lang="da"> 
                                      Klassifikation : </xsl:text>
                                    <xsl:text xml:lang="en">
                                      Subject type: </xsl:text>
                                     <xsl:value-of select="$mytype"/>
                                  </xsl:if>
                                </xsl:otherwise>
                              </xsl:choose>
                            </b><br/>
                            <!-- <hr/> -->
                            <p/>
                          </xsl:if>
			</xsl:if>

			<xsl:choose>
			    <xsl:when test="subject">
		                <img height="8" width="10"
					src="{$root}/gfx/square.gif"/>
			    </xsl:when>
			    <xsl:otherwise>
		                <img height="8" width="10"
					src="{$root}/gfx/arrow_brown_right.gif"/>
			    </xsl:otherwise>
			</xsl:choose>

			<a href="{$url}"><xsl:value-of select="*/title"/></a>

			<xsl:choose>
			    <xsl:when test="subject">
				<xml:text xml:lang="da"> (emnegruppe)</xml:text>
				<xml:text xml:lang="en"> (category)</xml:text>
			    </xsl:when>
			    <xsl:when test="link"/>
			    <xsl:otherwise>
				<xml:text xml:lang="da"> (lokal resource)</xml:text>
				<xml:text xml:lang="en"> (local resource)</xml:text>
			    </xsl:otherwise>
			</xsl:choose>

			<xsl:if test="$tkl_authenticated">
                            <a href="{$tkl_bin}/xform2.php?xml_file={$tkl_docroot}{$root}/{*/zebra:idzebra/zebra:filename}"
                                onClick="window.open('', 'xform', 'width=800,height=600,screenX=1,screenY=1,top=1,left=1,resizable=y
es,scrollbars=1,scrolling=yes')" target="xform">
                                <img border="0" src="{$root}/gfx/edit.gif"/>
                            </a>
                        </xsl:if>

	                <xsl:variable name="ident">
	                  <xsl:choose>
	                    <xsl:when test="string-length(url) &gt; 50">
		              <xsl:value-of select="substring(url, 1, 50)"/>
		              <xsl:text>...</xsl:text>
	                    </xsl:when>
	                    <xsl:otherwise>
		              <xsl:value-of select="url"/>
	                    </xsl:otherwise>
	                  </xsl:choose>
	                </xsl:variable>

			<xsl:if test="normalize-space(*/identifier)">
			  <br/>
	                  <xsl:choose>
	                    <xsl:when test="string-length($url) &gt; 50">
		              <xsl:value-of select="substring($url, 1, 50)"/>
		              <xsl:text>...</xsl:text>
	                    </xsl:when>
	                    <xsl:otherwise>
		              <xsl:value-of select="$url"/>
	                    </xsl:otherwise>
	                  </xsl:choose>
			</xsl:if>

			<xsl:if test="normalize-space(*/description)">
			    <br/>
			    -<xsl:copy-of select="*/description"/>
			</xsl:if>
			<xsl:if test="normalize-space(*/abstract)">
			    <br/>
			    -<em><xsl:value-of select="*/abstract"/></em>
			</xsl:if>
			<br/><br/>
		    </xsl:for-each>

		    <p/>

		    <xsl:call-template name="previous-next">
		        <xsl:with-param name="search" select="$search"/>
		        <xsl:with-param name="hits" select="$hits"/>
		    </xsl:call-template>

		    <p/>
		</xsl:otherwise>
	    </xsl:choose>
	</xsl:when>

	<!-- No Query -->
	<xsl:otherwise>
	    <p/>
	    <xsl:copy-of select="noterm/node()"/>
	</xsl:otherwise>
    </xsl:choose>
</xsl:template>


<xsl:template name="previous-next">
  <xsl:param name="search"/>
  <xsl:param name="hits"/>
  <xsl:variable name="parms"><xsl:call-template name="make-parms"/></xsl:variable>
		    
  <span xml:lang="en">Displaying records </span>
  <span xml:lang="da">Viser posterne </span>
  <xsl:value-of select="$start"/><xsl:text>-</xsl:text>
  <xsl:choose>
  <xsl:when test="$start + $number - 1 &lt; $hits">
      <xsl:value-of select="$start + $number - 1"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$hits"/>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:variable name="stuff">

    <!-- Make back button -->
    <xsl:if test="$start &gt; 1">
      <xsl:text> --- </xsl:text>
	<!-- Find previous starting point -->
        <xsl:variable name="prevstart">
	    <xsl:choose>
	        <xsl:when test="$start &lt; ($number + 1)">1</xsl:when>
		<xsl:otherwise>
		    <xsl:value-of select="$start - $number"/>
		</xsl:otherwise>
	    </xsl:choose>
	</xsl:variable>

        <a href="{concat(
	    $root, '/search.tkl', '?', $parms,
	    '&amp;start=', $prevstart)}">
	      <span xml:lang="en">Back</span>
	      <span xml:lang="da">Tilbage</span>
          </a>
    </xsl:if>

    <!-- Make forward button -->
    <!-- <xsl:if test="$search/*/server/hits &gt;= $number + $start"> -->
    <xsl:if test="$hits &gt;= $number + $start">
      <xsl:text> --- </xsl:text>
        <a href="{concat(
	    $root, '/search.tkl', '?',
	    $parms,
	    '&amp;start=', $start + $number)}">
	    <span xml:lang="en">More</span>
	    <span xml:lang="da">Flere</span>
        </a>
    </xsl:if>

    <!-- display only title or ressourcetype sorting for local posts -->
    <!--<xsl:if test="$origin and $origin='local'">-->
    <xsl:if test="not($origin = 'web')">
      <xsl:text> --- </xsl:text>
      <xsl:if test="$sort = 'title'">
        <a href="?{$parms}&amp;sort=type">
	  <span xml:lang="da">Sorter efter ressourcetype</span>
	  <span xml:lang="en">Sort by resource type</span>
        </a>      
      </xsl:if>     
      <xsl:if test="$sort = 'type'">
        <a href="?{$parms}&amp;sort=title">
	  <span xml:lang="da">Sorter efter titel</span>
	  <span xml:lang="en">Sort by title</span>
        </a>      
      </xsl:if>
    </xsl:if>
  </xsl:variable>

  <xsl:if test="$stuff">
      <xsl:copy-of select="$stuff"/>
  </xsl:if>
</xsl:template>

<!-- This template produces a CCL query from the form input parameters. It should be easy
     enough to modify if you want to add fields, process elements differently, etc.) -->
<xsl:template name="make-query">
  <xsl:if test="$query"> <!-- free-text -->
    <xsl:value-of select="$query"/>
  </xsl:if>

  <!-- At present, we don't use query and queryN together... if you do so, remember you need an operator here -->

  <xsl:if test="$query1">
    <xsl:value-of select="$field_query1"/>
    <xsl:text>=(</xsl:text>
    <xsl:value-of select="$query1"/>
    <xsl:text>)</xsl:text>
  </xsl:if>
  <xsl:if test="$query2">
    <xsl:if test="$query1">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$op1"/>
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:value-of select="$field_query2"/>
    <xsl:text>=(</xsl:text>
    <xsl:value-of select="$query2"/>
    <xsl:text>)</xsl:text>
  </xsl:if>
  <xsl:if test="$type">
    <xsl:if test="$query1 or $query2">
      <xsl:text> and </xsl:text>
    </xsl:if>
    <xsl:text>type=</xsl:text>
    <xsl:value-of select="$type"/>
  </xsl:if>
</xsl:template>

<!-- This template packs up query parameters for use in links -->
<xsl:template name="make-parms">
  <xsl:text>query=</xsl:text>
  <xsl:value-of select="$query"/>
  <xsl:text>&amp;query1=</xsl:text>
  <xsl:value-of select="$query1"/>
  <xsl:text>&amp;query2=</xsl:text>
  <xsl:value-of select="$query2"/>
  <xsl:text>&amp;field_query1=</xsl:text>
  <xsl:value-of select="$field_query1"/>
  <xsl:text>&amp;field_query2=</xsl:text>
  <xsl:value-of select="$field_query2"/>
  <xsl:text>&amp;type=</xsl:text>
  <xsl:value-of select="$type"/>
  <xsl:text>&amp;op1=</xsl:text>
  <xsl:value-of select="$op1"/>
  <xsl:text>&amp;origin=</xsl:text>
  <xsl:value-of select="$origin"/>
</xsl:template>

</xsl:stylesheet>
