<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: searchform.xsl,v 1.4 2003/09/09 14:31:33 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:output method="html" encoding="UTF-8"/>

<xsl:template match="searchform">
    <xsl:call-template name="main-page"/>
</xsl:template>

<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>


<xsl:template name="main-body">
  <xsl:call-template name="insert-path"/>
  <p/>

  <form method="get" action="{$root}/search.tkl">
    <!-- You can easily add a query3 input field here, just remember to update search.xsl too -->
    <xsl:call-template name="input-field">
      <xsl:with-param name="q" select="'query1'"/>
    </xsl:call-template><p/>
    &#xa0;&#xa0;
    <select name="op1">
      <option value="and">
        <xsl:text xml:lang="en">And</xsl:text><xsl:text xml:lang="da">Og</xsl:text>
      </option>
      <option value="or">
        <xsl:text xml:lang="en">Or</xsl:text><xsl:text xml:lang="da">Eller</xsl:text>
      </option>
      <option value="not">
        <xsl:text xml:lang="en">And-not</xsl:text><xsl:text xml:lang="da">Og-ikke</xsl:text>
      </option>
    </select>
    <p/>
    <xsl:call-template name="input-field">
      <xsl:with-param name="q" select="'query2'"/>
    </xsl:call-template>

    <p/>
    <b xml:lang="da">Begrns efter type</b>
    <b xml:lang="en">Limit by type</b>
    <br/>
    <select name="type">
      <option xml:lang="da" value="">Alle typer</option>
      <option xml:lang="en" value="">All types</option>
      <xsl:for-each select="document('tkl-file://authorities/def-typer.tkl')/*/enum">
        <option value="{@value}"><xsl:value-of select="."/></option>
      </xsl:for-each>
    </select>

    <p/>
    <input type="submit">
      <xsl:attribute xml:lang="da" name="value">Sg!</xsl:attribute>
      <xsl:attribute xml:lang="en" name="value">Search!</xsl:attribute>
    </input>
  </form>
</xsl:template>


<xsl:template name="input-field">
  <xsl:param name="q"/>
  <xsl:variable name="fields" select="document('tkl-file://authorities/advanced-fields.tkl')"/>

  <select name="field_{$q}">
    <xsl:for-each select="$fields/*/enum">
      <option value="{@value}"><xsl:value-of select="."/></option>
    </xsl:for-each>
  </select>
  <input type="text" name="{$q}" style="width: 280px; border: 1px solid #6C5426; font-size:12px;"/>
</xsl:template>

</xsl:stylesheet>
