<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: google.xsl,v 1.3 2003/09/09 14:31:33 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="squery"/>

<xsl:template match="google">
    <xsl:call-template name="main-page"/>
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<xsl:template name="main-body">
    <xsl:call-template name="insert-path"/>
    <p/>
    <em>
    <span xml:lang="en">Note: This is an experimental service only, not part of
       the official demo portal</span>
    <span xml:lang="da">Bemrk: Dette er en eksperimentel service -- det er ikke
       en officiel del af testportalen</span>
    </em>
    <p/>

    <form method="get" action="">
      Indtast sgning:
      <input type="text" name="squery" value="{$squery}" size="30"
         style="border: 1px solid #6C5426; font-size:12px;"/>
      <input type="submit"/>
    </form>

    <xsl:if test="$squery">

    <xsl:variable name="result" select="document(concat(
      'tkl-soap:googleapi.wsdl?',
      'tkl:fun=doGoogleSearch',
      '&amp;', token,
      '&amp;', $squery,
      '&amp;1',
      '&amp;6',
      '&amp;false',
      '&amp;',
      '&amp;false',
      '&amp;',
      '&amp;latin-1',
      '&amp;latin-1'
    ))/*/SOAP-ENV:Body"/>

    <xsl:for-each select="$result/*/*/*/item">
      <p/><img height="8" width="10" src="{$root}/gfx/arrow_brown_right.gif"/>
      <a href="{URL}"><b>
        <xsl:call-template name="amplify">
	   <xsl:with-param name="string" select="title"/>
	</xsl:call-template>
	</b></a>
      <br/><xsl:value-of select="URL"/>
      <br/>
      -<xsl:call-template name="amplify">
         <xsl:with-param name="string" select="snippet"/>
       </xsl:call-template>
    </xsl:for-each>


    </xsl:if>

</xsl:template>




<xsl:template name="amplify">
  <xsl:param name="string"/>
  <xsl:choose>
    <xsl:when test="contains($string, '&lt;')">
      <xsl:value-of select="substring-before($string, '&lt;')"/>
      <xsl:call-template name="amplify">
        <xsl:with-param name="string" select="substring-after($string, '>')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$string"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


</xsl:stylesheet>
