<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: suggestpage.xsl,v 1.3 2003/09/09 14:31:33 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:param name="URL"/>
    <xsl:param name="desc"/>
    <xsl:param name="title"/>
    <xsl:param name="email"/>
    <xsl:param name="name"/>
    <xsl:param name="submit"/>

<xsl:template match="/suggestpage">
    <xsl:call-template name="main-page">
        <xsl:with-param name="title" select="title"/>
    </xsl:call-template>
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<xsl:template name="main-body">
    <xsl:call-template name="insert-path"/>
    <xsl:choose>
        <xsl:when test="$submit">
            <xsl:value-of select="endmessage"/>

            <xsl:variable name="body" select="concat(
    		'Forslag til link. ', $name, ' (mailto:', $email, ') har foreslet foelgende link:&#10;',
    		$URL, '&#10;Titel: ', $title, '&#10;Beskrivelse: ',
    		$desc)"/>

    		<p/>

	    <xsl:variable name="status"
	      select="document(concat('tkl-mail://?',
	        'to=', email,
	        '&amp;subject=', subject,
		'&amp;message=', $body))/tkl-mail"/>

	    <p/>
	    <xsl:choose>
	      <xsl:when test="$status/status = 'OK'">
	      </xsl:when>
	      <xsl:otherwise>
	        ERROR
	      </xsl:otherwise>
	    </xsl:choose>
        </xsl:when>

    	<xsl:otherwise>
    	    <form action="index.tkl" method="get" name="suggest" style="diplay: inline;">
                <table border="0" class="navigation">
                    <tr>
                        <td class="brown"><xsl:value-of select="URLfield"/></td><td class="brown"><input type="text" name="URL" size="51" style="width: 280px; border: 1px solid #6C5426; font-size:12px;" /></td>
                    </tr>
                    <tr>
                        <td class="brown"><xsl:value-of select="titlefield"/></td><td class="brown"><input type="text" name="title" size="50" style="width: 280px; border: 1px solid #6C5426; font-size:12px;"/></td>
                    </tr>
                    <tr>
                        <td class="brown" valign="top"><xsl:value-of select="descriptionfield"/></td><td class="brown"><textarea name="desc" rows="2" cols="51" style="width: 280 px; border: 1px solid #6C5426; font: normal 10px Verdana" class="forminput"></textarea></td>
                    </tr>
                    <tr>
                        <td class="brown"><xsl:value-of select="namefield"/></td><td class="brown"><input type="text" name="name" size="51" style="width: 280px; border: 1px solid #6C5426; font-size:12px;"/></td>
                    </tr>
                    <tr>
                        <td class="brown"><xsl:value-of select="emailfield"/></td><td class="brown"><input type="text" name="email" size="51" style="width: 280px; border: 1px solid #6C5426; font-size:12px;" /></td>
                    </tr>
                    <tr>
                        <td class="brown"></td><td align="right"><input type="submit" value="{submitfield}" name="submit" style="background-color: #ffffff; border: 1px solid #6C5426; font: bold 10px Verdana;" class="brown"/></td>
                    </tr>
                </table>
            </form>
    	</xsl:otherwise>
    </xsl:choose>


</xsl:template>



</xsl:stylesheet>

