#!/usr/bin/perl -w

## $Id: make_trans.pl,v 1.1 2003/08/05 12:07:25 sondberg Exp $

use TKL;
use Data::Dumper;
use strict;

my $trans_dir = "targets/lang";
my $tkl = new TKL();
my $files = $tkl->browse($trans_dir)->{files};
my $translets = {};
my $translets_js = {};
my $output = "lang.php";
my $output_js = "lang.js";
my $header = <<END_OF_HEADER;
<?php

// This is an auto-generated file. Any changes will be over-written!

\$trans_lang = array(
END_OF_HEADER
my $header_js = <<END_OF_HEADER; 

<!-- // /* This is an auto-generated file. Any changes will be over-written! */ -->\n

trans_lang = new Array( );
END_OF_HEADER

my $footer_js = <<END_OF_FOOTER;

END_OF_FOOTER
my $footer = <<END_OF_FOOTER;
);

?>
END_OF_FOOTER

## Extract the whole thing for the php script 
foreach my $file (@$files) {
    next unless $file->get_base =~ /^lang/;
    my $href = $file->parse;
    my $data = $href->{lang}->[0]->{nodeset}->{title};
    my $id = $href->{lang}->[0]->{nodeset}->{code}->[0]->{content};
    foreach (@$data) {
	$translets->{$id}->{$_->{attr}->{'xml:lang'}} = $_->{content};
    }
    
}


## Extract the lang-xxxx.tkl files with js=1
foreach my $file (@$files) {
    my $doc_elem = $file->document_element;
    next unless $doc_elem->nodeName() eq 'lang';
    my $js = $doc_elem->getAttribute('js');
    next unless defined($js) && $js eq '1';
    my $href = $file->parse;
    my $id = $href->{lang}->[0]->{nodeset}->{code}->[0]->{content};
    my $data = $href->{lang}->[0]->{nodeset}->{title};
    foreach (@$data) {
        $translets_js->{$id}->{$_->{attr}->{'xml:lang'}} = $_->{content};
    }
}

## Store php-file
open FH, ">$output" or die "$0: Unable to open '$output' for writing: $!";
print FH $header;
foreach my $id (keys %$translets) {
    print FH "'$id'	=>	array(";
    my $trans = $translets->{$id};
    foreach (keys %$trans) {
	print FH "'$_' => '", $trans->{$_}, "',";
    }
    print FH "),\n";
}
print FH $footer;
close FH;
    

## Store js-file
open FH, ">$output_js" or die "$0: Unable to open '$output_js' for writing: $!";
print FH $header_js;
foreach my $id (keys %$translets_js) {
    print FH "trans_lang['$id'] = {";
    my $trans = $translets_js->{$id};
    foreach (keys %$trans) {
	print FH "$_: '", $trans->{$_}, "',";
    }
    print FH "}\n";
}
print FH $footer_js;
close FH;
