<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: multitarget.xsl,v 1.6 2003/09/09 14:31:33 adam Exp $
-->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:portcom="http://www.indexdata.dk/TKL"
  version="1.0">

  <xsl:import href="tkl-file://interface.xsl"/>
  <xsl:include href="tkl-file://news.xsl"/>
  <xsl:include href="tkl-file:targets.xsl"/>

  <xsl:output method="html" encoding="UTF-8"/>

  <xsl:param name="query"/>
  <xsl:param name="root"/>

  <xsl:param name="tkl_authenticated"/>
  <xsl:variable name="targets_xml" select="document('tkl-targets://?type=all')"/>

  <xsl:template match="multitarget">
    <xsl:call-template name="main-page"/>
  </xsl:template>
  
  <xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
  </xsl:template>

  <xsl:template name="main-body">
    <xsl:call-template name="insert-path"/>
    <table width="100%">
      <xsl:call-template name="search-form"/>
    </table>
  </xsl:template>

  <xsl:template name="search-form">
    <form method="GET" action="{$root}/targets/search/search.html" target="_top">
      <input type="text" name="query" value="{$query}" style="border: 1px solid #3a6072; width: 156px; vertical-align: middle;" />
      <input type="image" style="vertical-align: middle;" src="{$root}/gfx/button_search.gif" />
      <xsl:call-template name="targets-menu"/>
    </form>
  </xsl:template>

</xsl:stylesheet>
