<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: search.php,v 1.13 2003/09/15 13:50:51 anders Exp $
*/

require 'util.phpi';      // Utility file
set_lang();

header("Content-Type: text/html; charset=utf-8");

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" type="text/css" href="../css/record_handler.css"></link>
<title>Im Mr. Search</title>
</head>
<body>
<?php

//include 'targets.php';
//require 'config.phpi';
//require 'tkl_tools.php';
//include 'globals.phpi';
//require 'yaz_util.php';
//require 'record.php';

require 'targets.php';
require 'config.phpi';
require 'tkl_tools.php';
require 'globals.phpi';
require 'yaz_util.php';
require 'record.php';

// Set default values
$number = $_GET["number"]; 
$start = $_GET["start"];
$host = $_GET["host"];
$sort = $_GET["sort"];
$query = stripslashes($_GET["query"]);

// Set default values
if (!$number) $number = $default_hits;

if (!$start) $start = 1;
if (!$format) $format = "full";
if (!$host) $host = array();

$num_hosts = count($host);
$hits = array();
$pos = array();
$view_pos = array();
$host_done = 0;

echo '<script language="JavaScript">parent.progressBarInit();';
echo 'var default_number = '.$number.'</script>';


// Do it
$yopt = array();
$yopt['proxy'] = $z_proxy;
$yopt['persistent'] = FALSE;

$pos = array();

foreach ($host as $h) {
    $info = $targets[$h];
    $id[$h] = yaz_connect($info['identifier'],$yopt);
    $pos[$h] = 0;
    $hits[$h] = -1;
    if($id[$h]){
	tkl_prepare($id[$h], $info, $query);
    } else
	print "Failed to create endpoint for $h (" . $info['identifier'] . ")<br />\n";
    
}

$opt["timeout"] = $z_search_timeout;
$opt["event"] = TRUE;
$res = yaz_wait($opt);

while ($res) {
    $tmp_h = 0;
    foreach ($host as $h) {
	if ($id[$h] == $res) {
	    $tmp_h = $h;
	    break;
	}
    }
    $info = $targets[$tmp_h];
    if ($opt["eventcode"] <= 7){
	switch ($opt["eventcode"]) {        			
	case 4:
	    $host_done++;
	    $procent = round($host_done/count($host)*100);
	    print "<script language=\"JavaScript\">parent.updateHostStatus(\"".$info['nick']."\",\"error\",\"<p>Error: Timeout</p>\")</script>";
	    print "<script language=\"JavaScript\">parent.updateHostHits(\"".$info['nick']."\",\"-\");</script>";
	    print "<script language=\"JavaScript\">parent.updateProcent(\"".$num_hosts."\",".$procent.");</script>";
	    
	    flush();
	    break;
	case 5:
	    $host_done++;
	    $procent = round($host_done/count($host)*100);
	    print "<script language=\"JavaScript\">parent.updateHostStatus(\"".$info['nick']."\",\"error\",\"<p>Error: ".$error."</p>\")</script>";
	    print "<script language=\"JavaScript\">parent.updateHostHits(\"".$info['nick']."\",\"-\");</script>";
	    print "<script language=\"JavaScript\">parent.updateProcent(\"".$num_hosts."\",".$procent.");</script>";
	    flush();
	    break;				
	}
	
	$res = yaz_wait($opt);
	continue;	
    }
    if ($opt["eventcode"] == 9) {
	$host_done++;
	$procent = round($host_done/count($host)*100);
	
	if (($error = yaz_error($id[$tmp_h]))){
	    //print "DB ".$h." : Error<br />\n";
	    print "<script language=\"JavaScript\">parent.updateHostStatus(\"".$info['nick']."\",\"error\",\"<p>Error: ".$error."</p>\")</script>";
	    print "<script language=\"JavaScript\">parent.updateHostHits(\"".$info['nick']."\",\"-\");</script>";
	    print "<script language=\"JavaScript\">parent.updateProcent(\"".$num_hosts."\",".$procent.");</script>";
	} else {
		echo "HITS: " . yaz_hits($id[$tmp_h]);
	    $hits[$info['nick']] = yaz_hits($id[$tmp_h]);
	    print "<script language=\"JavaScript\">parent.updateHostStatus(\"".$info['nick']."\",\"done\",\"\")</script>";
	    print "<script language=\"JavaScript\">parent.updateHostHits(\"".$info['nick']."\",\"".$hits[$info['nick']]."\");</script>";
	    print "<script language=\"JavaScript\">parent.updateProcent(\"".$num_hosts."\",".$procent.");</script>";
	    
	    yaz_close($id[$tmp_h]);
	    $id[$tmp_h] = 0;
	    if($show_control != 1){
		print "<script language=\"JavaScript\">parent.showRecord(\"".$info['nick']."\",\"".$info['title']."\",\"".addslashes(utf8_encode($query))."\");</script>";
		$show_control = 1;
	    }
	}
	flush();
	$res = yaz_wait($opt);
	continue;
    }
    
    $pos[$h]++;  
    $p = $pos[$h];
    
    
    if($p >= 10 || $p >= $hits[$info['nick']]){
	
    }
    
    flush();
    $res = yaz_wait($opt);
}


foreach ($host as $h) {
    $info = $targets[$h];
    if (is_resource($id[$h])) {
	if (($error = yaz_error($id[$h]))){
	    print "<script language=\"JavaScript\">parent.updateHostStatus(\"".$info['nick']."\",\"error\",\"<p>Error: ".$error."</p>\")</script>";
	    print "<script language=\"JavaScript\">parent.updateHostHits(\"".$info['nick']."\",\"-\");</script>";
	    print "<div class=\"error\" id=\"error_".$info['nick']."\"><p>Error: $error</p></div>";
	}
    }
}
print "<script language=\"JavaScript\">parent.updateProcent(\"".$num_hosts."\",100);</script>";		

?>

</body>
</html>
