<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: search_record.php,v 1.17 2003/09/10 10:38:58 anders Exp $
*/

require 'util.phpi';      // Utility file
set_lang();

//include 'targets_sql.php';    // Definitions of Z39.50 targets using sql.
include 'targets.php';    // Definitions of Z39.50 targets using sql.
require 'config.phpi';
require 'tkl_tools.php';
require 'globals.phpi';
require 'yaz_util.php';
require 'record.php';
require '../lang/lang.php';      // Text strings in the supported languages

// Set default values
$number = $_GET["number"]; 
$start = $_GET["start"];
$host = $_GET["host"];
$sort = $_GET["sort"];
$query = stripslashes($_GET["query"]);

if (!$number) $number = $default_hits;
//$number = $default_hits;
if (!$start || $start <= 0) $start = 1;		
if (!is_array($host)) $host = array();

$num_hosts = count($host);
$hits = array();
$pos = array();
$view_pos = array();
$sort_array = array();
$host_done = 0;

$myurl = $_SERVER["PHP_SELF"];
$myurl .= "?host[]=".$host[0]."&query=" . urlencode($query);

function  print_record($h,$p) {	
    global $id,$host,$res,$query,$start;
    
    $res = yaz_srecord($id[$h],$p,"structure");
    
    $record = new MARC_record($res);
    
    $titl = $record->felements('/245/*/a');
    $auth = $record->felements('/100/*/h');
    $descr = $record->felements('/504/*/a');
    $date = $record->felements('/260/*/c');
    //$isbn= $record->felements('/021/*/a');
   
    if(!strlen($titl)) $titl = "Igen title";
   
    print "<tr><td style=\"width: 24px;\">";
    print "<img src=\"../gfx/icon_txt.gif\" style=\"vertical-align: middle; border: 0px;\" width=\"16\" height=\"16\" alt=\"MD\" /></td>";
    print "<td style=\"width: 5px;\">&nbsp;</td><td style=\"width: 330px;\"><a href=\"../php/full.php?host[]=".$host[0]."&query=" . urlencode($query) . "&number=1&start=".$p."\" TARGET=\"framedata\" class=\"item\">$titl&nbsp;-&nbsp;$date</a>";
    print "</td></tr>\n";
}

function add_to_sort($h,$p){
    global $sort_array, $id,$host,$res;
    
    $res = yaz_srecord($id[$h],$p,"structure");
    
    $record = new MARC_record($res);
    
    $titl = $record->felements('/245/*/a');
    $date = $record->felements('/260/*/c');
    
    $sort_array[$p] = array('titl' => $titl,'date' => $date);
    
}

function cmp_titl ($a, $b)
{
    return strcasecmp($a["titl"], $b["titl"]);
}
function cmp_date ($a, $b)
{
    return strcasecmp($a["date"], $b["date"]);
}
function sort_record(){
    global $sort, $sort_array;
    
    if($sort == "title") uasort($sort_array, "cmp_titl");
    elseif ($sort == "date") uasort($sort_array, "cmp_date");
    
    while (list ($key, $value) = each ($sort_array)) {
	//echo "\$sort_array[$key]: " . $value["titl"] . "\n";
	print_record(0,$key);
    }
}

header("Content-Type: text/html; charset=utf-8");

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link href="../css/styles.css" rel="stylesheet" type="text/css" media="screen, all" />
<link rel="stylesheet" type="text/css" href="../css/record_handler.css"></link>
<script language="javascript" src="../js/frame_call.js"></script>
<title>Im Mr. data, for your service</title>
</head>
<body onload="interFrameCall('top.framegui','incoming(\'<?php echo $host[0]; ?>\')');">
<?php
print "<div class=\"record\" id=\"record\" start=\"".$start."\" number=\"".$number."\">\n<p>";
// Do it
$pos = array();

$yopt = array();
$yopt['proxy'] = $z_proxy;
//$yopt['charset'] = 'UTF-8';

$i = 0;
foreach ($host as $h) {
    $info = $targets[$h];
    $id[$i] = yaz_connect($info['identifier'],$yopt);
    $pos[$i] = 0;
    $hits[$i] = -1;
    if($id[$i]){
	tkl_prepare($id[$i], $info, $query);
    } else
	echo "Error: Failed to create endpoint for $h (" . $thistarget['identifier'] . ")";
    
    $i++;
}


		
$opt["timeout"] = $z_record_timeout;
$res = yaz_wait($opt);
$error = yaz_error($id[0]);
$hits = yaz_hits($id[0]);

// headline 
echo "<a href=\"#\" class=\"big\">". $targets[$host[0]]["title"] ."</a>";
echo "<br /><br />Results ";
if($hits > 0) {
    if(($number+$start-1) > $hits)
	$show_num = $hits;
    else
	$show_num = ($start+$number-1);
    echo "$start - $show_num of $hits";
    if (0)
    if($hits <= $record_sort_max){
	echo "</b>&nbsp;&nbsp;&nbsp;&nbsp;Load all records from server and sort by ";
	echo '<a href="'.$myurl.'&number='.$hits.'&start=1&sort=title" TARGET="framedata">Title</a>,&nbsp;';
	echo '<a href="'.$myurl.'&number='.$hits.'&start=1&sort=date" TARGET="framedata">Date</a>';
    }

}
echo "<br /><br />";

if($hits == 0){
echo "&nbsp;&nbsp;No Hits";
}


// records
echo '<table cellpadding="3" cellspacing="0" border="0">';
if (!empty($error)) {
    echo "Error: $error";
} else if($sort) {
    for ($p = $start; $p <= ($number+$start-1); $p++)
    {
	if($p <= $hits) add_to_sort(0,$p);
    }
    sort_record();
} else {
    for ($p = $start; $p <= ($number+$start-1); $p++)
    {
	if($p <= $hits) $rec = print_record(0,$p);
    }
}
echo '</table><br />';

// browsing
if($hits > ($number+$start-1)) {
    if($start > 1){
	// back..
	$prev = $start - $number;
	if ($prev < 1) $prev = 1;
	echo '<img src="../gfx/arrow_orange_left.gif" style="vertical-align: middle; border: 0px;" width="11" height="11" alt="'.trans_text(5).'">&nbsp;&nbsp;<a href="'.$myurl.'&start='.$prev.'" TARGET="framedata">'.trans_text(5).'</a>   |   ';
    }
    // next page  url+start=($number+$start)
    echo ' <a href="'.$myurl.'&number='.$number.'&start='.($number+$start).'" TARGET="framedata">'.trans_text(4).'</a>&nbsp;&nbsp;';
    echo '<img src="../gfx/arrow_orange_right.gif" style="vertical-align: middle; border: 0px;" width="11" height="11" alt="'.trans_text(4).'">';
} else if ($start >= $number) {
    //back only..
    echo '<img src="../gfx/arrow_orange_left.gif" style="vertical-align: middle; border: 0px;" width="11" height="11" alt="'.trans_text(5).'">&nbsp;&nbsp;<a href="'.$myurl.'&number='.$number.'&start='.($start-$number).'" TARGET="framedata">'.trans_text(5).'</a>';
}

?>
</div>
    </body>
</html>

