<?php

// Copyright (c) 2002-2003, Index Data.
// $Id: targets.php,v 1.5 2003/08/21 09:27:00 sondberg Exp $

// Escape invalid &
function fix_amp ($str) {
    if (!preg_match("/&/", $str)) {
	return $str;
    }
    
    $fields = preg_split("/&/", $str);
    $ret = array_shift($fields);
    foreach ($fields as $f) {
	if (preg_match("/^#[0-9]{1,7};/", $f)) {	// Identify entity
	    $ret .= "&$f";
	} else {
	    $ret .= "&amp;$f";				// Otherwise escape ampersand...
	}
    }
    return $ret;
}


// Make some raw xml from a nested array
function make_xml($ar, $level) {
    $xml_indent = "  ";
    foreach ($ar as $key => $value) {
	$elem = $key;
	if (is_numeric($elem)) {
	    $elem = "item";
	}
	if (is_array($value)) {
	    $ret .= str_repeat($xml_indent, $level) . "<$elem>\n";
	    $ret .= make_xml($value, $level + 1);
	    $ret .= str_repeat($xml_indent, $level) . "</$elem>\n";
	} else {
	    $ret .= str_repeat($xml_indent, $level) . "<$elem>" . fix_amp($value) . "</$elem>\n";
	}
    }
    return $ret;
}


// Run through target description files and update list $targets by ref.
function make_targets (&$targets) {
    global $root;
    $target_dir = $_SERVER['DOCUMENT_ROOT'] . "/$root/targets";

    if (!($dh = opendir($target_dir))) {
	die("<b>Fatal:</b> Unable to open '$target_dir'");
    }
    while (strlen($entry = readdir($dh))) {
	if (!preg_match("/^target-.*\.tkl$/", $entry)) {
	    continue;
	}
	// Parse the target info tkl file and put it into a hash...
	parse_target_file("$target_dir/$entry", $target = array());
	// Get the cclmap tkl file...
	$zprofile = $target_dir . "/profiles/" . $target['cclmap'];
	// Parse it..
	parse_target_file($zprofile, $cclmap = array());
	// And store it into the target hash
	$target['cclfield'] = $cclmap['cclfield'];
	$targets[$target['nick']] = $target;
    }
    if (0) {
	echo "<pre>";
	print_r($targets);
	echo "</pre>";
    }
}


// Open one target file and update target_info by ref.
function parse_target_file ($tkl_file, &$target_info) {
    if (!($dom = domxml_open_file($tkl_file))) {
	echo "<b>Warning:</b> Unable to parse target file '$tkl_file'<br/>";
	return;
    }
    $doc_elem = $dom->document_element();
    parse_target($doc_elem, $target_info);
}


// Browse through dom tree and put values into the $hash
function parse_target ($node, &$hash) {
    global $lang;
    $cdata = "";
    if (is_array($children = $node->child_nodes())) {
	foreach ($children as $subnode) {
	    $type = $subnode->node_type();
	    if ($type == XML_TEXT_NODE) {
		$cdata .= $subnode->content;
	    } elseif ($type == XML_ELEMENT_NODE) {
		if (strlen($this_lang = $subnode->get_attribute('lang')) && $this_lang != $lang) {
		    continue;
		}
		$name = $subnode->tagname;
		unset($subtree);
		$ret = parse_target($subnode, $subtree);
		if (is_array($subtree)) {
		    $hash[$name][] = $subtree;
		} else {
		    $hash[$name] = $ret;
		}
	    }
	}
    }
    return trim($cdata);
}


?>
