<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: yaz_util.php,v 1.7 2003/09/09 14:31:34 adam Exp $
*/

function yaz_array2struct(&$array, &$i, $parentt='') {
    $res = array();

    if (!$parentt) {
	reset($array);
    }
    $count = count($array);
    while ($i < $count) {
        $elem = $array[$i];
	$i++;

	preg_match('/(.*)(\([^)]*\))$/', $elem[0], $match);

	if ($parentt != $match[1] || $parentt == $elem[0]) {    // out of recursion
	    $i--;
	    return $res;
	}

	$resn = array('tag' => $match[2]);
	$subfields = array();
	if ($elem[1]) {
	    if (preg_match_all("/\037(.)([^\037]*)/", $elem[1], $subfields,
		PREG_SET_ORDER)) {
		$subres = array();
	        foreach ($subfields as $subf) {
		    $subres[] = array(
		        'tag' => ("(3," . $subf[1] . ")"),
			'data' => $subf[2]);
		}
		$resn[data] = $subres;
	    } else
		$resn[data] = $elem[1];
	} else {
	    $r = yaz_array2struct($array, $i, $elem[0]);
	    $resn[data] = $r;
	}

	$res[] = $resn;
    }
    return $res;
}

function yaz_srecord($id, $pos, $type) {
    if ($type == 'structure') {
    	if (!($r = yaz_record($id, $pos, 'array'))) {
    	    return $r;
    	}
            $i = 0;
    	$res = yaz_array2struct($r, $i);
    	return $res;
    } else {
	    return yaz_record($id, $pos, $type);
    }
}


function yaz_prepare(&$conn_list, $query, $type) {
	global $focus, $targets, $records_page, $start, $ccl_conf, $action, $debug, $target_group;

	reset($conn_list);
	while (list($target) = each($conn_list)) {	// And here we go, lets perform the search
		$targets[$target]['error'] = '';
		$info = $targets[$target];
		if (!$start) {
			$start = 1;
		}
		$options = array();
		if ($info['account']) {
			$options = $info['account'];
			if ($debug)
				echo "DEBUG acct($target) is " . $info['account'] . "<br>";
		}
		$id = yaz_connect($conn_list[$target]['identifier'], $options);
		$conn_list[$target]['conn'] = $id;
		yaz_syntax($id, $info['syntax']);
		if (strlen($info['elementset'])) {
			yaz_element($id, $info['elementset']);
		} else {
			yaz_element($id, "");
		}
		//
		// Commented out as part of hack to disable piggy-backing
		// Anders changed it into if/then/else
		//
		if ($action == 'scan') {
			if (empty($focus) || $focus == $target) {
				yaz_range($id, $start, $records_page);
			} else {
				yaz_range($id, 1, 0);
			}
		} else {
			yaz_range($id, 1, 0);
		}
		if ($info['ccl_conf']) {
			$cc = $info['ccl_conf'];
		} else {
			$cc = $ccl_conf;
		}
		yaz_ccl_conf($id, $cc);
		$query = stripslashes($query);
		if (yaz_ccl_parse($id, $query, &$cclres)) {
			$mquery = $cclres['rpn'];
			if ($info['rpn_prefix'] && $type != 'scan') {
				$mquery = $info['rpn_prefix'] . ' ' .  $mquery;
			}
			if ($info['rpn_suffix'] && $type != 'scan') {
				$mquery .= ' ' . $info['rpn_suffix'];
			}
			if ($debug) {
				echo "DEBUG (", get_target_name($target), "): RPN query = '$mquery'<BR>";
			}
			if ($info['search_prefix']) {
				$mquery = $info['search_prefix'] . " $mquery";
			}
			if ($info['ccl_attset']) {
				$mquery = "@attrset " . $info['ccl_attset'] . ' ' . $mquery;
			}
			if ($type == 'scan') {
				if ($info['scan'] == 'disable') {
					$targets[$target]['error'] .= m('Scan er ikke tilladt for') . ' ' . get_target_name($target) . '<BR>';
				} else {
					yaz_scan($id, 'rpn', $mquery);
				}
			} else {
				yaz_search($id, 'rpn', $mquery);
			}
		} else {
			echo "<BR>CCL error<BR>";
			return 0;
		}
	}

	return 1;
}


function yaz_push(&$conn_list, $group) {
	global $targets, $target_group;

	while(list(, $target) = each($target_group[$group]['primary-search'])) {
		$conn_list[$target]['identifier'] = $targets[$target]['identifer'];
	}
}


function tkl_prepare($id, $info, $query) {
    yaz_syntax($id,$info['syntax']);
    
    $latin_query = utf8_decode($query);
    
    if (0) {
	echo "<pre>";
	print_r($info);
	echo "</pre>";
    }
    if (strlen($info['elementset'])) {
	yaz_element($id, $info['elementset']);
    }
    
    $ccl_conf = array();
    
    if (is_array($info['cclfield'])) {
	foreach ($info['cclfield'] as $map) {
	    $ccl_conf[$map['field']] = $map['map'];
	}
    }
    if (0) {
	echo "<pre>";
	print_r($ccl_conf);
	echo "</pre>";
    }
    
    yaz_ccl_conf($id, $ccl_conf);
    
    if (!yaz_ccl_parse($id,$latin_query,&$cclresult)) {
	die ("CCL error!<br/>");
    } else {
	$mquery = $cclresult["rpn"];
	yaz_search($id,"rpn",$mquery);
    }
}




function get_scan_results($id, $focus) {
	global $context, $query, $old_targets, $selected_targets, $scan_map;

	$old_targets = $selected_targets;
	$selected_targets = array($focus);
	$old_query = $query;
	$search_field = '';
	foreach ($query as $field => $value) {
		if (!empty($value)) {
			$search_field = $scan_map[$field];
		}
	}
	if (empty($search_field)) {
		echo "<B>No scan fields specified</B>";
		die;
	}
	$query = array();
	$search_field = 'query[' . $search_field . ']';
	$tagset = '';
	$errno = yaz_errno($id);
        if ($errno == 0) {
                $ar = yaz_scan_result($id, &$options);
                while (list($key, list($k, $term, $tcount)) = each($ar)) {
                        if (empty($k)) continue;
			if ($focus == 'sol') {
				$term = preg_replace('/^_\S+\s?/', '', $term);
			}
                        echo HTML_anchorParms('output.php', $term, $context, array('action' => 'search', $search_field => $term), 'output');
                        echo '<BR>';
                }
        } else {
                echo "Scan failed. Error: " . yaz_error($id) . "<br>";
        }
	$query = $old_query;				// Restore old globals
	$selected_targets = $old_targets;

        return $tagset;
}


//$Log: yaz_util.php,v $
//Revision 1.7  2003/09/09 14:31:34  adam
//GPL headers
//
//Revision 1.6  2003/09/02 10:12:52  anders
//Added utf8_decode to query befor calling yaz.
//Fixed lang bug!
//
//Revision 1.5  2003/08/21 12:20:01  sondberg
//Removed some debugging.
//
//Revision 1.4  2003/08/21 12:08:32  sondberg
//Z-target files are parsed and processed separately.
//
//Revision 1.3  2003/08/21 09:27:00  sondberg
//Element set is included in target profile.
//
//Revision 1.2  2003/08/04 07:46:07  sondberg
//Substantial work.
//
//Revision 1.1  2003/08/01 10:05:02  sondberg
//Added these files.
//
//Revision 1.2  2003/07/16 13:28:30  perhans
//Added the config file and a MARC display file
//
//Revision 1.1  2003/07/09 11:52:07  anders
//Added this file
//
//Revision 1.2  2003/07/08 10:12:06  anders
//fixed some bugs!
//
//Revision 1.2  2002/03/03 16:23:35  quinn
//i
//
//Revision 1.1.1.1  2001/08/27 12:16:56  quinn
//New
//
//Revision 1.14  2001/08/12 09:24:19  sondberg
//Added correct authentication for DBC access.
//
//Revision 1.13  2001/08/08 14:41:12  sondberg
//Added extra targets according to the value of bib1 USE 56.
//
//Revision 1.12  2001/08/08 12:01:52  sondberg
//Following scan generated links now executes search on one target only.
//
//Revision 1.11  2001/08/02 09:29:14  sondberg
//Modified hack to prevent piggy-back.
//
//Revision 1.10  2001/08/01 21:23:42  quinn
//Hack to disable piggybacking
//
//Revision 1.9  2001/07/20 06:15:51  sondberg
//Added $base_q, and implemented extra navigation facilities between
//searching and scanning results.
//
//Revision 1.8  2001/07/20 04:01:54  sondberg
//yaz_prepare starts scanning on 'scan' otherwise it searches.
//
//Revision 1.7  2001/07/19 12:35:10  sondberg
//Error reporting distributed over each target.
//
//Revision 1.6  2001/07/19 10:17:11  sondberg
//*** empty log message ***
//
//Revision 1.5  2001/07/05 13:57:01  sondberg
//Added some debugging messages.
//
//Revision 1.4  2001/07/05 12:54:16  sondberg
//Small changes into get_scan_results.
//
//Revision 1.3  2001/07/05 09:02:39  sondberg
//yaz_prepare now takes a third argument telling it whether to search or scan.
//
//Revision 1.2  2001/07/03 13:42:05  sondberg
//Added function for generating scan results (get_scan_result)
//

?>
