<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: targetinfo.xsl,v 1.5 2003/09/09 14:31:33 adam Exp $
-->
<!-- $Id: targetinfo.xsl,v 1.5 2003/09/09 14:31:33 adam Exp $ -->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:portcom="http://www.indexdata.dk/TKL"
  version="1.0">
  
  <xsl:import href="tkl-file://interface.xsl"/>
  <xsl:include href="tkl-file://news.xsl"/>

  <xsl:output method="html" encoding="UTF-8"/>
  
  <xsl:param name="tkl_authenticated"/>
  <xsl:variable name="targets_xml" select="document('tkl-targets://?type=selected')"/>
    
  <xsl:template match="targetinfo">
    <xsl:call-template name="main-page"/>
  </xsl:template>
  
  <xsl:template name="main-body">
    <table width="100%">
      <tr>                          
	<td style="vertical-align: top; text-align: left;">
	  <table width="100%">
	    <tr>
	      <td width="40%">&#xa0;</td>
	      <td width="60%">&#xa0;</td>
	    </tr>
	    <tr>
	      <td colspan="2">
	        <span class="big" style="font-size: 14px;">Target info</span>
	      </td>
	    </tr>
	    <tr>
	      <td>&#xa0;</td>
	    </tr>
	    <xsl:for-each select="$targets_xml/*/target">
	      <xsl:call-template name="insert-target">
	        <xsl:with-param name="info" select="."/>
	      </xsl:call-template>
	    </xsl:for-each>
	  </table>
	</td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="insert-target">
    <xsl:param name="info"/>
    <tr>
      <td valign="top">
        <b>
	  <span xml:lang="da">Target navn</span>
	  <span xml:lang="en">Target name</span>
	</b>
      </td>
      <td><xsl:value-of select="$info/title"/></td>
    </tr>
    <tr>
      <td colspan="2">&#xa0;</td>
    </tr>
    <tr>
      <td valign="top">
        <b>
	  <span xml:lang="da">Target beskrivelse</span>
	  <span xml:lang="en">Target description</span>
	</b>
      </td>
      <td><xsl:copy-of select="$info/desc"/></td>
    </tr>
    <tr>
      <td colspan="2">&#xa0;</td>
    </tr>
    <!-- We don't wanna show the more technical details about the targets... 
    <tr>
      <td valign="top">
        <b>
	  <span xml:lang="da">Adresse</span>
	  <span xml:lang="en">Address</span>
	</b>
      </td>
      <td><xsl:value-of select="$info/identifier"/></td>
    </tr>
    <tr>
      <td colspan="2">&#xa0;</td>
    </tr>
    <tr>
      <td valign="top">
        <b>
	  <span xml:lang="da">Foretrukken postsyntaks</span>
	  <span xml:lang="en">Preferred record syntax</span>
	</b>
      </td>
      <td><xsl:value-of select="$info/syntax"/></td>
    </tr>
    <tr>
      <td colspan="2">&#xa0;</td>
    </tr>
    <tr>
      <td valign="top">
        <b>
	  <span xml:lang="da">CCL felter</span>
	  <span xml:lang="en">CCL fields</span>
	</b>
      </td>
      <td valign="top">
        <xsl:call-template name="insert-ccl-fields">
	  <xsl:with-param name="info" select="$info"/>
	</xsl:call-template>
      </td>
    </tr>
    -->
  </xsl:template>

  <xsl:template name="insert-ccl-fields">
    <xsl:param name="info"/>
    <xsl:for-each select="$info/cclfield/item">
      <b><xsl:value-of select="field"/></b> ~ <xsl:value-of select="map"/><br/>
    </xsl:for-each>
  </xsl:template>
  
  
  <xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
  </xsl:template>

</xsl:stylesheet>

