<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: targets.xsl,v 1.3 2003/09/09 14:31:33 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">

  <xsl:output method="html" encoding="UTF-8"/>

  <xsl:template name="target-entry">
    <xsl:param name="entry"/>
    <tr>
      <td>
	<xsl:choose>
	  <xsl:when test="$entry/strength &gt; 3">
	    <input type="checkbox" name="host[]" value="{@id}" checked="1"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <input type="checkbox" name="host[]" value="{@id}"/>
	  </xsl:otherwise>
	</xsl:choose>
	<a href="{$root}/targets/targetinfo.tkl?host[]={$entry/nick}" >
	  <xsl:value-of select="$entry/title"/>
	</a>
      </td>
    </tr>
  </xsl:template>
  
  <xsl:template name="targets-menu">
    <tr>
      <td valign="top">
	  <xsl:variable name="mylist" select="$targets_xml/targets/target"/>
	  <xsl:if test="not($mylist)">
	    <tr><td>(No libraries)</td></tr>
	  </xsl:if>
	  <xsl:for-each select="$mylist">
	    <xsl:sort select="title"/>
	    <xsl:call-template name="target-entry">
	      <xsl:with-param name="entry" select="."/>
	    </xsl:call-template>
	  </xsl:for-each>
      </td>
      
    </tr>
  </xsl:template>

</xsl:stylesheet>
