/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: upload_handler.php,v 1.7 2003/09/24 09:17:02 sondberg Exp $
*/

// Handler for uploading of various mime-types
//
// Anders Snderberg Mortensen
// Indexdata
//
// This handler is called with an argument hash $args, with the following members:
//
// For all type of actions:
// $args['action']:		upload/delete/commit/cleanup - type of action required
// $args['portal_abs_dir']:	Current working directory relative to the portal root
// $args['portal_root']:	Portal root relative to Apache's DocumentRoot
// $args['tkl_doc']:		Filename of tkl-document (not qualified with path)
// $args['sid']:		Session ID
//
// For action=upload:
// $args['mimetype']:		The mime-type of the uploaded object
// $args['filename']:		Client-side filename of uploaded object
// $args['tmp']:		Server-side temporary filename (typically /tmp/xxxxxx)
// $args['size']:		Size of uploaded object in bytes
// $args['domain']:		The domain name of the web-service
// $args['content']:		XML content of the upload part of the tkl document
//
// For action=delete:
// $args['content']:		XML content of the upload part of the tkl document
//
// For action=commit:
// No extra members
//
// For action=delete:
// No extra members

global $debug, $supported_mimes, $return_header, $mime;


// Here goes the supported mime-types. The catagories are:
// picture: Something we want to make a thumbnail representation of
// archive: Compressed/packaged objects
// other: Other stuff we can't do anything intelligent with
//
// Adding new mime-types are free as long as the existing mime
// categories are sufficient. Adding new categories must be
// accompanied with a handler.

$supported_mimes = array(	'image/gif'			=> 'picture',
				'image/tiff'			=> 'picture',
				'image/jpeg'			=> 'picture',
				'image/bmp'			=> 'picture',
				'image/png'			=> 'picture',
				'image/pjpeg'			=> 'picture',
				'application/x-gzip'		=> 'archive',
				'application/zip'		=> 'archive',
				'text/html'			=> 'other',
				'text/plain'			=> 'other',
				'audio/mpeg'			=> 'other',
				'application/msword'		=> 'other',
				'application/pdf'		=> 'other',
				'application/postscript'	=> 'other',
				'application/octet-stream'	=> 'other',
			);


if (!function_exists('exec_upload')) {
    function exec_upload ($args) {

	global $debug, $supported_mimes, $mime;
	
	if (!function_exists('upload_picture_handler')) {
	    
	    function upload_picture_handler ($args) {	// Handle uploading of picture
		$sid = $args['sid'];
		$image_magic = "/usr/bin/convert";	// External software to manipulate pictures
		$xml = "<upload";
		if (is_executable($image_magic)) {
		    $filename_escaped = preg_replace("/ /", "\ ", $args['filename']);
		    $filename_pre = preg_replace("/\..*?$/", "", $filename_escaped);
		    $thumbnail = trim_filename($args['dest_dir_rel'] . "/$sid-" . $filename_pre . "-thumb.jpg");
		    $thumbnail_abs = $_SERVER['DOCUMENT_ROOT'] . "/" . $thumbnail;
		    $cmd = "$image_magic " . $args['dest_dir'] . "/$sid-" . $filename_escaped . " -geometry \"120x90\" -quality 75 " . $thumbnail_abs;
		    passthru($cmd);
		    $xml .= " preview=\"$thumbnail\"";

		    $webform = trim_filename($args['dest_dir_rel'] . "/$sid-" . $filename_pre . "-web.jpg");
		    $webform_abs = $_SERVER['DOCUMENT_ROOT'] . "/" . $webform;
		    $cmd = "$image_magic " . $args['dest_dir'] . "/$sid-" . $filename_escaped . " -geometry \"400x600\" -quality 75 " . $webform_abs;
		    passthru($cmd);
		} else {
		    echo "<b>Warning:</b> Unable to call ImageMagic: '$image_magic'. Can't generate thumbnail";
		}
		$xml .= ">\n";
		$xml .= "  <object>" . trim_filename($args['dest_dir_rel'] . "/$sid-" . $args['filename']) . "</object>\n";
		$xml .= "  <object scale=\"web\">" . $webform . "</object>\n";
		$xml .= "  <size>" . $args['size'] . "</size>\n";
		$xml .= "  <mimetype>" . $args['mimetype'] . "</mimetype>\n";
		$xml .= "</upload>\n";
		return $xml;
	    }
	}
	
	
	if (!function_exists('upload_archive_handler')) {
	    
	    function upload_archive_handler ($args) {		// Handle uploading of archives, i.e. zip, tar.gz etc.
	        $ret = "<upload>\n";
	        $sid = $args['sid'];
		$archive = "$sid-" . $args['filename'];
		$dest_dir_rel = $args['dest_dir_rel'];
		$dest_sub_dir = "/DIR-$archive";
		$dest_dir = $args['dest_dir'] . $dest_sub_dir;
		$dest_dir_rel = trim_filename($args['dest_dir_rel'] . $dest_sub_dir);
		if (is_dir($args['dest_dir'] . "/DIR-" . $args['filename'])) {	// Check if archive already exists...
		    passthru("rm -f " . $args['dest_dir'] . "/$archive");
		    return "<upload><error>Archive already uploaded</error></upload>";
		}
		if (!mkdir($dest_dir, 0755)) {
		    die("<b>Fatal:</b> Unable to create storage room for uploaded archive: '$dest_dir'");
		}
		$move_cmd = "mv " . $args['dest_dir'] . "/$archive $dest_dir/$archive"; 
		system($move_cmd);
		$mimetype = strtolower($args['mimetype']);
		if ($mimetype == 'application/x-gzip') {	// Take care of tar-balls
		    $untar = '/bin/tar';
		    if (is_executable($untar)) {
			system("cd $dest_dir; $untar xfz $archive > /dev/null");
		    } else {
			die("<b>Fatal:</b> Unable to call tar '$untar'");
		    }
		} elseif ($mimetype == 'application/zip') {	// Handle good old zippoz
		    $unzip = '/usr/bin/unzip';
		    if (is_executable($unzip)) {
			system("cd $dest_dir; $unzip $archive > /dev/null");
		    } else {
			die("<b>Fatal:</b> Unable to call unzip '$unzip'");
		    }
		} else {
		    die("<b>Fatal:</b> This packaging format is currently not supported. Contact sys-admin!");
		}
		if (!unlink("$dest_dir/$archive")) {
		    echo "<b>Warning:</b> Unable to unlink tar archive: '$dest_dir/$archive'";
		}
		$xslt_rendering = $_SERVER['DOCUMENT_ROOT'] . "/" . $args['portal_root'] . "/xslt-render";
		if (is_executable($xslt_rendering)) {
		    if (!($dh = opendir($dest_dir))) {
			die("<b>Fatal:</b> Unable to open directory '$dest_dir'");
		    }
		    $found = "";
		    while (strlen($dir = readdir($dh))) {		// Check if we have the needed ingredients...
			if ($dir == ".." or $dir == ".") {
			    continue;
			}
			$found = $dir;
		    }
		    closedir($dh);
		    if (strlen($found)) {
			$object_dir = "$dest_dir/$found";
			if (!($dh = opendir($object_dir))) {
			    die("<b>Fatal:</b> Unable to open binary directory '$object_dir'");
			}
			$stylesheet = "";
			$xml_doc = "";
			while (strlen($entry = readdir($dh))) {		// And check if we have the XML and XSLT...
			    if (preg_match("/\.xsl$/", $entry)) {
				$stylesheet = $entry;
			    } elseif (preg_match("/\.xml$/", $entry)) {
				$xml_doc = $entry;
			    }
			}
			closedir($dh);

			if (strlen($xml_doc) && strlen($stylesheet)) {
			    
			    // Perform the rendering...
			    passthru("cd $object_dir; $xslt_rendering $xml_doc $stylesheet > index.html");
			    
			    // Maybe we should copy the index.html and images directory a step down instead of using soft-links...
			    passthru("cd $dest_dir; ln -s $found/index.html index.html");
			    passthru("cd $dest_dir; ln -s $found/images images");
			}
		    }
		} else {
		    die("<b>Fatal:</b> Unable to render uploaded TEI archive, no such script '$xslt_rendering'");
		}
		$ret .= "  <object>$dest_dir_rel</object>\n";
		$ret .= "</upload>\n";
		return $ret;
	    }
	}
	
	
	if (!function_exists('upload_other_handler')) {
	    
	    function upload_other_handler ($args) {		// Handle uploading of unknown stuff
		echo "FIXME: Write other handler<br/>";
	    }
	}
	
	
	if (!function_exists('move_uploaded_stuff')) {
	    function move_uploaded_stuff (&$args) {
		$tkl_file = $args['tkl_doc'];
		$tmp = $args['tmp'];	// The temporary location of the uploaded object
		$sid = $args['sid'];
		$args['filename'] = preg_replace("/[^A-ZA-z0-9\.]/", "_", $args['filename']);
		$bin_cat = preg_replace("/\.[^\.]*$/", "", $tkl_file);
		$dest_dir_rel = $args['portal_root'] . "/" . $args['portal_abs_dir'] . "/$bin_cat";
		$dest_dir = $_SERVER['DOCUMENT_ROOT'] . "/" . $dest_dir_rel;
		$dest = $dest_dir . "/" . $args['filename'];
		if (!is_dir($dest_dir)) {
		    if (!mkdir($dest_dir, 0755)) {
			die("<b>Fatal:</b> Unable to create binary storage dir '$dest_dir'");
		    }
		}
		$dest_tmp = $dest_dir . "/$sid-" . $args['filename'];
		$args['dest_final'] = $dest;
		$args['dest_tmp'] = $dest_tmp;
		if (file_exists($args['dest_final'])) {
		    return "<error>File already exists</error>";
		}
		if (file_exists($dest_tmp)) {
		    return "<error>Temporary file already exists</error>";
		}
		if (!copy($tmp, $dest_tmp)) {
		    die("<b>Fatal:</b> Unable to copy file from '$tmp' to '$dest_tmp'");
		}
		if (!unlink($tmp)) {
		    echo "<b>Warning:</b> Unable to remove temporary file '$tmp'<br/>";
		}
		$args['dest_dir'] = $dest_dir;
		$args['dest_dir_rel'] = $dest_dir_rel;
	    }
	}
	
	
	if ($type = $supported_mimes[$mime]) {
	    $upload_handler = "upload_" . $type . "_handler";
	    if (strlen($msg = move_uploaded_stuff($args))) {
		return $return_header . "<upload>$msg</upload>";
	    }
	    if ($debug) {
		print_r($args);
		echo "Identified mime-type: $mime<br/>";
	    }
	    if (function_exists($upload_handler)) {
		$ret = $return_header . "\n";
		$ret .= call_user_func($upload_handler, $args);
		return $ret;
	    } else {
		die("<b>Fatal:</b> Couldn't find upload handler function '$upload_handler'");
	    }
	} else {
	    echo "<b>Warning:</b> Unsupported mime-type '$mime'<br/>";
	    return "";
	}

    }
}

$return_header = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
if ($args['action'] == 'upload') {
    if ($args['tmp'] == 'none') {		// Did we actually get something?
	return "";
    }
    if (!strlen($mime = strtolower($args['mimetype']))) {	// Not to forget the mime-type...
	return "";
    }
    return exec_upload($args);
} elseif ($args['action'] == 'delete') {	// Delete files associated with this element
    if (!strlen($args['content'])) {
	return "";
    }
    $sid = $args['sid'];
    $raw_xml = "<?xml version=\"1.0\"?>\n" . $args['content'];
    if (!($dom = domxml_open_mem($raw_xml))) {
	die("<b>Fatal:</b> upload_handle: Unable to parse XML:<pre>\n" . $raw_xml . "\n</pre>");
    }
    $root = $dom->document_element();
    $delete_list = array();
    if (strlen($thumbnail = $root->get_attribute('preview'))) {	// Identify thumbnail if it is there...
	$delete_list[] = $thumbnail;
    }
    if (is_array($kids = $root->child_nodes())) {	// Browse through the XML and look for 'object' elements
	foreach ($kids as $kid) {
	    if ($kid->node_type() == XML_ELEMENT_NODE) {
		if ($kid->tagname == 'object') {
		    $cdata_node = $kid->first_child();
		    $delete_list[] = $cdata_node->content;
		}
	    }
	}
    } else {
	die("<b>Fatal:</b> Wrong structure of upload XML:<pre>\n$raw_xml\n</pre>");
    }
    foreach ($delete_list as $file) {
	$abs_file = $_SERVER['DOCUMENT_ROOT'] . "/$file";
	if ($debug) {
	    echo "Deleting file '$abs_file'<br/>";
	}
	if (!copy($abs_file, "$abs_file.$sid.delete")) {
	    echo "<b>Warning:</b> Unable to prepare file '$abs_file' for deletion<br/>";
	}
    }
    return "";
} elseif ($args['action'] == 'commit') {
    $sid = $args['sid'];
    $cwd = $args['portal_root'] . "/" . $args['portal_abs_dir'];
    $tkl_file = $args['tkl_doc'];
    $sub_dir = preg_replace("/\.[^\.]*$/", "", $tkl_file);
    $this_dir = $_SERVER['DOCUMENT_ROOT'] . "/$cwd/$sub_dir";
    if (!($dh = @opendir($this_dir))) {
	echo "<b>Warning:</b> Unable to open dir '$this_dir'<br/>";
    } else {
	while (strlen($entry = readdir($dh))) {		// Check if something should be deleted
	    if (preg_match("/(.*?)\.$sid\.delete$/", $entry, $match)) { // If not yet committed, check status...
		passthru("rm -rf $this_dir/" . $match[1]); 
		passthru("rm -rf $this_dir/$entry");
	    }
	}
	closedir($dh);
    }
    if (!($dh = @opendir($this_dir))) {
	echo "<b>Warning:</b> Unable to open dir '$this_dir'<br/>";
    } else {
	while (strlen($entry = readdir($dh))) {		// Now, move uploaded tmps to their final names...
	    if (preg_match("/DIR-([^\-]+)\-(.*)/", $entry, $match)) {
		if ($match[1] == $sid) {
		    passthru("mv $this_dir/$entry $this_dir/DIR-" . $match[2]);
		}
	    } elseif (preg_match("/([^\-]+)\-(.*)/", $entry, $match)) {
		if ($match[1] == $sid) {	// One of ours?
		    passthru("mv $this_dir/$entry $this_dir/" . $match[2]); 
		}
	    }
	}
	closedir($dh);
    }
    $tkl_file_path = $_SERVER['DOCUMENT_ROOT'] . "/$cwd/$tkl_file";
    $tkl_raw = join("", file($tkl_file_path));
    $tkl_raw = preg_replace("/$sid\-/", "", $tkl_raw);
    passthru("cp $tkl_file_path $tkl_file_path.tmp");
    if (!($fh = fopen($tkl_file_path, "w"))) {
	die("<b>Fatal:</b> Unable to open file '$tkl_file_path' for writing");
    }
    fputs($fh, $tkl_raw);
    fclose($fh);
    return "";
} elseif ($args['action'] == 'cleanup') {	// Remove all files with the correct session prefix....
    $sid = $args['sid'];
    $tkl_file = $args['tkl_doc'];
    $sub_dir = preg_replace("/\.[^\.]*$/", "", $tkl_file);
    $cwd = $args['portal_root'] . "/" . $args['portal_abs_dir'];
    $this_dir = $_SERVER['DOCUMENT_ROOT'] . "/$cwd/$sub_dir";
    $file_pattern = "$this_dir/$sid-*";		// Remove uploaded files
    passthru("rm -f $file_pattern");
    $delete_pattern = "$this_dir/*.$sid.delete";	// Remove files prepared for deletion...
    passthru("rm -f $delete_pattern");
    $archive_pattern = "$this_dir/DIR-$sid*";		// If there are uploaded archives, remove them...
    passthru("rm -rf $archive_pattern");
    return "";
} else {
    die("<b>Fatal:</b> Unknown type of action '" . $args['action'] . "'");
}
