<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  exclude-result-prefixes="oai_dc dc"
  version="1.0">

<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
    

<xsl:template match="/metadata">
  <xsl:choose>
    <xsl:when test="@created">
      <link origin="oai" creator="tkl-oai-harvester" created="{string(@created)}" confirm="360">
         <xsl:apply-templates select="oai_dc:dc"/>
      </link>
    </xsl:when>
    <xsl:otherwise>
      <link origin="oai" creator="tkl-oai-harvester" confirm="360">
         <xsl:apply-templates select="oai_dc:dc"/>
      </link>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="oai_dc:dc">
       <xsl:call-template name="unique_title"/>
       <!-- <xsl:apply-templates select="dc:title"/> -->
       <xsl:apply-templates select="dc:creator"/>
       <xsl:apply-templates select="dc:subject"/>
       <xsl:apply-templates select="dc:description"/>
       <xsl:apply-templates select="dc:publisher"/>
       <!-- <xsl:apply-templates select="dc:contributor"/> -->
       <!-- <xsl:apply-templates select="dc:date"/> -->
       <xsl:apply-templates select="dc:type"/>
       <xsl:apply-templates select="dc:format"/>
       <xsl:apply-templates select="dc:identifier"/>
       <!-- <xsl:apply-templates select="dc:source"/> -->
       <xsl:apply-templates select="dc:language"/>
       <!-- <xsl:apply-templates select="dc:relation"/> -->
       <!-- <xsl:apply-templates select="dc:coverage"/> -->
       <!-- <xsl:apply-templates select="dc:rights"/> -->

       <def-status>OK</def-status>
       <comment>OAI hsted</comment>
</xsl:template>

<xsl:template name="unique_title">
  <xsl:variable name="da_titles" select="./dc:title[@xml:lang='da']"/>
  <xsl:variable name="en_titles" select="./dc:title[@xml:lang='en']"/>
  <xsl:variable name="titles" select="./dc:title[not(@xml:lang)]"/>

    <xsl:choose>
      <xsl:when test="$da_titles[1]">
         <title xml:lang="da"><xsl:value-of select="$da_titles[1]"/></title>
      </xsl:when>
      <xsl:when test="$titles[1]">
         <title xml:lang="da"><xsl:value-of select="$titles[1]"/></title>
      </xsl:when>
      <xsl:otherwise>
         <title xml:lang="da">Ingen Titel</title>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="$en_titles[1]">
         <title xml:lang="en"><xsl:value-of select="$en_titles[1]"/></title>
      </xsl:when>
      <xsl:when test="$titles[1]">
         <title xml:lang="en"><xsl:value-of select="$titles[1]"/></title>
      </xsl:when>
      <xsl:otherwise>
         <title xml:lang="en">No Title</title>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:title">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <title xml:lang="{$lang}"><xsl:value-of select="."/></title>
      </xsl:when>
      <xsl:otherwise>
        <title xml:lang="da"><xsl:value-of select="."/></title>
        <title xml:lang="en"><xsl:value-of select="."/></title>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:creator">
    <creator><xsl:value-of select="."/></creator>
</xsl:template>

<xsl:template match="dc:subject">
    <subject><xsl:value-of select="."/></subject>
</xsl:template>

<xsl:template match="dc:description">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <description xml:lang="{$lang}"><xsl:value-of select="."/></description>
      </xsl:when>
      <xsl:otherwise>
        <description xml:lang="da"><xsl:value-of select="."/></description>
        <description xml:lang="en"><xsl:value-of select="."/></description>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:publisher">
    <publisher><xsl:value-of select="."/></publisher>
</xsl:template>

<xsl:template match="dc:contributor">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <contributor xml:lang="{$lang}"><xsl:value-of select="."/></contributor>
      </xsl:when>
      <xsl:otherwise>
        <contributor><xsl:value-of select="."/></contributor>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:date">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <date xml:lang="{$lang}"><xsl:value-of select="."/></date>
      </xsl:when>
      <xsl:otherwise>
        <date><xsl:value-of select="."/></date>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:type">
    <type><xsl:value-of select="."/></type>
</xsl:template>

<xsl:template match="dc:format">
    <format><xsl:value-of select="."/></format>
</xsl:template>

<xsl:template match="dc:identifier">
    <identifier><xsl:value-of select="."/></identifier>
</xsl:template>

<xsl:template match="dc:source">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <source xml:lang="{$lang}"><xsl:value-of select="."/></source>
      </xsl:when>
      <xsl:otherwise>
        <source><xsl:value-of select="."/></source>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:language">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <language xml:lang="{$lang}"><xsl:value-of select="."/></language>
      </xsl:when>
      <xsl:otherwise>
        <language><xsl:value-of select="."/></language>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:relation">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <relation xml:lang="{$lang}"><xsl:value-of select="."/></relation>
      </xsl:when>
      <xsl:otherwise>
        <relation><xsl:value-of select="."/></relation>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:coverage">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <coverage xml:lang="{$lang}"><xsl:value-of select="."/></coverage>
      </xsl:when>
      <xsl:otherwise>
        <coverage><xsl:value-of select="."/></coverage>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="dc:rights">
    <xsl:variable name="lang" select="@xml:lang"/>
    <xsl:choose>
      <xsl:when test="$lang">
        <rights xml:lang="{$lang}"><xsl:value-of select="."/></rights>
      </xsl:when>
      <xsl:otherwise>
        <rights><xsl:value-of select="."/></rights>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>



<xsl:template match="*"/>


<xsl:template name="international3to2">
    <xsl:if test="@xml:lang">
        <xsl:attribute name="xml:lang">
            <xsl:choose>
                <xsl:when test="@lang = 'dan'">da</xsl:when>
                <xsl:when test="@lang = 'eng'">en</xsl:when>
                <xsl:when test="@lang = 'swe'">sv</xsl:when>
                <xsl:when test="@lang = 'nno'">no</xsl:when>
                <xsl:otherwise><xsl:value-of select="@lang"/></xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:if>
    <xsl:value-of select="."/>
</xsl:template>

</xsl:stylesheet>

