<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: document.xsl,v 1.7 2003/09/09 14:31:32 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:param name="showimage"/>

    <xsl:output method="html" encoding="UTF-8"/>

<xsl:template match="/document">
    <xsl:call-template name="main-page">
        <xsl:with-param name="title" select="title"/>
    </xsl:call-template>
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<xsl:template name="main-body">
    <xsl:call-template name="insert-path"/>
    <xsl:choose>
      <xsl:when test="$showimage"><xsl:call-template name="show-image"/></xsl:when>
      <xsl:otherwise>
	<p/>
	<em><xsl:copy-of select="abstract"/></em>
	<p/>
	<xsl:value-of select="creator"/>
	<p/>

	<xsl:if test="illustration">
	  <table align="right">
	    <xsl:for-each select="illustration">
	      <tr><td>
	      <a href="?showimage={position()}">
		<img src="/{picture/upload/@preview}" align="right" border="0">
		  <xsl:if test="description">
		    <xsl:attribute name="alt"><xsl:value-of select="description"/></xsl:attribute>
		  </xsl:if>
		</img>
	      </a>
	      </td></tr>
	    </xsl:for-each>
	  </table>
	</xsl:if>

	<xsl:copy-of select="body/node()"/>

	<xsl:variable name="subdocs"
	     select="document('tkl-find://?path=*/index.tkl&amp;select=title')"/>

	<xsl:if test="$subdocs/*/file">
	    <ul>
	    <p/>
	    <xsl:for-each select="$subdocs/*/file">
		<li><a href="{@path}"><xsl:value-of select="title"/></a></li>
	    </xsl:for-each>
	    </ul>
	</xsl:if>
	<p/>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="show-image">
  <p/>
  <a href="." xml:lang="en">Go back</a>
  <a href="." xml:lang="da">Tilbage</a>
  <p/>
  <img src="/{illustration[position() = $showimage]/picture/upload/object[@scale = 'web']}"/>
  
  <p align="center"><xsl:value-of select="illustration[position() = $showimage]/description"/></p>
  <br/>
  &#xa0;
</xsl:template>

</xsl:stylesheet>

