<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: interface.xsl,v 1.6 2003/09/09 14:31:32 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    version="1.0">

    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="root"/>
    <xsl:param name="query"/>

    <xsl:variable name="mainpage" select="document('tkl-file://index.tkl')"/>

<xsl:template name="main-page">
    
<xsl:param name="title"/>

<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title>Bibliotheca - <xsl:value-of select="$title"/></title>
        <link rel="stylesheet" type="text/css" href="{$root}/styles.css" />
        <link rel="stylesheet" type="text/css" href="{$root}/targets/css/styles.css" />
        <link rel="author" href="http://www.indexdata.dk" />
	<xsl:call-template name="script"/>
    </head>
    <body>
            <!-- Main table -->
                <table cellpadding="0" cellspacing="0" width="752" border="0">
                    <!-- Top column -->
                    <tr class="top">
                        <td width="382" align="left" valign="top"><img src="{$root}/gfx/headline.gif" width="382" height="73" alt="Bibliotheca" /></td>
                        <td width="370" align="right" valign="top"><img src="{$root}/gfx/headimage.jpg" width="367" height="73" alt="Bibliotheca" /></td>
                    </tr>
                    <!-- Space -->
                    <tr class="void">
                        <td class="void" height="2" colspan="2">&#xa0;</td>
                    </tr>
                    <!-- Generic menu -->
                    <tr>
                        <td class="functions" height="29" align="left">
                            &#xa0;&#xa0;
                            <a class="functions" href="{$root}/">
                                <span xml:lang="da">Til forsiden</span>
                                <span xml:lang="en">Front page</span>
                            </a>
                            <img src="{$root}/gfx/dot_grey.gif" width="20" height="6" alt=" " />
                            <a class="functions" href="{$root}/suggest/">
                                <span xml:lang="da">Foresl&#xe5; link</span>
                                <span xml:lang="en">Suggest link</span>
                            </a>
                            <img src="{$root}/gfx/dot_grey.gif" width="20" height="6" alt=" " />
                            <a class="functions" href="mailto:{$mainpage/*/creator/@email}">
                                <span xml:lang="da">Kontakt Bibliotheca</span>
                                <span xml:lang="en">Contact Bibliotheca</span>
                            </a>
                            <img src="{$root}/gfx/dot_grey.gif" width="20" height="6" alt=" " />
                            <a class="functions" href="{$root}/help/">
                                <span xml:lang="da">Hj&#xe6;lp</span>
                                <span xml:lang="en">Help</span>
                            </a>
                        </td>
                            <form action="{$root}/search.tkl" method="get" name="form">
                        <td class="functions" align="right" valign="middle">
                                <span xml:lang="da">S&#xf8;g i Bibliotheca</span>
                                <span xml:lang="en">Search Bibliotheca</span>:&#xa0;&#xa0;
                                <input type="text" value="{$query}" name="query" size="20" style="display: inline; font-size:12px;" class="forminput" />
                                    &#xa0;&#xa0;
                                <a class="functions" href="javascript:document.form.submit()">
                                    OK
                                    <input type="image" src="{$root}/gfx/arrow_grey_right.gif" width="17" height="6" border="0" alt="S&#xf8;g" />
                                </a>
                        </td>
                             </form>
                    </tr>
                    <!-- Space -->
                    <tr class="void">
                        <td class="void" colspan="2" height="2">&#xa0;</td>
                    </tr>
                    <!-- Wrapper table -->
                    <tr>
                        <td colspan="2">
                            <table cellpadding="0" cellspacing="0" width="752" border="0">
                                <tr>
                                    <!-- Navigation menu -->

				    <xsl:call-template name="navigation-menu"/>
                                    
				    <!-- Space -->
                                    <td width="14">&#xa0;</td>
                                    <!-- Content -->

				    <xsl:call-template name="body-holder"/>
                                    
				    <xsl:call-template name="right-menu"/>
                                    
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">&#xa0;</td>
                    </tr>
                </table>
    </body>
</html>
</xsl:template>


<xsl:template name="script">
  <script language="JavaScript">
    // Frame killer...
    if(self != top)top.location.href = self.location.href;
  </script>
</xsl:template>


<xsl:template name="body-holder">
  <td width="420" class="bodyarea" valign="top">
    <!-- BODY -->
    <xsl:call-template name="main-body"/>
  </td>
</xsl:template>

<xsl:template name="right-menu">
  <!-- Space -->
  <td width="14">&#xa0;</td>
  <!-- News menu -->

  <td class="news" width="152" height="344" valign="top">
    <table cellpadding="0" cellspacing="0" width="152">
      <tr>
        <td height="302" valign="top">
	  <table cellpadding="0" cellspacing="0" width="152">
	 
	    <!-- NEWS!!! -->
	 
	    <xsl:call-template name="main-news"/>
	 
	  </table>
        </td>
      </tr>
      <tr>
        <td height="42" valign="top">
          <table cellpadding="0" cellspacing="0" width="152">
	    <tr>
	      <td colspan="2" style="line-height: 8px;" class="dotted">&#xa0;</td>
	    </tr>
	  </table>
        </td>
      </tr>
    </table>
  </td>
</xsl:template>


<xsl:template name="navigation-content">
  <table cellpadding="0" cellspacing="0" width="152">
    <tr>
      <td height="302" valign="top">
        <table cellpadding="0" cellspacing="0" width="152">
	  <tr class="void">
	    <td width="131" height="4" >&#xa0;</td>
	    <td width="21">&#xa0;</td>
	  </tr>
	  <tr>
	    <td align="right" class="navigation" height="15">MENU&#xa0;</td>
	    <td>&#xa0;</td>
	  </tr>
	  <tr>
	    <td colspan="2" style="line-height: 11px;" class="dotted">&#xa0;</td>
	  </tr>
	  
	  <!-- Dynamic menu -->
	  
	  <xsl:call-template name="menu"/>
	  
	  <tr style="line-height: auto;">
	    <td>&#xa0;</td>
	    <td>&#xa0;</td>
	  </tr>

	  <!-- Local extension to navigation panel -->
	  
	  <xsl:call-template name="left-menu"/>
	  
	  <tr style="line-height: auto;">
	    <td>&#xa0;</td>
	    <td>&#xa0;</td>
	  </tr>
	</table>
      </td>
    </tr>
    <tr>
      <td height="42" valign="top">
        <table cellpadding="0" cellspacing="0" width="152">
	  <tr>
	    <td colspan="2" style="line-height: 8px;" class="dotted">&#xa0;</td>
	  </tr>
	  <tr>
	    <xsl:variable name="sel_targets" select="document('tkl-targets:?type=selected')/targets"/>
	    <xsl:variable name="url_append">
	      <xsl:for-each select="$sel_targets/target">&amp;host[]=<xsl:value-of select="nick"/></xsl:for-each>
	    </xsl:variable>
	    <td align="right" width="131">
	      <a xml:lang="da" href="?lang=en{$url_append}" class="navigation">In English</a>
	      <a xml:lang="en" href="?lang=da{$url_append}" class="navigation">P&#xe5; dansk</a>
	    </td>
	    <td valign="middle" width="21" align="center"><img src="{$root}/gfx/arrow_brown_right.gif" width="10" height="8" alt="In English" /></td>
	  </tr>
	  <tr>
	    <td align="right"><a href="mailto:{$mainpage/*/creator/@email}" class="navigation"><span xml:lang="da">Kontakt webmaster</span><span xml:lang="en">Contact webmaster</span></a></td>
	    <td valign="middle" align="center"><img src="{$root}/gfx/arrow_brown_right.gif" width="10" height="8" alt="Kontakt webmaster" /></td>
	  </tr>
	</table>
      </td>
    </tr>
  </table>
</xsl:template>


<xsl:template name="navigation-menu">
  <td class="navigation" width="152" height="344" valign="top">
    <xsl:call-template name="navigation-content"/>
  </td>
</xsl:template>

<xsl:template name="main-news">
    <tr class="void">
	<td width="9">&#xa0;</td>
	<td width="134" height="4" >&#xa0;</td>
	<td width="9">&#xa0;</td>
    </tr>
    <tr>
	<td>&#xa0;</td>
	<td align="left" height="15" class="news">
	   <b xml:lang="en">NEWS</b>
	   <b xml:lang="da">NYHEDER</b>
	   &#xa0;</td>
	<td>&#xa0;</td>
    </tr>
    <tr>
	<td colspan="3" style="line-height: 11px;" class="dotted">&#xa0;</td>
    </tr>

    <xsl:call-template name="main-news-content"/>

</xsl:template>

<!-- This is just a placeholder -->
<xsl:template name="main-news-content">
    <tr><td colspan="3"><b>No News!</b></td></tr>
</xsl:template>

<!-- This is just a placeholder -->
<xsl:template name="main-body">
    <b>No Body!</b>
</xsl:template>

<!-- produces path of "breadcrumbs" back to the root -->
<xsl:template name="insert-path">
    <xsl:variable name="path" select="document('tkl-path://?select=title')/tkl-path"/>
    <p class="brown"><b>
    <xsl:for-each select="$path/step">
      <xsl:choose>
      <xsl:when test="following-sibling::step">
	<a href="{@path}"><xsl:value-of select="title"/></a> 
	    &#xa0;<img src="{$root}/gfx/arrow_brown_right.gif" width="10"
	         height="8" alt=" " />&#xa0;
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="."/>
      </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
    </b></p>
</xsl:template>


<xsl:template name="menu">
    <xsl:for-each select="$mainpage/*/menuitem">
	<tr>
	   <td align="right">
	       <a href="{concat($root, @path)}" class="navigation">
		   <xsl:value-of select="."/>
		</a>
	    </td>
	   <td valign="middle" align="center">
	       <img src="{$root}/gfx/arrow_brown_right.gif" width="10"
		   height="8"/>
	   </td>
	</tr>
    </xsl:for-each>
</xsl:template>

<xsl:template name="left-menu">
</xsl:template>

</xsl:stylesheet>
