<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: news.xsl,v 1.4 2003/09/09 14:31:32 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    version="1.0">

<xsl:output method="html" encoding="UTF-8"/>

<xsl:variable name="howmany" select="'4'"/> <!-- How many news entries? -->

<xsl:template name="read-news">
    <xsl:variable name="news" select=
        "document('tkl-find://?path=/news/news*.tkl&amp;select=date|title')"/>

    <!-- This bit constructs a sorted list of news -->
    <xsl:variable name="newsset">
       <xsl:for-each select="$news/*/file">
	 <xsl:sort select="date" order="descending"/>
	 <xsl:copy-of select="."/>
       </xsl:for-each>
    </xsl:variable>

    <!-- And here we display the most recent news -->
    <xsl:for-each select="$newsset/file[position() &lt;= $howmany]">

    <tr>
	<td>&#xa0;</td>
	<td align="left" class="news"><xsl:value-of select="date"/></td>
	<td>&#xa0;</td>
    </tr>
    <tr>
	<td>&#xa0;</td>
	<td align="left"><a href="{$root}/news/#{date}" class="news">
	    <xsl:value-of select="title"/>
	</a></td>
	<td>&#xa0;</td>
    </tr>
    <tr class="void">
	<td height="12" colspan="3">&#xa0;</td>
    </tr>

    </xsl:for-each>

    <xsl:if test="count($newsset/file) &gt; $howmany">
        <tr><td>&#xa0;</td><td colspan="2"><a href="{$root}/news/" class="news"><b><span xml:lang="da">Flere Nyheder</span><span xml:lang="en">More News</span></b></a></td></tr>
    </xsl:if>

</xsl:template>


</xsl:stylesheet>
